/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarViewer {
    public void execute(String file_name) {
        ZipEntry ze = null;
        ZipFile zipFile = null;
        InputStream zis = null;
        Enumeration<? extends ZipEntry> zipEntries = null;
        try {
            zipFile = new ZipFile(file_name);
        }
        catch (IOException e) {
            System.out.println("Failed to open jarfile: " + e);
            System.exit(1);
        }
        ze = zipFile.getEntry("META-INF/MANIFEST.MF");
        System.out.println("\n-------------------manifest-------------------");
        if (ze == null) {
            System.out.println("Entry META-INF/MANIFEST.MF not found");
        } else {
            try {
                zis = zipFile.getInputStream(ze);
                while (zis.available() > 0) {
                    System.out.write(zis.read());
                }
            }
            catch (IOException e) {
                System.out.println("Failure while reading manifest: " + e);
            }
        }
        ze = zipFile.getEntry("service.properties");
        System.out.println("\n--------------service.properties--------------");
        if (ze == null) {
            System.out.println("Entry service.properties not found");
        } else {
            try {
                zis = zipFile.getInputStream(ze);
                while (zis.available() > 0) {
                    System.out.write(zis.read());
                }
            }
            catch (IOException e) {
                System.out.println("Failure while reading properties: " + e);
            }
        }
        zipEntries = zipFile.entries();
        System.out.println("\n---------------jar file entries---------------");
        while (zipEntries.hasMoreElements()) {
            System.out.println(zipEntries.nextElement());
        }
        try {
            zipFile.close();
        }
        catch (IOException e) {
            System.out.println("Failed to close jarfile: " + e);
            System.exit(1);
        }
        System.out.println("\n");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: JarViewer jarFile");
            System.exit(1);
        }
        JarViewer app = new JarViewer();
        app.execute(args[0]);
        System.exit(0);
    }
}

