/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.MetadataPacket;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.PortNotFound;

public class GetMetadata {
    public static void printUsage() {
        System.err.println("\n usage: getMetadata nodeURL commPortName <components...>");
        System.err.println("  components:");
        System.err.println("  s - service state");
        System.err.println("  p - service properties");
        System.err.println("  c - service cache");
        System.err.println("  x - service xml file");
        System.err.println("  i - instrument state");
        System.err.println("  a - components (default)");
        System.err.println("  l - log sample (for testing)");
    }

    public static void main(String[] args) {
        Node node = null;
        Device[] devices = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length < 2) {
            GetMetadata.printUsage();
            System.exit(1);
        }
        String nodeURL = args[0];
        int components = 0;
        boolean logPacket = false;
        if (args.length >= 3) {
            if (args[2].toLowerCase().indexOf("h") >= 0) {
                GetMetadata.printUsage();
                System.exit(1);
            }
            if (args[2].indexOf("a") >= 0) {
                components |= 0x1F;
            }
            if (args[2].indexOf("s") >= 0) {
                components |= 4;
            }
            if (args[2].indexOf("p") >= 0) {
                components |= 8;
            }
            if (args[2].indexOf("c") >= 0) {
                components |= 0x10;
            }
            if (args[2].indexOf("x") >= 0) {
                components |= 2;
            }
            if (args[2].indexOf("i") >= 0) {
                components |= 1;
            }
            if (args[2].indexOf("l") >= 0) {
                logPacket = true;
            }
            if (components == 0) {
                components |= 0x1F;
            }
            if (components < 0 || components > 31) {
                GetMetadata.printUsage();
                System.exit(1);
            }
        } else {
            components |= 0x1F;
        }
        try {
            System.out.println("Looking for node server stub at " + nodeURL);
            node = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(node.getName()) + "\"");
            devices = node.getDevices();
            int i = 0;
            while (i < 1) {
                try {
                    Device device = node.getDevice(args[i + 1].getBytes());
                    if (device instanceof Instrument) {
                        Instrument instrument = (Instrument)device;
                        System.out.println("Requesting packet...components = 0x" + Integer.toHexString(components));
                        MetadataPacket packet = device.createMetadataPacket("just checking", components, logPacket);
                        System.out.println("Packet received:\n");
                        System.out.println(new String(packet.getBytes()));
                    } else {
                        System.err.println("Device on port " + args[i + 1] + " is not an Instrument");
                    }
                }
                catch (PortNotFound e) {
                    System.err.println("Port " + args[i + 1] + " not found");
                }
                catch (DeviceNotFound e) {
                    System.err.println("Device not found on port " + args[i + 1]);
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

