/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Date;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.SensorDataPacket;

public class ClientTest {
    public static void main(String[] args) {
        Node nodeService = null;
        Device[] devices = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length != 1) {
            System.err.println("Usage: nodeURL");
            return;
        }
        String nodeURL = args[0];
        try {
            System.out.println("Looking for node server stub at " + nodeURL);
            nodeService = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(nodeService.getName()) + "\"");
        }
        catch (Exception e) {
            System.err.println("Caught exception: " + e.getMessage());
            System.err.println("Couldn't get service at \"" + nodeURL + "\"");
            return;
        }
        try {
            devices = nodeService.getDevices();
            System.out.println("Node has " + devices.length + " devices");
            int i = 0;
            while (i < devices.length) {
                System.out.println("\nDevice " + new String(devices[i].getName()) + ", port " + new String(devices[i].getCommPortName()));
                Instrument instrument = (Instrument)devices[i];
                System.out.println("Getting latest data...");
                try {
                    SensorDataPacket packet = instrument.getData();
                    String timestamp = DateFormat.getDateTimeInstance().format(new Date(packet.systemTime()));
                    System.out.println(timestamp + ":\n" + new String(packet.dataBuffer()) + "\n");
                }
                catch (NoDataException e) {
                    System.err.println("No data from instrument");
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            return;
        }
    }
}

