/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.PortNotFound;

public class AnnotateService {
    public static final int MAX_ANNOTATION_SIZE = 512;

    public void showUsage(String[] args) {
        if (args != null) {
            System.err.println("args.length=" + args.length);
            int i = 0;
            while (i < args.length) {
                System.err.println("arg: " + args[i]);
                ++i;
            }
        }
        System.err.println("usage: AnnotateService nodeURL commPortName [-f|-s] annotation");
        System.err.println("-f get annotation data from a file");
        System.err.println("-s get annotation data from a cmd line");
    }

    public int execute(String[] args) {
        block15: {
            Node node = null;
            Object devices = null;
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            if (args.length != 4) {
                this.showUsage(null);
                return 1;
            }
            String nodeURL = args[0];
            String portName = args[1];
            String annotationSrc = args[2];
            String annotation = args[3];
            try {
                System.out.println("Looking for node server stub at " + nodeURL);
                node = (Node)Naming.lookup(nodeURL);
                System.out.println("Got proxy for node service \"" + new String(node.getName()) + "\"");
                Device device = node.getDevice(portName.getBytes());
                if (!(device instanceof Instrument)) {
                    System.err.println("Device service on port " + portName + " is not an Instrument");
                    return 1;
                }
                Instrument instrument = (Instrument)device;
                if (annotationSrc.compareTo("-s") == 0) {
                    instrument.annotate(annotation.getBytes());
                    break block15;
                }
                if (annotationSrc.compareTo("-f") == 0) {
                    FileInputStream input = null;
                    try {
                        input = new FileInputStream(annotation);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("Couldn't find file: " + annotation);
                        return 1;
                    }
                    StringBuffer str_buff = new StringBuffer(512);
                    try {
                        int i = 0;
                        while (input.available() > 0 && i++ < 512) {
                            str_buff.append((char)input.read());
                        }
                    }
                    catch (IOException e) {
                        System.out.println("Failure reading file: " + annotation);
                        return 1;
                    }
                    instrument.annotate(str_buff.toString().getBytes());
                    break block15;
                }
                System.out.println("I don't understand annotate source: " + annotationSrc);
                this.showUsage(null);
                return 1;
            }
            catch (PortNotFound e) {
                System.err.println("Port \"" + portName + "\" not found");
                return 1;
            }
            catch (DeviceNotFound e) {
                System.err.println("No device service found on port " + portName);
                return 1;
            }
            catch (RemoteException e) {
                System.err.println("RemoteException: " + e.getMessage());
                return 1;
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getMessage());
                return 1;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        AnnotateService app = new AnnotateService();
        int retval = app.execute(args);
        System.exit(retval);
    }
}

