/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.Node;

public class AddScheduleEntry {
    public static void main(String[] args) {
        Node nodeService = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length < 4) {
            System.err.println("Usage: nodeURL scheduleFile isiID entry");
            System.exit(1);
        }
        String nodeURL = args[0];
        String scheduleFile = args[1];
        long ownerID = -1L;
        try {
            ownerID = Long.parseLong(args[2]);
        }
        catch (NumberFormatException e) {
            System.err.println("Usage: nodeURL scheduleFile isiID entry");
            System.exit(1);
        }
        String entry = args[3];
        try {
            System.out.println("Looking for node service at " + nodeURL);
            nodeService = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(nodeService.getName()) + "\"");
        }
        catch (Exception e) {
            System.err.println("Caught exception: " + e.getMessage());
            System.err.println("Couldn't get service at \"" + nodeURL + "\"");
            System.exit(1);
        }
        try {
            System.out.println("AddScheduleEntry adding " + entry + " to " + scheduleFile);
            byte[] stat = nodeService.addScheduleEntry(scheduleFile.getBytes(), ownerID, entry.getBytes());
            System.out.println(new String(stat));
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Got some exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

