/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.portal;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;
import moos.deployed.DeviceLog;
import moos.interfaces.leasing.LeaseRefused;
import moos.interfaces.portal.PortalProxy;
import moos.interfaces.portal.Portals;
import moos.interfaces.portal.QueuedCommand;
import moos.interfaces.portal.UnknownConfiguration;
import moos.ssds.jms.PublisherComponent;
import org.mbari.isi.interfaces.Authentication;
import org.mbari.isi.interfaces.AuthenticationException;
import org.mbari.isi.interfaces.DeviceMessagePacket;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.DevicePacket;
import org.mbari.isi.interfaces.DevicePacketOutputStream;
import org.mbari.isi.interfaces.DevicePacketServerThread;
import org.mbari.isi.interfaces.DevicePacketSet;
import org.mbari.isi.interfaces.DevicePacketStream;
import org.mbari.isi.interfaces.Location;
import org.mbari.isi.interfaces.MetadataPacket;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.Port;
import org.mbari.isi.interfaces.SensorDataPacket;

public class PortalServer
extends PortableRemoteObject
implements PortalProxy {
    Vector _queuedCommands = new Vector();
    Vector _sentCommands = new Vector();
    InetAddress _remoteNodeAddress;
    InetAddress _publicPortalAddress;
    InetAddress _privatePortalAddress;
    Node _nodeProxy = null;
    static final int NO_LEASE = -1;
    int _leaseID = -1;
    long _nodeID = -1111L;
    long _nextConnectTime = 0L;
    long _leaseTime = 120000L;
    boolean _debug = true;
    DevicePacketServerThread _packetServer;
    static final int _packetServerPort = 4567;
    Port[] _ports = null;
    Map _devices = new HashMap();
    Map _logs = new HashMap();
    boolean _publishPackets = false;
    PublisherComponent _ssdsPublisher = null;
    long _startRetrieveTime = 0L;

    public PortalServer(String publicPortalName, String privatePortalName, String remoteNodeName, long startRetrieveTime, boolean publishPackets) throws RemoteException, UnknownHostException, IOException {
        this._publicPortalAddress = InetAddress.getByName(publicPortalName);
        this._privatePortalAddress = InetAddress.getByName(privatePortalName);
        this._remoteNodeAddress = InetAddress.getByName(remoteNodeName);
        this._publishPackets = publishPackets;
        this._packetServer = new DevicePacketServerThread(4567);
        this._packetServer.start();
        if (this._publishPackets) {
            System.out.println("JMS: Publish to topic SSDSIngestTopic");
            this._ssdsPublisher = new PublisherComponent("topic/SSDSIngestTopic");
        } else {
            System.out.println("Don't publish packets to JMS");
        }
        this._startRetrieveTime = startRetrieveTime;
        this.debugPrint("Retrieve all packets created since " + PortalServer.timeString(this._startRetrieveTime) + " (" + this._startRetrieveTime + " sec)");
    }

    protected void getLeaseTime() {
        try {
            Properties sysProperties = System.getProperties();
            String leaseTimeStr = sysProperties.getProperty("leaseTime");
            if (leaseTimeStr != null) {
                this._leaseTime = Long.parseLong(leaseTimeStr);
                this.debugPrint("Lease time is " + this._leaseTime + "ms");
            }
        }
        catch (Exception e) {
            System.err.println("Exception trying to get lease time property. " + e + " Using default.");
        }
    }

    public void initialize() {
        this.getLeaseTime();
        this.debugPrint("Checking for mooring server...");
        try {
            this.startSession();
        }
        catch (Exception e) {
            this.debugPrint("initialize(): caught exception - " + e.getMessage());
        }
    }

    public boolean connected() {
        return this.nodeConnected();
    }

    public synchronized boolean nodeConnected() {
        return this._nodeProxy != null && this._leaseID != -1;
    }

    public int getStatus() {
        return 0;
    }

    public long nextConnectTime() {
        return this._nextConnectTime;
    }

    public String getName() {
        return this._remoteNodeAddress.getHostName();
    }

    public long getId() {
        return this._nodeID;
    }

    public String getPortalHostName() {
        return this._publicPortalAddress.getHostName();
    }

    public Vector getQueuedCommands() {
        return this._queuedCommands;
    }

    public Vector getSentCommands() {
        return this._sentCommands;
    }

    protected void verify(long deviceID, Authentication authentication) throws AuthenticationException {
    }

    public DevicePacketStream getDevicePacketStream(Authentication auth) throws AuthenticationException {
        this.verify(this.getId(), auth);
        return new DevicePacketStream(this._publicPortalAddress, 4567);
    }

    public DevicePacketStream getDevicePacketStream(long sensorID, Authentication auth) throws DeviceNotFound, AuthenticationException {
        this.verify(sensorID, auth);
        return new DevicePacketStream(this._publicPortalAddress, 4567);
    }

    public Port[] getPortConfiguration() throws UnknownConfiguration {
        if (this._ports == null) {
            throw new UnknownConfiguration();
        }
        return this._ports;
    }

    void startSession() {
        this.debugPrint("startSession(): " + PortalServer.currentTimeString());
        this.debugPrint("startSession() - get node proxy");
        if (!this.connectNode()) {
            System.err.println("startSession() - not connnected!");
            return;
        }
        try {
            this._nodeID = this._nodeProxy.getId();
            this.debugPrint("\nstartSession() - get configuration " + PortalServer.currentTimeString());
            this._ports = this._nodeProxy.getPorts();
            int i = 0;
            while (i < this._ports.length) {
                try {
                    System.out.print("Port: " + new String(this._ports[i].getName()) + ", ");
                    System.out.println("service: " + new String(this._ports[i].getServiceMnemonic()) + ", deviceID: " + this._ports[i].getDeviceID());
                }
                catch (DeviceNotFound e) {
                    System.out.println("NO SERVICE");
                }
                ++i;
            }
            this.updateDeviceList(this._nodeID, this._ports);
            this.retrieveAndDistributeData();
        }
        catch (RemoteException e) {
            System.err.println("Caught RemoteException while retrieving configuration");
            System.err.println(e.getMessage());
            this.disconnectNode();
            return;
        }
        this.debugPrint("\nstartSession() - send commands");
        try {
            this.sendCommands();
        }
        catch (RemoteException e) {
            System.err.println("Caught RemoteException while sending commands");
            this.disconnectNode();
            return;
        }
        this.disconnectNode();
        this.debugPrint("\nstartSession() - done: " + PortalServer.currentTimeString());
    }

    void retrieveAndDistributeData() {
        if (!this.nodeConnected() && !this.connectNode()) {
            return;
        }
        long[] deviceID = new long[this._ports.length + 1];
        deviceID[0] = this._nodeID;
        int i = 0;
        while (i < this._ports.length) {
            try {
                deviceID[i + 1] = this._ports[i].getDeviceID();
            }
            catch (DeviceNotFound e) {
                deviceID[i + 1] = -1L;
            }
            ++i;
        }
        long latest = 0L;
        int i2 = 0;
        while (i2 < deviceID.length) {
            int totalPackets = 0;
            if (deviceID[i2] != -1L) {
                try {
                    System.out.println("Retrieve data from device " + deviceID[i2]);
                    Long key = new Long(deviceID[i2]);
                    DevicePacketSet packetSet = null;
                    while (this.nodeConnected()) {
                        this.debugPrint("Renewing leaseID " + this._leaseID);
                        this._nodeProxy.renewLease(this._leaseID, this._leaseTime);
                        PacketStats packetStats = (PacketStats)this._devices.get(key);
                        latest = packetStats._latestPacketTime;
                        System.out.println("call retrieveData() for device " + deviceID[i2] + ", latest=" + latest);
                        packetSet = this.retrieveData(deviceID[i2], latest + 1L, Long.MAX_VALUE);
                        totalPackets += packetSet._packets.size();
                        int j = 0;
                        while (j < packetSet._packets.size()) {
                            DevicePacket packet = (DevicePacket)packetSet._packets.get(j);
                            if (packet.systemTime() > latest) {
                                latest = packet.systemTime();
                            }
                            ++j;
                        }
                        System.out.println("new latest=" + latest);
                        packetStats = new PacketStats(latest);
                        this._devices.put(key, packetStats);
                        if (packetSet._packets != null) {
                            this.saveData(deviceID[i2], packetSet._packets);
                            if (this._publishPackets) {
                                this.publishData(packetSet._packets);
                            }
                            this.distributeData(packetSet._packets);
                        }
                        if (!packetSet.complete()) continue;
                        System.out.println("Retrieved total of " + totalPackets + " packets from device " + deviceID[i2]);
                        break;
                    }
                }
                catch (DeviceNotFound e) {
                }
                catch (RemoteException e) {
                    System.err.println("Caught RemoteException while retrieving data");
                    System.err.println(e.getMessage());
                    this.disconnectNode();
                }
                catch (NoDataException e) {
                    System.err.println("No data from device " + deviceID[i2]);
                }
                catch (Exception e) {
                    System.err.println("Exception while retrieving data from device " + deviceID[i2]);
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                }
            }
            ++i2;
        }
    }

    void saveData(long deviceID, Vector packets) {
        Long key = new Long(deviceID);
        DeviceLog log = (DeviceLog)this._logs.get(key);
        if (log == null) {
            log = new DeviceLog(deviceID, ".");
            this._logs.put(key, log);
        }
        int i = 0;
        while (i < packets.size()) {
            DevicePacket packet = (DevicePacket)packets.get(i);
            log.appendPacket(packet);
            ++i;
        }
    }

    void publishData(Vector packets) {
        Iterator i = ((AbstractList)packets).iterator();
        while (i.hasNext()) {
            System.out.println("Publishing packet...");
            this._ssdsPublisher.publish((Serializable)i.next());
        }
    }

    void distributeData(Vector packets) {
        this.debugPrint("# stream clients: " + this._packetServer._clients.size());
        boolean[] valid = new boolean[this._packetServer._clients.size()];
        int i = 0;
        while (i < this._packetServer._clients.size()) {
            DevicePacketOutputStream client = (DevicePacketOutputStream)this._packetServer._clients.get(i);
            this.debugPrint("Distributing " + packets.size() + " packets to client");
            valid[i] = true;
            int j = 0;
            while (j < packets.size()) {
                DevicePacket packet = (DevicePacket)packets.get(j);
                try {
                    client.write(packet);
                }
                catch (IOException e) {
                    valid[i] = false;
                    System.err.println("Caught IOException from DevicePacketStream client");
                    System.err.println(e.getMessage());
                    break;
                }
                ++j;
            }
            ++i;
        }
        int nInvalid = 0;
        int i2 = 0;
        while (i2 < valid.length) {
            if (!valid[i2]) {
                DevicePacketOutputStream stream = (DevicePacketOutputStream)this._packetServer._clients.get(i2 - nInvalid);
                try {
                    stream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this._packetServer._clients.remove(i2 - nInvalid);
                ++nInvalid;
            }
            ++i2;
        }
    }

    public void nodeLinkDisconnecting(long nextConnectTime) {
        System.out.println("PortalServer.nodeLinkDisconnecting(): " + PortalServer.currentTimeString());
        this.disconnectNode();
        this._nextConnectTime = nextConnectTime;
        System.out.println("Link terminated at " + PortalServer.timeString(System.currentTimeMillis()));
        System.out.println("Next connection at " + PortalServer.timeString(this._nextConnectTime));
    }

    public synchronized void nodeLinkConnected() {
        System.out.println("PortalServer.nodeLinkConnected(): " + PortalServer.timeString(System.currentTimeMillis()));
        if (!this.nodeConnected()) {
            Thread thread = new Thread(new ConnectionEstablishedWorker());
            thread.start();
        }
    }

    void disconnectNode() {
        this.debugPrint("disconnectNode() - " + PortalServer.currentTimeString());
        if (this.nodeConnected()) {
            try {
                this._nodeProxy.terminateLease(this._leaseID);
            }
            catch (RemoteException e) {
                System.err.println("RemoteException in disconnectNode: " + e);
            }
            catch (Exception e) {
                System.err.println("Exception in disconnectNode: " + e);
            }
        }
        PortalServer portalServer = this;
        synchronized (portalServer) {
            this._leaseID = -1;
            this._nodeProxy = null;
        }
    }

    protected boolean connectNode() {
        String nodeURL = Portals.mooringURL(this._remoteNodeAddress.getHostName());
        this.debugPrint("Looking for node server stub at " + nodeURL);
        this._nodeProxy = null;
        try {
            this._nodeProxy = (Node)Naming.lookup(nodeURL);
            System.out.println("Connected to node " + new String(this._nodeProxy.getName()) + " (id=" + this._nodeProxy.getId() + ")");
            this.debugPrint("host: " + this._nodeProxy.host());
            Location location = this._nodeProxy.getLocation();
            this.debugPrint("x: " + location._x + " y: " + location._y + " z: " + location._z);
        }
        catch (NotBoundException e) {
            System.err.println("NotBoundException: " + e.getMessage());
        }
        catch (AccessException e) {
            System.err.println("AccessException: " + e.getMessage());
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            System.err.println("MalformedURLException: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Got exception from mooring server:");
            System.err.println(e.getMessage());
        }
        try {
            if (this._leaseID == -1) {
                this._leaseID = this._nodeProxy.establishLease(this._leaseTime);
            } else {
                this._nodeProxy.renewLease(this._leaseID, this._leaseTime);
            }
        }
        catch (RemoteException e) {
            System.err.println("RemoteException while establishing lease: " + e.getMessage());
        }
        catch (LeaseRefused e) {
            System.err.println("Lease Refused exception: " + e.getMessage());
        }
        return this.nodeConnected();
    }

    protected void debugPrint(String message) {
        if (this._debug) {
            System.out.println(message);
        }
    }

    static long parseDateTime(String dateTimeString) throws ParseException {
        String[] patterns = new String[]{"M/d/yyyy'T'H:m:s", "M/d/yyyy'T'H:m", "M/d/yyyy"};
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.setLenient(true);
        ParsePosition position = new ParsePosition(0);
        Date date = null;
        int i = 0;
        while (i < patterns.length) {
            position.setIndex(0);
            position.setErrorIndex(-1);
            dateFormat.applyPattern(patterns[i]);
            date = dateFormat.parse(dateTimeString, position);
            if (date != null) break;
            ++i;
        }
        if (date == null) {
            StringBuffer buffer = new StringBuffer(dateTimeString + " - invalid date/time. " + "Acceptable formats:\n");
            int i2 = 0;
            while (i2 < patterns.length) {
                buffer.append(patterns[i2] + "\n");
                ++i2;
            }
            throw new ParseException(new String(buffer), 0);
        }
        return date.getTime();
    }

    static String timeString(long t) {
        return DateFormat.getDateTimeInstance().format(new Date(t));
    }

    static String currentTimeString() {
        long t = System.currentTimeMillis();
        return DateFormat.getDateTimeInstance().format(new Date(t));
    }

    void updateDeviceList(long nodeID, Port[] ports) {
        Long key = new Long(nodeID);
        if (!this._devices.containsKey(key)) {
            System.out.println("New node ID: " + key);
            this._devices.put(key, new PacketStats(this._startRetrieveTime));
        }
        int i = 0;
        while (i < ports.length) {
            try {
                key = new Long(ports[i].getDeviceID());
                if (!this._devices.containsKey(key)) {
                    System.out.println("New device ID: " + key);
                    this._devices.put(key, new PacketStats(this._startRetrieveTime));
                }
            }
            catch (DeviceNotFound e) {
                // empty catch block
            }
            ++i;
        }
    }

    protected DevicePacketSet retrieveData(long deviceID, long startTime, long endTime) throws RemoteException, Exception, DeviceNotFound, NoDataException {
        System.out.println("Retrieving data from device #" + deviceID);
        DevicePacketSet packetSet = this._nodeProxy.getDevicePackets(deviceID, startTime, endTime);
        System.out.println("Retrieved " + packetSet._packets.size() + " packets from device #" + deviceID);
        int j = 0;
        while (j < packetSet._packets.size()) {
            DevicePacket packet = (DevicePacket)packetSet._packets.elementAt(j);
            this.printPacket(packet);
            ++j;
        }
        System.out.println("");
        return packetSet;
    }

    void printPacket(DevicePacket packet) {
        System.out.println("src: " + packet.sourceID() + " time: " + packet.systemTime() + " seqNo: " + packet.sequenceNo() + " metadataRef: " + packet.metadataRef());
        if (packet instanceof SensorDataPacket) {
            SensorDataPacket dataPacket = (SensorDataPacket)packet;
            System.out.println("data: ");
            System.out.println(new String(dataPacket.dataBuffer()));
            System.out.println("");
        } else if (packet instanceof MetadataPacket) {
            MetadataPacket metadataPacket = (MetadataPacket)packet;
            System.out.println("metadata: ");
            System.out.println(new String(metadataPacket.getBytes()));
            System.out.println("");
        } else if (packet instanceof DeviceMessagePacket) {
            DeviceMessagePacket messagePacket = (DeviceMessagePacket)packet;
            System.out.println("device message: ");
            System.out.println(new String(messagePacket.getMessage()));
            System.out.println("");
        }
    }

    protected void sendCommands() throws RemoteException {
        if (this._queuedCommands.size() <= 0) {
            return;
        }
        System.out.println("Sending queued commands:");
        Vector<QueuedCommand> unsentCommands = new Vector<QueuedCommand>();
        int i = 0;
        while (i < this._queuedCommands.size()) {
            block10: {
                QueuedCommand command = (QueuedCommand)this._queuedCommands.get(i);
                long now = System.currentTimeMillis();
                if (now >= command.earliestSendTime() && now <= command.latestSendTime()) {
                    System.out.println("Sending command \"" + command.name() + "\"");
                    command.clearResult();
                    try {
                        if (this._leaseID != -1) {
                            this._nodeProxy.renewLease(this._leaseID, this._leaseTime);
                        }
                        command.dispatch(this._nodeProxy);
                        command.setActualSentTime(now);
                        System.out.println("Result: " + command.resultString());
                        this._sentCommands.add(command);
                        break block10;
                    }
                    catch (RemoteException e) {
                        command.setResult(-1, "Remote exception");
                        this.disconnectNode();
                        break;
                    }
                    catch (Error e) {
                        command.setResult(-1, "java.lang.Error");
                        System.err.println("Caught Error while trying to dispatch command");
                        System.err.println(e.getMessage());
                        break block10;
                    }
                    catch (Exception e) {
                        System.err.println("Caught exception while trying to dispatch command");
                        System.err.println(e.getMessage());
                        command.setResult(-1, "Exception");
                        break block10;
                    }
                }
                if (now < command.earliestSendTime()) {
                    unsentCommands.add(command);
                    System.out.println("Not yet time to send command \"" + command.name() + "\"");
                } else {
                    System.out.println("Too late to send command \"" + command.name() + "\"");
                    command.setResult(-1, "Command expired, not dipatched");
                }
            }
            ++i;
        }
        this._queuedCommands = unsentCommands;
    }

    public static void main(String[] args) {
        boolean publishPackets = false;
        if (System.getSecurityManager() == null) {
            System.out.println("Setting security manager");
            System.setSecurityManager(new RMISecurityManager());
        }
        long startRetrieveTime = System.currentTimeMillis();
        boolean error = false;
        int i = 0;
        while (i < args.length - 3) {
            if (args[i].equals("-publish")) {
                publishPackets = true;
            } else if (args[i].equals("-all")) {
                startRetrieveTime = 0L;
            } else if (args[i].equals("-start")) {
                if (i >= args.length - 4) {
                    System.err.println("Missing parameter(s)");
                    error = true;
                } else if (args[++i].equals("now")) {
                    startRetrieveTime = System.currentTimeMillis();
                } else if (args[i].equals("0") || args[i].equals("all")) {
                    startRetrieveTime = 0L;
                } else {
                    try {
                        startRetrieveTime = PortalServer.parseDateTime(args[i]);
                        System.out.println("startRetrieveTime=" + startRetrieveTime);
                    }
                    catch (ParseException e) {
                        System.err.println(e.getMessage());
                        error = true;
                    }
                }
            } else {
                System.err.println("Invalid option: " + args[i]);
                error = true;
            }
            ++i;
        }
        if (args.length < 3) {
            System.err.println(args.length + " arguments: " + "at least 3 arguments required");
            error = true;
        }
        if (error) {
            System.err.println("Usage: PortalServer [option(s)] publicAddress privateAddress remoteNode");
            System.err.println("Options:");
            System.err.println("-start time   retrieve packets newer than date/time");
            System.err.println("-start 0      retrieve all packets");
            System.err.println("-all          retrieve all packets");
            System.err.println("-start now    retrieve packets newer than current date/time");
            return;
        }
        String publicPortalAddress = args[args.length - 3];
        String privatePortalAddress = args[args.length - 2];
        String remoteNodeAddress = args[args.length - 1];
        try {
            System.out.println("Starting registry...");
            LocateRegistry.createRegistry(1099);
            System.out.println("Started registry");
        }
        catch (RemoteException e) {
            System.err.println(e.getMessage());
        }
        try {
            System.out.println("Constructing PortalServer...");
            PortalServer server = new PortalServer(publicPortalAddress, privatePortalAddress, remoteNodeAddress, startRetrieveTime, publishPackets);
            server.initialize();
            String url = Portals.portalURL(publicPortalAddress);
            System.out.println("Binding PortalServer to " + url + "...");
            Naming.rebind(url, server);
            System.out.println("PortalServer is bound to " + url);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    class ConnectionEstablishedWorker
    implements Runnable {
        ConnectionEstablishedWorker() {
        }

        public void run() {
            PortalServer.this.startSession();
        }
    }

    class PacketStats {
        long _latestPacketTime;

        PacketStats(long latestPacketTime) {
            this._latestPacketTime = latestPacketTime;
        }
    }
}

