/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.portal;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class AUVPortalService {
    protected ServerSocket _serverSocket;

    public AUVPortalService(int port) throws IOException {
        this._serverSocket = new ServerSocket(port);
    }

    public void run() {
        Socket clientSocket = null;
        while (true) {
            try {
                System.out.println("Wait for client...");
                clientSocket = this._serverSocket.accept();
                System.out.println("accepted connection");
                this.processConnection(clientSocket);
                continue;
            }
            catch (IOException e) {
                System.err.println("IOException: " + e.getMessage());
                continue;
            }
            break;
        }
    }

    protected void processConnection(Socket clientSocket) throws IOException {
        byte[] buf = new byte[1024];
        InputStream in = clientSocket.getInputStream();
        int nBytes = 0;
        while (true) {
            int c;
            if ((c = in.read()) == -1) break;
            buf[nBytes++] = (byte)c;
        }
        System.err.println("processConnection() - end-of-stream");
        String message = new String(buf);
        WorkThread workThread = new WorkThread(message);
        workThread.start();
    }

    public static void main(String[] args) {
        try {
            AUVPortalService service = new AUVPortalService(4444);
            service.run();
        }
        catch (IOException e) {
            System.err.println("Caught IOException: " + e.getMessage());
        }
    }

    class WorkThread
    extends Thread {
        protected String _message;

        public WorkThread(String message) {
            this._message = message;
        }

        public void run() {
            System.out.println("processConnection() got message:\n" + this._message);
            StringTokenizer tokenizer = new StringTokenizer(this._message, ";");
            if (tokenizer.countTokens() < 4) {
                System.err.println("Not enough tokens in message:\n" + this._message);
                return;
            }
            String auvHost = null;
            String login = null;
            String passwd = null;
            String file = null;
            int nToken = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                switch (nToken++) {
                    case 0: {
                        auvHost = token;
                        break;
                    }
                    case 1: {
                        login = token;
                        break;
                    }
                    case 2: {
                        passwd = token;
                        break;
                    }
                    default: {
                        file = token;
                        try {
                            this.retrieveAndProcess(auvHost, login, passwd, file);
                            break;
                        }
                        catch (IOException e) {
                            System.err.println("IOException: " + e.getMessage());
                        }
                    }
                }
            }
        }

        void retrieveAndProcess(String auvHost, String login, String passwd, String fileName) throws IOException {
            System.out.println("Retrieve mission files from AUV host:");
            System.out.println(auvHost + ": " + fileName);
            String destination = "./myjunk";
            try {
                File file = new File(fileName);
                FTPClient ftpClient = new FTPClient(auvHost);
                ftpClient.user(login);
                ftpClient.password(passwd);
                ftpClient.setType(FTPTransferType.BINARY);
                System.out.println("Retrieving " + fileName);
                ftpClient.get(file.getName(), fileName.trim());
                System.out.println("All done");
                ftpClient.quit();
            }
            catch (IOException e) {
                System.err.println("IOException: " + e.getMessage());
            }
            catch (FTPException e) {
                System.err.println("FTPException: " + e.getMessage() + "\n" + "reply code: " + e.getReplyCode());
            }
        }
    }
}

