/*
 * Decompiled with CFR 0.152.
 */
package moos.leasing;

import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import moos.deployed.SiamTimer;
import moos.deployed.SiamTimerTask;
import moos.interfaces.leasing.LeaseListener;
import moos.interfaces.leasing.LeaseRefused;

public class LeaseManager {
    public static final long UNKNOWN_TIME = 0L;
    Vector _lesees = new Vector();
    Vector _listeners = new Vector();
    int _nextLeaseID = 1;
    LeaseManager _leaseManager = this;
    DateFormat _dateFormatter = DateFormat.getDateTimeInstance();
    boolean _debug = true;

    public void addListener(LeaseListener listener) {
        this._listeners.add(listener);
    }

    public synchronized int establish(long leaseMillisec, long nextEstablishTime) throws LeaseRefused {
        Lesee lesee = new Lesee(leaseMillisec, nextEstablishTime);
        this._lesees.add(lesee);
        this.debugPrint("LeaseManager.establish() returns " + lesee.getLeaseID() + " at " + this._dateFormatter.format(new Date(System.currentTimeMillis())));
        int i = 0;
        while (i < this._listeners.size()) {
            LeaseListener listener = (LeaseListener)this._listeners.elementAt(i);
            listener.leaseEstablishCallback(lesee.getLeaseID(), leaseMillisec, nextEstablishTime, this._lesees.size());
            ++i;
        }
        return lesee.getLeaseID();
    }

    public int establish(long leaseMillisec) throws LeaseRefused {
        return this.establish(leaseMillisec, 0L);
    }

    Lesee getLesee(int leaseID) {
        Enumeration e = this._lesees.elements();
        while (e.hasMoreElements()) {
            Lesee lesee = (Lesee)e.nextElement();
            if (lesee.getLeaseID() != leaseID) continue;
            return lesee;
        }
        return null;
    }

    public synchronized void renew(int leaseID, long leaseMillisec) throws LeaseRefused {
        this.debugPrint("LeaseManager.renew() LeaseID " + leaseID + " at " + this._dateFormatter.format(new Date(System.currentTimeMillis())));
        Lesee lesee = this.getLesee(leaseID);
        if (lesee == null) {
            System.err.println("Can't find Lease, assume already expired");
            throw new LeaseRefused("Lease already expired");
        }
        lesee.cancelTimer();
        lesee.schedule(leaseMillisec);
        int i = 0;
        while (i < this._listeners.size()) {
            LeaseListener listener = (LeaseListener)this._listeners.elementAt(i);
            listener.leaseRenewalCallback(leaseID, leaseMillisec, this._lesees.size());
            ++i;
        }
    }

    public synchronized void terminate(int leaseID, long nextConnectTime) {
        this.debugPrint("LeaseManager.terminate() LeaseID " + leaseID + " at " + this._dateFormatter.format(new Date(System.currentTimeMillis())));
        Lesee lesee = this.getLesee(leaseID);
        if (lesee == null) {
            System.err.println("Can't find Lease, assume already expired");
            return;
        }
        lesee.cancelTimer();
        this._lesees.remove(lesee);
        lesee = null;
        int i = 0;
        while (i < this._listeners.size()) {
            LeaseListener listener = (LeaseListener)this._listeners.elementAt(i);
            listener.leaseTerminatedCallback(leaseID, nextConnectTime, this._lesees.size());
            ++i;
        }
    }

    protected void debugPrint(String message) {
        if (this._debug) {
            System.out.println(message);
        }
    }

    class Lesee {
        int _leaseID;
        SiamTimer _leaseTimer;
        long _nextEstablishTime;

        Lesee(long leaseMillisec, long nextEstablishTime) {
            this._nextEstablishTime = nextEstablishTime;
            LeaseManager leaseManager = LeaseManager.this._leaseManager;
            synchronized (leaseManager) {
                this._leaseID = LeaseManager.this._nextLeaseID++;
                if (LeaseManager.this._nextLeaseID <= 0) {
                    LeaseManager.this._nextLeaseID = 1;
                }
            }
            this.schedule(leaseMillisec);
        }

        int getLeaseID() {
            return this._leaseID;
        }

        void schedule(long leaseMillisec) {
            this._leaseTimer = new SiamTimer();
            this._leaseTimer.schedule((SiamTimerTask)new LeaseExpiredTask(this), leaseMillisec);
        }

        void cancelTimer() {
            try {
                this._leaseTimer.cancel();
            }
            catch (Exception e) {
                System.err.println("Exception cancelling timer for leaseID " + this._leaseID + ": " + e);
                e.printStackTrace();
            }
            this._leaseTimer = null;
        }
    }

    class LeaseExpiredTask
    extends SiamTimerTask {
        Lesee _lesee;

        LeaseExpiredTask(Lesee lesee) {
            this._lesee = lesee;
        }

        public void run() {
            LeaseManager.this.debugPrint("Lease ID " + this._lesee.getLeaseID() + " expired at " + LeaseManager.this._dateFormatter.format(new Date(System.currentTimeMillis())));
            LeaseManager leaseManager = LeaseManager.this._leaseManager;
            synchronized (leaseManager) {
                this._lesee.cancelTimer();
                LeaseManager.this._lesees.remove(this._lesee);
                int i = 0;
                while (i < LeaseManager.this._listeners.size()) {
                    LeaseListener listener = (LeaseListener)LeaseManager.this._listeners.elementAt(i);
                    listener.leaseExpiredCallback(this._lesee.getLeaseID(), this._lesee._nextEstablishTime, LeaseManager.this._lesees.size());
                    ++i;
                }
                this._lesee = null;
            }
        }
    }
}

