/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.whs300;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.SerialInstrumentPort;
import moos.deployed.SerialPortParameters;
import moos.utils.AsciiTime;
import moos.utils.PrintUtils;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidDataException;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.TimeoutException;

public class WorkhorseADCP
extends InstrumentService
implements Instrument {
    static final int MAX_RESPONSE_BYTES = 1000;
    static final int MAX_SAMPLE_TRIES = 1;
    static final int MAX_COMMAND_TRIES = 3;
    static final int MAX_REQUEST_BYTES = 80;
    static final int RESPONSE_TIME = 1000;
    static final int PROMPT_RESPONSE_TIME = 3000;
    static final int ECHO_RESPONSE_TIME = 2000;
    static final int BREAK_FOR_400MS = 100000;
    static final String DEFAULT_PREEMPTION_TIME = "20";
    static final String DEFAULT_TIME_SYNC = "N";
    static final String COMMAND_FORCE_PROMPT = "";
    static final String COMMAND_ENSEMBLE_INTERVAL = "TE?";
    static final String COMMAND_PING_INTERVAL = "TP?";
    static final String COMMAND_PINGS_PER_ENSEMBLE = "WP?";
    static final String COMMAND_START_PINGING = "CS";
    static final String COMMAND_SET_RTC = "TS";
    static final String RESPONSE_PROMPT = ">";
    static final byte HEADER_ID = 127;
    static final byte SOURCE_ID = 127;
    private long _ensembleIntervalTime;
    private int _pingsPerEnsemble;
    private int _pingInterval;
    private int _preemptionTime;
    private boolean _timeSynch;
    private long _initialInterval;

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected byte[] initPromptString() {
        return RESPONSE_PROMPT.getBytes();
    }

    protected byte[] initSampleTerminator() {
        return new byte[0];
    }

    protected int initMaxSampleBytes() {
        return 1000;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 1;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        this._initialInterval = this._pingInterval * this._pingsPerEnsemble - this._preemptionTime;
        System.out.println("Rescheduling service for " + this._initialInterval + " seconds...");
        return new ScheduleSpecifier(this._initialInterval * 1000L);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        super.loadProperties(input);
        System.out.print("Loading properties for " + this._serviceName + " ...");
        String property = this._serviceProperties.getProperty("preemptionTime", DEFAULT_PREEMPTION_TIME);
        String timeSynch = this._serviceProperties.getProperty("timeSynchronization", DEFAULT_TIME_SYNC);
        try {
            this._preemptionTime = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(COMMAND_FORCE_PROMPT + e);
        }
        this._timeSynch = timeSynch.compareTo("Y") == 0;
        System.out.println("OK");
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        System.out.print("Initializing " + this._serviceName + "...");
        this.setMaxSampleTries(1);
        this.setSampleTimeout(1000L);
        this.managePowerWake();
        try {
            block6: {
                try {
                    this.enterCommandMode();
                    String response = this.sendRequest(COMMAND_ENSEMBLE_INTERVAL);
                    String property = this.getProperty(response);
                    String[] token = this.parseProperty(property, ":.", 3);
                    this._ensembleIntervalTime = Integer.parseInt(token[0]) * 3600 + Integer.parseInt(token[1]) * 60 + Integer.parseInt(token[2]);
                    response = this.sendRequest(COMMAND_PING_INTERVAL);
                    property = this.getProperty(response);
                    token = this.parseProperty(property, ":.", 2);
                    this._pingInterval = Integer.parseInt(token[0]) * 60 + Integer.parseInt(token[1]);
                    response = this.sendRequest(COMMAND_PINGS_PER_ENSEMBLE);
                    property = this.getProperty(response);
                    this._pingsPerEnsemble = Integer.parseInt(property);
                    if (!this._timeSynch) break block6;
                    this.sendCommand(COMMAND_SET_RTC + AsciiTime.getDate("YY/MM/DD") + "," + AsciiTime.getTime("HH:mm:ss"));
                }
                catch (NumberFormatException e) {
                    throw new InitializeException("parseInt()" + e);
                }
                catch (InvalidPropertyException e) {
                    throw new InitializeException("getProperty()" + e);
                }
                catch (Exception e) {
                    throw new InitializeException("sendRequest() " + e);
                }
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.exitCommandMode();
            this.managePowerSleep();
            throw throwable;
        }
        this.exitCommandMode();
        this.managePowerSleep();
        System.out.println("OK");
    }

    protected void prepareToSample() throws Exception {
    }

    protected void requestSample() throws TimeoutException, Exception {
        this.flushInput();
        long t0 = System.currentTimeMillis();
        while (this._fromDevice.available() == 0) {
            int secs = this._preemptionTime * 2 - (int)((System.currentTimeMillis() - t0) / 1000L);
            System.out.print("Waiting for ADCP data... " + secs + " \r");
            this.sleep(100);
            if (System.currentTimeMillis() - t0 <= (long)(this._preemptionTime * 1000 * 2)) continue;
            this.enterCommandMode();
            this.exitCommandMode();
            System.out.println("Rescheduling service for " + this._initialInterval + " seconds...");
            this.sync(this._initialInterval * 1000L);
            throw new TimeoutException("Failed to receive a sample during preempted interval - resynched");
        }
        System.out.println("\nData detected, rescheduling for " + (this._ensembleIntervalTime - (long)this._preemptionTime) + " seconds.");
        this.sync((this._ensembleIntervalTime - (long)this._preemptionTime) * 1000L);
    }

    protected int readSample(byte[] sample) throws TimeoutException, IOException, Exception {
        int byteCount = this.readUntilDelay(this._fromDevice, sample, this.getSampleTimeout());
        System.out.println("Data captured");
        return byteCount;
    }

    protected int readUntilDelay(InputStream instream, byte[] outbuf, long timeout) throws TimeoutException, IOException, Exception {
        long elapsed;
        int bytesRead = 0;
        int pktLength = 0;
        long t0 = System.currentTimeMillis();
        do {
            if (instream.available() <= 0) continue;
            outbuf[bytesRead++] = (byte)instream.read();
            t0 = System.currentTimeMillis();
            if (bytesRead == 2) {
                if (outbuf[0] != 127) {
                    throw new Exception("Bad header id");
                }
                if (outbuf[1] != 127) {
                    throw new Exception("Bad source id");
                }
            } else if (bytesRead == 4) {
                pktLength = this.mkInt(outbuf[2], outbuf[3]) + 2;
            } else if (bytesRead > 4 && bytesRead == pktLength) {
                return bytesRead;
            }
            if (bytesRead <= outbuf.length) continue;
            throw new Exception("Output buf in instrument driver exceeded (buffer max length is " + outbuf.length + ")");
        } while ((elapsed = System.currentTimeMillis() - t0) <= timeout);
        throw new TimeoutException("Timed out");
    }

    protected void validateSample(byte[] buffer, int nBytes) throws InvalidDataException {
        int sum = 0;
        int i = 0;
        while (i < nBytes - 2) {
            sum += this.mkInt(buffer[i], (byte)0);
            ++i;
        }
        int checksum = this.mkInt(buffer[i], buffer[i + 1]);
        if ((sum %= 65536) != checksum) {
            throw new InvalidDataException("Checksum error");
        }
    }

    protected byte[] getInstrumentMetadata() {
        return "Not supported".getBytes();
    }

    public void setClock(long t) {
    }

    private String sendRequest(String request) throws Exception {
        byte[] response = new byte[80];
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(request));
                this.skipUntil(this._fromDevice, "\r\n".getBytes(), 2000L, this.mkCmd(request).length + 2);
                this.readUntil(this._fromDevice, response, RESPONSE_PROMPT.getBytes(), 1000L);
                return new String(response);
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + request + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + request + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Request=" + request);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            this.write(this._toDevice, this.mkCmd(COMMAND_FORCE_PROMPT));
            this.sleep(500);
            ++i;
        }
        throw new Exception("sendCommand(" + request + ") - Maximum retries attempted");
    }

    private void sendCommand(String cmd) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, RESPONSE_PROMPT.getBytes(), 1000L, 1000);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            this.write(this._toDevice, this.mkCmd(COMMAND_FORCE_PROMPT));
            this.sleep(500);
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void enterCommandMode() throws Exception {
        int i = 0;
        while (i < this.getMaxSampleTries()) {
            this.sendBreak();
            try {
                this.skipUntil(this._fromDevice, RESPONSE_PROMPT.getBytes(), 3000L, 1000);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("skipUntil() " + e);
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("skipUntil() " + e);
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("enterCommandMode() - Maximum retries attempted");
    }

    private void exitCommandMode() throws IOException, Exception {
        this.write(this._toDevice, this.mkCmd(COMMAND_START_PINGING));
    }

    private void sendBreak() {
        if (this._instrumentPort instanceof SerialInstrumentPort) {
            System.out.println("Sending break.....");
            SerialInstrumentPort sip = (SerialInstrumentPort)this._instrumentPort;
            sip.sendBreak(100000);
        }
    }

    private void sleep(int msDelay) {
        while (true) {
            try {
                Thread.sleep(msDelay);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private byte[] mkCmd(String cmd) {
        return new String(cmd + "\r").getBytes();
    }

    private int mkInt(byte loByte, byte hiByte) {
        int temp1 = loByte & 0xFF;
        int temp2 = hiByte & 0xFF;
        return temp1 + (temp2 << 8);
    }

    private String getProperty(String response) throws InvalidPropertyException {
        StringTokenizer tkzResponse = new StringTokenizer(response, " ", false);
        while (tkzResponse.countTokens() > 0) {
            String property = tkzResponse.nextToken();
            if (!property.equals("=")) continue;
            property = tkzResponse.nextToken();
            return property;
        }
        throw new InvalidPropertyException("Invalid Workshorse property");
    }

    private String[] parseProperty(String response, String delim, int fieldCount) throws InvalidPropertyException {
        StringTokenizer tkzResponse = new StringTokenizer(response, delim, false);
        if (fieldCount > tkzResponse.countTokens()) {
            throw new InvalidPropertyException("Invalid Workshorse property");
        }
        String[] property = new String[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            property[i] = tkzResponse.nextToken();
            ++i;
        }
        return property;
    }

    public void printData(byte[] buf) {
        PrintUtils.printFull(buf, 0, 64);
    }

    public int test() {
        return 0;
    }
}

