/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.wetlabs;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.RangeException;
import moos.deployed.SerialPortParameters;
import moos.utils.AsciiTime;
import moos.utils.PrintUtils;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.TimeoutException;

public class WetLabsECO
extends InstrumentService
implements Instrument {
    static final int MAX_RESPONSE_BYTES = 128;
    static final int MAX_SAMPLE_TRIES = 3;
    static final int MAX_COMMAND_TRIES = 3;
    static final int MAX_SAMPLE_BYTES = 64;
    static final int SYNC_TIME = 4000;
    static final int RESPONSE_TIME = 60000;
    static final int SAMPLE_RESPONSE_TIME = 60000;
    static final String DEFAULT_TIME_SYNC = "N";
    static final String DEFAULT_SAMPLES_PER_PKT = "3";
    static final String DEFAULT_AVERAGE_COUNT = "50";
    static final String COMMAND_STOP_ACQUISITION = "!!!!!";
    static final String COMMAND_ENABLE_RECORD = "Rec 1";
    static final String COMMAND_DISABLE_RECORD = "Rec 0";
    static final String COMMAND_SET_DATE = "Dat";
    static final String COMMAND_SET_TIME = "Clk";
    static final String COMMAND_PKTS_PER_SET = "Set";
    static final String COMMAND_SAMPLES_PER_PKT = "Pkt";
    static final String COMMAND_AVERAGE_COUNT = "Ave";
    static final String COMMAND_MENU = "mnu";
    static final String COMMAND_STORE = "sto";
    static final String SAMPLE_TERMINATOR = "mvs";
    static final String RESPONSE_PROMPT = "Ver";
    static final String DATA_SYNC = "\r\n";
    static final String RESPONSE_DONE = "done";
    private boolean _timeSynch;
    private int _samplesPerPkt = Integer.parseInt("3");
    private int _averageCount;

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected byte[] initPromptString() {
        return "".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return SAMPLE_TERMINATOR.getBytes();
    }

    protected int initMaxSampleBytes() {
        return 64 * this._samplesPerPkt;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected int initInstrumentPowerPolicy() {
        return 1;
    }

    protected int initCommunicationPowerPolicy() {
        return 1;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(600L);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(19200, 8, 0, 1);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        super.loadProperties(input);
        System.out.print("Loading properties for " + this._serviceName + " ...");
        String timeSynch = this._serviceProperties.getProperty("timeSynchronization", DEFAULT_TIME_SYNC);
        this._timeSynch = timeSynch.compareTo("Y") == 0;
        String samplesPerPkt = this._serviceProperties.getProperty("samplesPerPacket", DEFAULT_SAMPLES_PER_PKT);
        this._samplesPerPkt = Integer.parseInt(samplesPerPkt);
        String averageCount = this._serviceProperties.getProperty("averageCount", DEFAULT_AVERAGE_COUNT);
        this._averageCount = Integer.parseInt(averageCount);
        try {
            this.setMaxSampleBytes(this.initMaxSampleBytes());
        }
        catch (RangeException e) {
            throw new InvalidPropertyException("Parameter out of range.");
        }
        System.out.println("OK");
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        System.out.print("Initializing " + this._serviceName + "...");
        this.setMaxSampleTries(3);
        this.setSampleTimeout(60000L);
        this.managePowerWake();
        try {
            try {
                this.enterCommandMode();
                if (this._timeSynch) {
                    this.setTime();
                }
                this.sendCommand("Set 1", COMMAND_PKTS_PER_SET);
                this.sendCommand("Pkt " + this._samplesPerPkt, COMMAND_SAMPLES_PER_PKT);
                this.sendCommand("Ave " + this._averageCount, COMMAND_AVERAGE_COUNT);
                this.sendCommand(COMMAND_STORE, RESPONSE_DONE);
            }
            catch (Exception e) {
                throw new InitializeException("initializeInstrument()" + e);
            }
            Object var6_1 = null;
            this.managePowerSleep();
        }
        catch (Throwable throwable) {
            Object var6_2 = null;
            this.managePowerSleep();
            throw throwable;
        }
        System.out.println("OK");
    }

    private void setTime() throws Exception {
        this.sendCommand("Dat " + AsciiTime.getDate("MMDDYY"), COMMAND_SET_DATE);
        this.sendCommand("Clk " + AsciiTime.getTime("HHmmss"), COMMAND_SET_TIME);
    }

    protected void requestSample() throws TimeoutException, Exception {
        this.skipUntil(this._fromDevice, DATA_SYNC.getBytes(), 4000L, 64);
    }

    protected void postSample() {
        try {
            do {
                this.flushInput();
                this.sleep(2000);
            } while (this._fromDevice.available() > 0);
        }
        catch (IOException e) {
            return;
        }
    }

    protected byte[] getInstrumentMetadata() {
        return "Not supported".getBytes();
    }

    public void setClock(long t) {
    }

    private void sendCommand(String cmd) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, RESPONSE_PROMPT.getBytes(), 60000L, 128);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void sendCommand(String cmd, String rsp) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, rsp.getBytes(), 60000L, 128);
                do {
                    this.sleep(100);
                } while (this.flushInput() != 0L);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void enterCommandMode() throws Exception {
        int i = 0;
        while (i < this.getMaxSampleTries()) {
            try {
                int j = 0;
                while (j < 5) {
                    this.write(this._toDevice, "!".getBytes());
                    this.sleep(1000);
                    ++j;
                }
                this.skipUntil(this._fromDevice, RESPONSE_PROMPT.getBytes(), 60000L, this.getMaxSampleBytes());
                this.sendCommand(COMMAND_MENU);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("skipUntil() " + e);
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("skipUntil() " + e);
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("enterCommandMode() - Maximum retries attempted");
    }

    private void sleep(int msDelay) {
        while (true) {
            try {
                Thread.sleep(msDelay);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private byte[] mkCmd(String cmd) {
        return new String("$" + cmd + "\r").getBytes();
    }

    protected void printData(byte[] buf) {
        PrintUtils.printFull(buf, 0, 64);
    }

    public int test() {
        return 0;
    }
}

