/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.waveSensor;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.RangeException;
import moos.deployed.SerialInstrumentPort;
import moos.deployed.SerialPortParameters;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.TimeoutException;

public class WaveSensor
extends InstrumentService
implements Instrument {
    byte[] _getFile;
    byte[] _getFileEcho;
    byte[] _getOffset;
    byte[] _getOffsetEcho;
    byte[] _takeSample;
    byte[] _takeSampleEcho;
    byte[] _askSample;
    byte[] _askSampleEcho;
    int _sampleDuration;
    int _maxFileBytes;
    int _maxOffsetBytes;
    int _maxTries;

    protected int initInstrumentStartDelay() {
        return 500;
    }

    protected byte[] initPromptString() {
        return "*".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return "*".getBytes();
    }

    protected int initMaxSampleBytes() {
        return 1000;
    }

    protected int initMaxConfigBytes() {
        return 512;
    }

    protected int initCurrentLimit() {
        return 3000;
    }

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 2;
    }

    protected void requestSample() throws Exception {
        if (!this.startSample()) {
            throw new IOException("WaveSensor.startSample() failed");
        }
        DebugMessage.println(new String(this.getName()) + ": Taking sample, sleep while Triaxsys samples...");
        Thread.sleep(this._sampleDuration * 60 * 1000 + 90000);
        DebugMessage.println(new String(this.getName()) + ": getting sample results from Triaxsys");
        int tries = 0;
        while (tries < this._maxTries) {
            ++tries;
            try {
                DebugMessage.println(new String(this.getName()) + " getPrompt from wave sensor");
                this.skipUntil(this._fromDevice, this.getPromptString(), 1000L);
                this.flushInput();
                DebugMessage.println(new String(this.getName()) + ": got prompt, ask for the sample");
                this.write(this._toDevice, this._askSample);
                this.skipUntil(this._fromDevice, this._askSampleEcho, 1000L);
                DebugMessage.println(this.getName() + ": got sample, now read it");
                return;
            }
            catch (TimeoutException e) {
                DebugMessage.println("Driver: '" + this.getName() + "' got timeout");
                Thread.sleep(this.getSampleTimeout());
            }
        }
    }

    private boolean startSample() throws Exception {
        int tryAltPrompt = 0;
        boolean sampleStarted = false;
        byte[] altPrompt = ".".getBytes();
        DebugMessage.println(this.getName() + ": startSample() using " + new String(this._takeSample));
        int ntries = 1;
        while (ntries < 4) {
            tryAltPrompt = 1 - tryAltPrompt;
            ++ntries;
            try {
                if (tryAltPrompt > 0) {
                    this.skipUntil(this._fromDevice, altPrompt, 1000L);
                } else {
                    this.skipUntil(this._fromDevice, this.getPromptString(), 1000L);
                }
                DebugMessage.println(this.getName() + "startSample(): Prompt detected: " + tryAltPrompt);
                this.flushInput();
                this.write(this._toDevice, this._takeSample);
                this.skipUntil(this._fromDevice, this._takeSampleEcho, 1000L);
                sampleStarted = true;
                break;
            }
            catch (Exception toe) {
                DebugMessage.println(this.getName() + ": timeout in startSample(), retry...");
                Thread.sleep(this.getSampleTimeout());
            }
        }
        if (sampleStarted) {
            DebugMessage.println(this.getName() + ": startSample() completed successfully...");
        }
        return sampleStarted;
    }

    WaveSensor() throws RemoteException {
        try {
            this.setSampleTimeout(10000L);
            this.setMaxSampleTries(3);
        }
        catch (RangeException rangeException) {
            // empty catch block
        }
        this._sampleDuration = 1;
        this._takeSample = new String("!R" + this._sampleDuration + "\r").getBytes();
        this._takeSampleEcho = new String("!R" + this._sampleDuration).getBytes();
        this._askSample = "?MWC\r".getBytes();
        this._askSampleEcho = "?MWC\r\n".getBytes();
        this._getFile = "?F\r".getBytes();
        this._getFileEcho = "?F\r\n".getBytes();
        this._getOffset = "?O\r".getBytes();
        this._getOffsetEcho = "?O\r\n".getBytes();
        this._maxFileBytes = 600;
        this._maxOffsetBytes = 600;
        this._maxTries = 3;
    }

    protected void initializeInstrument() {
        if (this._instrumentPort instanceof SerialInstrumentPort) {
            SerialInstrumentPort sip = (SerialInstrumentPort)this._instrumentPort;
            sip.setRTS(true);
        }
        Date rightNow = new Date(System.currentTimeMillis());
        Calendar c = Calendar.getInstance();
        c.setTime(rightNow);
        int year = c.get(1) % 100;
        String cmd0 = null;
        cmd0 = year < 10 ? "!T0" : "!T";
        int month = c.get(2) + 1;
        String cmd1 = null;
        cmd1 = month < 10 ? "-0" : "-";
        int day = c.get(5);
        String cmd2 = null;
        cmd2 = day < 10 ? "-0" : "-";
        int hour = c.get(11);
        String cmd3 = null;
        cmd3 = hour < 10 ? " 0" : " ";
        int minute = c.get(12);
        String cmd4 = null;
        cmd4 = minute < 10 ? ":0" : ":";
        int second = c.get(13);
        String cmd5 = null;
        cmd5 = second < 10 ? ":0" : ":";
        String setTime = new String(cmd0 + year + cmd1 + month + cmd2 + day + cmd3 + hour + cmd4 + minute + cmd5 + second + "\r");
        DebugMessage.println(new String(this.getName()));
        DebugMessage.println("\t\tSynchronize time in Triaxsys to ");
        DebugMessage.println(setTime);
        try {
            Thread.sleep(5000L);
            this.write(this._toDevice, setTime.getBytes());
            DebugMessage.println(new String(this.getName()));
            DebugMessage.println("\t\tTriaxsys synched");
        }
        catch (Exception e) {
            DebugMessage.println(new String(this.getName()));
            DebugMessage.println("\t\tException while setting time in WaveSensor");
            DebugMessage.println(e.getMessage());
        }
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(4800, 8, 0, 1);
    }

    public void setClock(long t) {
    }

    public int test() {
        return 0;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(1800L);
    }
}

