/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.smartstar;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.RangeException;
import moos.deployed.SerialPortParameters;
import moos.deployed.TimeoutException;
import moos.utils.StopWatch;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class SmartStar
extends InstrumentService
implements Instrument {
    int _bytesCaptured = 0;
    static final int BAUD_RATE = 9600;
    static final int DATA_BITS = 8;
    static final int STOP_BITS = 1;
    static final int PARITY = 0;
    static final int SAMPLE_TIMEOUT = 3000;

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 2;
    }

    protected int initInstrumentStartDelay() {
        return 1000;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected byte[] initSampleTerminator() {
        return "RDY\r".getBytes();
    }

    protected byte[] initPromptString() {
        return "RDY\r".getBytes();
    }

    protected int initMaxSampleBytes() {
        return 1000;
    }

    protected void initializeInstrument() {
        try {
            this.setSampleTimeout(3000L);
        }
        catch (RangeException e) {
            System.out.println("SmartStar.initializeInstrument(): " + e.getMessage());
        }
        this.managePowerWake();
        StopWatch.delay(this.getInstrumentStartDelay());
        try {
            this.getInstrumentAttention(3);
        }
        catch (Exception e) {
            System.out.println("SmartStar initialization: " + e.getMessage());
        }
        System.out.println("SmartStar: done with initializeInstrumen()\n");
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    protected void prepareToSample() throws Exception {
        DebugMessage.println(new String(this.getName()) + ".prepareToSample(): entry");
        byte[] temp_bytes = new byte[32];
        byte[] command = "DATA CAPTURE\r".getBytes();
        this.flushInput();
        this.write(this._toDevice, command);
        int bytes_read = this.readUntil(this._fromDevice, temp_bytes, this.getSampleTerminator(), this.getSampleTimeout());
        String total_bytes = new String(temp_bytes, 0, bytes_read - 1);
        DebugMessage.println(new String(this.getName()) + ".prepareToSample() bytes captured :[" + total_bytes + "]");
        this._bytesCaptured = Integer.parseInt(total_bytes);
        DebugMessage.println(new String(this.getName()) + ".prepareToSample(): exit");
    }

    protected int readSample(byte[] sample) throws TimeoutException, Exception {
        int bytes_read = this.readUntil(this._fromDevice, sample, this.getSampleTerminator(), this.getSampleTimeout());
        if (bytes_read == this._bytesCaptured) {
            return bytes_read;
        }
        return -1;
    }

    protected byte[] getInstrumentMetadata() {
        byte[] tmp_buff = new byte[80];
        int bytes_read = 0;
        try {
            this.getInstrumentAttention(3);
            this.write(this._toDevice, "vers all\r".getBytes());
            bytes_read = this.readUntil(this._fromDevice, tmp_buff, this.getSampleTerminator(), this.getSampleTimeout());
        }
        catch (Exception e) {
            System.err.println("Couldn't get SmartStar metadata");
            tmp_buff = "Couldn't get SmartStar metadata\n".getBytes();
        }
        String meta_data = "<SmartStar Metadata>\n" + new String(tmp_buff, 0, bytes_read).replace('\r', '\n') + "</SmartStar Metadata>\n";
        return meta_data.getBytes();
    }

    public void setClock(long time) {
    }

    public int test() {
        return 0;
    }

    protected void requestSample() throws IOException {
        DebugMessage.println(new String(this.getName()) + ".requestSample(): entry");
        byte[] command = "DATA FETCH\r".getBytes();
        this.flushInput();
        this.write(this._toDevice, command);
        DebugMessage.println(new String(this.getName()) + ".requestSample(): exit");
    }

    void getInstrumentAttention(int tries) throws Exception {
        int i = 0;
        while (i < tries) {
            this.flushInput();
            this.write(this._toDevice, "\r".getBytes());
            try {
                this.skipUntil(this._fromDevice, this.getPromptString(), this.getSampleTimeout());
            }
            catch (Exception e) {
                System.err.println("SmartStar.getInstrumentAttention(): " + e.getMessage());
                if (i == tries - 1) {
                    throw new Exception("SmartStar.getInstrumentAttention(): exceeded max tries");
                }
                StopWatch.delay(100);
            }
            ++i;
        }
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(60000L);
    }
}

