/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.slisus;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.SerialPortParameters;
import moos.utils.AsciiTime;
import moos.utils.PrintUtils;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.TimeoutException;

public class SatlanticISUS
extends InstrumentService
implements Instrument {
    static final String SEQ_GET_SCHEDULE = "S,UP>,D,OY>,S,\r\n\r\n";
    static final String SEQ_SET_RTC = "S,UP>,R,RTC>,T,?,1,?";
    static final int MAX_L_SAMPLES = 3;
    static final int MAX_D_SAMPLES = 1;
    static final int MAX_FRAME_SIZE = 1711;
    static final int MAX_RESPONSE_BYTES = 6844;
    static final int MAX_SAMPLE_TRIES = 1;
    static final int MAX_COMMAND_TRIES = 3;
    static final int MAX_REQUEST_BYTES = 80;
    static final int MAX_MENU_LEVELS = 10;
    static final int MAX_POWERUP_BYTES = 2000;
    static final int RESPONSE_TIME = 3000;
    static final int PROMPT_RESPONSE_TIME = 15000;
    static final int ECHO_RESPONSE_TIME = 2000;
    static final int BREAK_FOR_400MS = 100000;
    static final int POWERUP_TIME = 50000;
    static final String DEFAULT_PREEMPTION_TIME = "20";
    static final String DEFAULT_TIME_SYNC = "N";
    static final String COMMAND_FORCE_PROMPT = "";
    static final String COMMAND_CONTROL_C = "\u0003";
    static final String RESPONSE_PROMPT = ">";
    static final String RESPONSE_STARTUP = "Wakeup";
    private int _preemptionTime;
    private int _samplingTime = 0;
    long _initialInterval;
    private boolean _timeSynch;

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected byte[] initPromptString() {
        return RESPONSE_PROMPT.getBytes();
    }

    protected byte[] initSampleTerminator() {
        return new byte[0];
    }

    protected int initMaxSampleBytes() {
        return 6844;
    }

    protected int initCurrentLimit() {
        return 4000;
    }

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 1;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        this._initialInterval = this._samplingTime - this._preemptionTime;
        System.out.println("Rescheduling service for " + this._initialInterval + " seconds...");
        return new ScheduleSpecifier(this._initialInterval * 1000L);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(19200, 8, 0, 1);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        super.loadProperties(input);
        System.out.print("Loading properties for " + this._serviceName + " ...");
        String property = this._serviceProperties.getProperty("preemptionTime", DEFAULT_PREEMPTION_TIME);
        String timeSynch = this._serviceProperties.getProperty("timeSynchronization", DEFAULT_TIME_SYNC);
        try {
            this._preemptionTime = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(COMMAND_FORCE_PROMPT + e);
        }
        this._timeSynch = timeSynch.compareTo("Y") == 0;
        System.out.println("OK");
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        System.out.print("Initializing " + this._serviceName + "...");
        this.setMaxSampleTries(1);
        this.setSampleTimeout(3000L);
        this.managePowerWake();
        try {
            block6: {
                try {
                    this.skipUntil(this._fromDevice, RESPONSE_STARTUP.getBytes(), 50000L, 2000);
                    this.enterCommandMode();
                    this._samplingTime = this.getSamplingInterval();
                    this.exitCommandMode();
                    this._samplingTime *= 60;
                    if (!this._timeSynch) break block6;
                    this.sleep(10000);
                    this.enterCommandMode();
                    this.setTime();
                    this.exitCommandMode();
                }
                catch (NumberFormatException e) {
                    throw new InitializeException("parseInt()" + e);
                }
                catch (InvalidPropertyException e) {
                    throw new InitializeException("getProperty()" + e);
                }
                catch (Exception e) {
                    throw new InitializeException("sendSequence() " + e);
                }
            }
            Object var8_1 = null;
            this.managePowerSleep();
        }
        catch (Throwable throwable) {
            Object var8_2 = null;
            this.managePowerSleep();
            throw throwable;
        }
        System.out.println("OK");
    }

    private int getSamplingInterval() throws Exception {
        this.sendSequence(SEQ_GET_SCHEDULE);
        String str = this.readLine(this._fromDevice, 1000L);
        str = this.getProperty(str);
        return new Integer(str);
    }

    private void setTime() throws Exception {
        this.sendSequence(SEQ_SET_RTC);
        this.sendCommand(AsciiTime.getDate("MM/DD/YYYY") + " " + AsciiTime.getTime("HH:mm:ss"), "?");
    }

    protected void prepareToSample() throws Exception {
    }

    protected void requestSample() throws TimeoutException, Exception {
        this.flushInput();
        long t0 = System.currentTimeMillis();
        while (this._fromDevice.available() == 0) {
            int secs = this._preemptionTime * 2 - (int)((System.currentTimeMillis() - t0) / 1000L);
            System.out.print("Waiting for ISUS data... " + secs + " \r");
            this.sleep(100);
            if (System.currentTimeMillis() - t0 <= (long)(this._preemptionTime * 1000 * 2)) continue;
            System.out.print("Turning power off for 30 seconds...");
            this.managePowerSleep();
            this.managePowerWake();
            System.out.print("Done");
            System.out.println("Rescheduling service for " + this._initialInterval + " seconds...");
            this.sync(this._initialInterval * 1000L);
            throw new TimeoutException("Failed to receive a sample during preempted interval - resynched");
        }
        System.out.println("\nData detected, rescheduling for " + (this._samplingTime - this._preemptionTime) + " seconds.");
        this.sync((this._samplingTime - this._preemptionTime) * 1000);
    }

    protected int readSample(byte[] sample) throws TimeoutException, IOException, Exception {
        int byteCount = this.extractIsusRecords(this._fromDevice, sample, 10000L);
        return byteCount;
    }

    protected int extractIsusRecords(InputStream instream, byte[] outbuf, long timeout) throws TimeoutException, IOException, Exception {
        String RECORD_TERMINATOR = "\r\n";
        int offset = 0;
        while (true) {
            try {
                String lineBuffer = this.readLine(instream, timeout);
                if (lineBuffer.startsWith("SATNDF", 0)) {
                    System.out.println("Dark Record found!");
                    System.arraycopy(lineBuffer.getBytes(), 0, outbuf, offset, lineBuffer.length());
                    System.arraycopy("\r\n".getBytes(), 0, outbuf, offset += lineBuffer.length(), "\r\n".length());
                    offset += "\r\n".length();
                    continue;
                }
                if (!lineBuffer.startsWith("SATNLF", 0)) continue;
                System.out.println("Light Record found!");
                System.arraycopy(lineBuffer.getBytes(), 0, outbuf, offset, lineBuffer.length());
                System.arraycopy("\r\n".getBytes(), 0, outbuf, offset += lineBuffer.length(), "\r\n".length());
                offset += "\r\n".length();
            }
            catch (TimeoutException e) {
                return offset;
            }
        }
    }

    private String readLine(InputStream instream, long timeout) throws TimeoutException, IOException {
        int EOF = -1;
        int CR = 13;
        int LF = 10;
        int MAX_BUFFER_SIZE = 1721;
        byte[] buf = new byte[1721];
        int i = 0;
        long t0 = System.currentTimeMillis();
        while (i < 1721) {
            if (System.currentTimeMillis() - t0 > timeout) {
                throw new TimeoutException("readline()");
            }
            if (instream.available() == 0) continue;
            int ch = instream.read();
            if (ch == 13) break;
            if (ch == 10) continue;
            buf[i++] = (byte)ch;
            t0 = System.currentTimeMillis();
        }
        return new String(buf, 0, i);
    }

    protected byte[] getInstrumentMetadata() {
        return "Not supported".getBytes();
    }

    public void setClock(long t) {
    }

    private void sendSequence(String cmdSequence) throws Exception {
        StringTokenizer strtok = new StringTokenizer(cmdSequence, ",");
        while (strtok.hasMoreTokens()) {
            String cmd = strtok.nextToken();
            String rsp = strtok.nextToken();
            this.sendCommand(cmd, rsp);
        }
    }

    private void sendCommand(String cmd, String rsp) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, rsp.getBytes(), 3000L, 6844);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            this.write(this._toDevice, this.mkCmd(COMMAND_FORCE_PROMPT));
            this.sleep(500);
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void enterCommandMode() throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(COMMAND_FORCE_PROMPT));
                this.skipUntil(this._fromDevice, "15 secs".getBytes(), 15000L, 6844);
                this.write(this._toDevice, "M".getBytes());
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("skipUntil() " + e);
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("skipUntil() " + e);
            }
            catch (TimeoutException e) {
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("enterCommandMode() - Maximum retries attempted");
    }

    private void exitCommandMode() throws IOException, Exception {
        int i = 0;
        while (i < 10) {
            this.flushInput();
            this.write(this._toDevice, COMMAND_CONTROL_C.getBytes());
            this.sleep(1000);
            if (this._fromDevice.available() == 0) break;
            ++i;
        }
    }

    private void sleep(int msDelay) {
        while (true) {
            try {
                Thread.sleep(msDelay);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private byte[] mkCmd(String cmd) {
        return new String(cmd + "\r").getBytes();
    }

    private int mkInt(byte loByte, byte hiByte) {
        int temp1 = loByte & 0xFF;
        int temp2 = hiByte & 0xFF;
        return temp1 + (temp2 << 8);
    }

    private String getProperty(String response) throws InvalidPropertyException {
        StringTokenizer tkzResponse = new StringTokenizer(response, " \r", false);
        while (tkzResponse.countTokens() > 0) {
            String property = tkzResponse.nextToken();
            if (!property.equals("=")) continue;
            property = tkzResponse.nextToken();
            return property;
        }
        throw new InvalidPropertyException("Invalid ISUS property");
    }

    private String[] parseProperty(String response, String delim, int fieldCount) throws InvalidPropertyException {
        StringTokenizer tkzResponse = new StringTokenizer(response, delim, false);
        if (fieldCount > tkzResponse.countTokens()) {
            throw new InvalidPropertyException("Invalid Workshorse property");
        }
        String[] property = new String[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            property[i] = tkzResponse.nextToken();
            ++i;
        }
        return property;
    }

    protected void printData(byte[] buf) {
        PrintUtils.printFull(buf, 0, 64);
    }

    public int test() {
        return 0;
    }
}

