/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.shmoo;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.PuckSerialInstrumentPort;
import moos.deployed.SerialInstrumentPort;
import moos.deployed.SerialPortParameters;
import moos.utils.StopWatch;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.SensorDataPacket;
import org.mbari.isi.interfaces.TimeoutException;

public class ShmooInstrumentService
extends InstrumentService
implements Instrument {
    static final byte[] SHMOO_REQUEST = "SHMOO SAYS HI\r".getBytes();
    static final String DURATION_KEY = "duration";
    protected int _powerDuration = 2000;
    SerialInstrumentPort _serInstPort = null;

    public ShmooInstrumentService() throws RemoteException {
        DebugMessage.println("ShmooInstrumentService");
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        if (this._instrumentPort instanceof SerialInstrumentPort || this._instrumentPort instanceof PuckSerialInstrumentPort) {
            DebugMessage.println("ShmooInstrumentService has " + this._instrumentPort.getClass().getName() + " InstrumentPort");
            this._serInstPort = (SerialInstrumentPort)this._instrumentPort;
        }
    }

    protected int initInstrumentStartDelay() {
        return 500;
    }

    protected byte[] initPromptString() {
        return ">".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return "\r".getBytes();
    }

    protected int initMaxSampleBytes() {
        return 32;
    }

    protected int initCurrentLimit() {
        return 9000;
    }

    protected int initInstrumentPowerPolicy() {
        return 1;
    }

    protected int initCommunicationPowerPolicy() {
        return 1;
    }

    protected void requestSample() throws IOException {
        DebugMessage.println(new String(this.getName()) + ".requestSample(): entry");
        this.flushInput();
        this.write(this._toDevice, SHMOO_REQUEST);
        DebugMessage.println(new String(this.getName()) + ".requestSample(): exit");
    }

    protected void getAttention(int maxTries) throws Exception {
    }

    protected byte[] getInstrumentMetadata() {
        return "ShmooInstrumentService".getBytes();
    }

    protected SensorDataPacket processSample(byte[] sample, int total_bytes) throws Exception {
        boolean handshake_lo_failed;
        boolean handshake_hi_failed;
        StringBuffer test_results = new StringBuffer(256);
        this._sensorDataPacket.setSystemTime(System.currentTimeMillis());
        boolean loopback_failed = false;
        int i = 0;
        while (i < SHMOO_REQUEST.length) {
            if (sample[i] != SHMOO_REQUEST[i]) {
                loopback_failed = true;
            }
            ++i;
        }
        if (loopback_failed) {
            test_results.append("0\t");
        } else {
            test_results.append("1\t");
        }
        if (this._serInstPort != null) {
            this._serInstPort.setRTS(true);
            StopWatch.delay(100);
            if (this._serInstPort.isCTS()) {
                handshake_hi_failed = false;
                test_results.append("1\t");
            } else {
                handshake_hi_failed = true;
                test_results.append("0\t");
            }
            this._serInstPort.setRTS(false);
            StopWatch.delay(100);
            if (this._serInstPort.isCTS()) {
                handshake_lo_failed = true;
                test_results.append("0\t");
            } else {
                handshake_lo_failed = false;
                test_results.append("1\t");
            }
        } else {
            handshake_lo_failed = false;
            handshake_hi_failed = false;
            test_results.append("NA\t");
            test_results.append("NA\t");
        }
        StopWatch.delay(this._powerDuration);
        DebugMessage.println("channel voltage: " + this._instrumentPort.getVoltageLevel());
        DebugMessage.println("channel current: " + this._instrumentPort.getCurrentLevel());
        test_results.append(this._instrumentPort.getVoltageLevel() + "\t");
        test_results.append(this._instrumentPort.getCurrentLevel() + "\t");
        if (loopback_failed) {
            test_results.append("loopback failed, read '" + new String(sample, 0, total_bytes) + "'");
        }
        if (handshake_hi_failed) {
            if (loopback_failed) {
                test_results.append(", ");
            }
            test_results.append("CTS read LO when RTS was HI");
        }
        if (handshake_lo_failed) {
            if (loopback_failed || handshake_hi_failed) {
                test_results.append(", ");
            }
            test_results.append("CTS read HI when RTS was LO");
        }
        if (!(loopback_failed || handshake_hi_failed || handshake_lo_failed)) {
            test_results.append("all tests passed");
        }
        test_results.append("\r\n");
        this._sensorDataPacket.setDataBuffer(test_results.toString().getBytes());
        return this._sensorDataPacket;
    }

    protected int readSample(byte[] sample) throws TimeoutException, IOException, Exception {
        int bytes_read = 1;
        sample[0] = 0;
        try {
            bytes_read = this.readUntil(this._fromDevice, sample, this.getSampleTerminator(), this.getSampleTimeout());
        }
        catch (TimeoutException e) {
            System.err.println(e.getMessage());
            return bytes_read;
        }
        return bytes_read;
    }

    public void setClock(long t) {
    }

    public int test() {
        return 0;
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(19200, 8, 0, 1);
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(60000L);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        super.loadProperties(input);
        String durationProperty = this._serviceProperties.getProperty(DURATION_KEY);
        boolean valid = true;
        if (durationProperty != null) {
            DebugMessage.println("Shmoo: Found duration property: " + durationProperty);
            int duration = this._powerDuration;
            try {
                duration = Integer.parseInt(durationProperty);
                if (duration < 0) {
                    valid = false;
                }
            }
            catch (NumberFormatException e) {
                valid = false;
            }
            if (!valid) {
                DebugMessage.println("INVALID durationProperty");
                throw new InvalidPropertyException("Invalid duration: " + durationProperty);
            }
            this._powerDuration = duration;
        } else {
            DebugMessage.println("Shmoo: No duration property found");
        }
        DebugMessage.println("Shmoo: power duration = " + this._powerDuration);
    }
}

