/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.seabird;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.RangeException;
import moos.deployed.SerialPortParameters;
import moos.deployed.TimeoutException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class CTD_SeabirdSBE37SM
extends InstrumentService
implements Instrument {
    byte[] _getPrompt = "\r\n".getBytes();
    protected byte[] _requestSample;
    byte[] _requestSampleEcho;
    byte[] _getStatusInfo;
    byte[] _getCalInfo;
    byte[] _getStatusEcho;
    byte[] _getCalEcho;
    byte[] _quitSession;
    byte[] _quitSessionEcho;
    byte[] _haltSample;
    byte[] _haltSampleEcho;
    byte[] _takeSample = "TS\r".getBytes();
    byte[] _takeSampleEcho = "TS\r\n".getBytes();
    byte[] _sendLast = "SL\r".getBytes();
    byte[] _sendLastEcho = "SL\r\n".getBytes();
    byte[] _startNow;
    byte[] _startNowEcho;
    int _maxStatusBytes = 600;
    int _maxCalBytes = 600;
    String _sampleMode = "TS";

    public CTD_SeabirdSBE37SM() throws RemoteException {
        this._requestSample = this._takeSample;
        this._requestSampleEcho = this._takeSampleEcho;
        this._quitSession = "QS\r".getBytes();
        this._quitSessionEcho = "QS".getBytes();
        this._getStatusInfo = "DS\r".getBytes();
        this._getStatusEcho = "DS\r\n".getBytes();
        this._getCalInfo = "DC\r".getBytes();
        this._getCalEcho = "DC\r\n".getBytes();
        this._haltSample = "STOP\r".getBytes();
        this._haltSampleEcho = "STOP".getBytes();
        this._startNow = "STARTNOW\r".getBytes();
        this._startNowEcho = "start now".getBytes();
        try {
            this.setSampleTimeout(15000L);
            this.setMaxSampleTries(3);
        }
        catch (RangeException e) {
            DebugMessage.println(this.getName() + " caught exception " + e);
        }
    }

    protected byte[] initPromptString() {
        return "S>".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return "S>".getBytes();
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 1;
    }

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected int initMaxSampleBytes() {
        return 1000;
    }

    protected void requestSample() {
        try {
            DebugMessage.println("requestSample(): looking for prompt...");
            this.getPrompt(3000L, 0);
            DebugMessage.println("requestSample(): sending sample requesting...");
            this.write(this._toDevice, this._requestSample);
        }
        catch (Exception e) {
            DebugMessage.println(this.getName() + " requestSample() caught exception " + e);
        }
    }

    protected boolean getPrompt(long timeout, int maxChars) {
        try {
            this.flushInput();
            this.write(this._toDevice, this._getPrompt);
            this.skipUntil(this._fromDevice, this.getPromptString(), timeout, maxChars);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private byte[] getInstrumentConfiguration() throws Exception {
        DebugMessage.println("getInstrumentCfg: getPrompt...");
        this.getPrompt(3L, 0);
        DebugMessage.println("Requesting Status Info...");
        this.write(this._toDevice, this._getStatusInfo);
        this.skipUntil(this._fromDevice, this._getStatusEcho, 3L, 0);
        byte[] statusBuf = new byte[this._maxStatusBytes];
        int statusBytes = this.readUntil(this._fromDevice, statusBuf, this.getPromptString(), this.getSampleTimeout());
        DebugMessage.println("Requesting Cal Info...");
        this.write(this._toDevice, this._getCalInfo);
        this.skipUntil(this._fromDevice, this._getCalEcho, 3L, 0);
        byte[] calBuf = new byte[this._maxCalBytes];
        int calBytes = this.readUntil(this._fromDevice, calBuf, this.getPromptString(), this.getSampleTimeout());
        String drvConfig = "";
        drvConfig = drvConfig + "\n_sampleRequest:" + new String(this._requestSample) + "\n";
        byte[] retval = new byte[statusBytes + calBytes + drvConfig.length()];
        int i = 0;
        while (i < statusBytes) {
            retval[i] = statusBuf[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < calBytes) {
            retval[statusBytes + i2] = calBuf[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < drvConfig.length()) {
            retval[statusBytes + calBytes + i3] = (byte)drvConfig.charAt(i3);
            ++i3;
        }
        DebugMessage.println(this.getName() + " Returning from getConfiguration()...");
        DebugMessage.println(statusBytes + "+" + calBytes + "+" + drvConfig.length() + "=" + retval.length);
        return retval;
    }

    protected void stopSampling() throws IOException, Exception, TimeoutException {
        this.getPrompt(3L, 0);
        DebugMessage.println("Stop sampling...");
        this.write(this._toDevice, this._haltSample);
        this.skipUntil(this._fromDevice, this._haltSampleEcho, 3L, 0);
        this.skipUntil(this._fromDevice, this.getPromptString(), 3L, 0);
    }

    protected void resumeSampling() throws IOException, Exception, TimeoutException {
        this.getPrompt(3L, 0);
        if (this._sampleMode.equals("SL")) {
            this.write(this._toDevice, this._startNow);
            this.skipUntil(this._fromDevice, this._startNowEcho, 3L, 0);
        }
    }

    protected void quitSession() throws IOException, Exception, TimeoutException {
        this.getPrompt(3L, 0);
        this.write(this._toDevice, this._quitSession);
        this.skipUntil(this._fromDevice, this._quitSessionEcho, 3L, 0);
    }

    public void setClock(long epochMsecs) {
    }

    public int test() {
        return 0;
    }

    protected void initializeInstrument() throws Exception {
        this.setSampleTimeout(5000L);
        this.managePowerWake();
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(30000L);
    }
}

