/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.sbe37im;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import moos.deployed.AggregateInstrumentService;
import moos.deployed.DebugMessage;
import moos.deployed.SerialPortParameters;
import moos.utils.AsciiTime;
import moos.utils.PrintUtils;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidDataException;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.TimeoutException;

public class SeaBird37im
extends AggregateInstrumentService
implements Instrument {
    static final String MSG_SIM_RESPONSE_FAIL = "SIM failed to respond!";
    static final String MSG_SIM_PWRONCMD_FAIL = "PWRON command failed to respond!";
    static final String MSG_SIM_ECHOOFF_FAIL = "ECHOOFF command failed to respond!";
    static final String MSG_CAT_RESPONSE_FAIL = "CAT failed to respond!";
    static final int MAX_SAMPLE_TYPE1_LEN = 49;
    static final int MAX_SAMPLE_TYPE2_LEN = 57;
    static final int MAX_SAMPLE_TYPE3_LEN = 67;
    static final int MAX_RETRIES = 3;
    static final int MAX_SENSORS = 30;
    static final int MAX_CAT_RESPONSE_BYTES = 67;
    static final int MAX_SIM_RESPONSE_BYTES = 100;
    static final int SIM_RESPONSE_TIME = 8000;
    static final int CAT_RESPONSE_TIME = 10000;
    static final int ECHO_RESPONSE_TIME = 2000;
    static final String PROPERTY_ID_SENSORS = "idMicroCATs";
    static final String PROPERTY_SAMPLE_INTERVAL = "sampleInterval";
    static final String PROPERTY_SAMPLE_SCHEDULE = "sampleSchedule";
    static final String PROPERTY_SUPER_SCHEDULE = "superSchedule";
    static final String PROPERTY_TIME_SYNC = "timeSynchronization";
    static final String COMMAND_FORCE_PROMPT = "\u001b";
    static final String COMMAND_ECHO_OFF = "ECHOOFF";
    static final String COMMAND_PWR_ON = "pwron";
    static final String COMMAND_PWR_OFF = "pwroff";
    static final String COMMAND_STOP_LOGGING = "stop";
    static final String COMMAND_START_LOGGING = "startnow";
    static final String COMMAND_SET_INTERVAL = "interval=";
    static final String COMMAND_SET_DATE = "mmddyy=";
    static final String COMMAND_SET_TIME = "hhmmss=";
    static final String COMMAND_GET_LAST_SAMPLE = "sl";
    static final String COMMAND_GET_SIM_STATUS = "ds";
    static final String COMMAND_GET_CAT_STATUS = "ds";
    static final String RESPONSE_PROMPT = "\r\nS>";
    static final String RESPONSE_OK = "ok\r\nS>";
    static final String RESPONSE_PWRON = "ds\r\nS>";
    static final String RESPONSE_START_LOGGING = "t now\r\nS>";
    static final String RESPONSE_SAMPLE = "\r\nS>";
    private MicroCAT[] _sensor;
    boolean _timeSynch;
    int _superSchedule;
    int _interval;

    public SeaBird37im() throws RemoteException {
        this._numSensors = 10;
    }

    protected void setNumSensors(int numSensors) {
        this._numSensors = numSensors;
    }

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected byte[] initPromptString() {
        return "\r\nS>".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return "\r\nS>".getBytes();
    }

    protected int initMaxSampleBytes() {
        return 69 * this._numSensors;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected int initInstrumentPowerPolicy() {
        return 1;
    }

    protected int initCommunicationPowerPolicy() {
        return 2;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(600000L);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        int[] sensorId;
        super.loadProperties(input);
        System.out.print("Loading properties for " + this._serviceName + " ...");
        String ids = this._serviceProperties.getProperty(PROPERTY_ID_SENSORS, "0-9");
        try {
            sensorId = this.parseIdProperty(ids);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException("idMicroCATs: Syntax error! [" + ids + "]");
        }
        catch (Exception e) {
            throw new InvalidPropertyException("idMicroCATs:Range exception! [" + ids + "]");
        }
        this._sensor = new MicroCAT[sensorId.length];
        int i = 0;
        while (i < this._sensor.length) {
            this._sensor[i] = new MicroCAT(sensorId[i]);
            this._sensor[i].setStatus(1);
            ++i;
        }
        this.setNumSensors(this._sensor.length);
        String interval = this._serviceProperties.getProperty(PROPERTY_SAMPLE_INTERVAL, "0");
        String timeSynch = this._serviceProperties.getProperty(PROPERTY_TIME_SYNC);
        DebugMessage.println("Units = " + ids + " Time synch = " + timeSynch);
        this._timeSynch = timeSynch.compareTo("Y") == 0;
        this._interval = new Integer(interval);
        System.out.println("OK");
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        System.out.print("Initializing " + this._serviceName + "...\n");
        this.setSampleTimeout(10000L);
        this.setMaxSampleTries(3);
        this.setMaxSampleBytes(69 * this._numSensors);
        this.managePowerWake();
        try {
            this.sendCommand(COMMAND_FORCE_PROMPT);
            this.sendCommand(COMMAND_PWR_ON);
        }
        catch (Exception e) {
            throw new InitializeException("initializeInstrument(): " + e);
        }
        System.out.print("Initializing " + this._numSensors + " MicroCATs... ");
        if (this._timeSynch || this._interval != 0) {
            int i = 0;
            while (i < this._numSensors) {
                try {
                    String cmdStr;
                    this.sendCommand(this._sensor[i].getUnitId(), COMMAND_STOP_LOGGING, RESPONSE_OK);
                    this.sleep(500);
                    this._sensor[i].setStatus(0);
                    if (this._interval != 0) {
                        cmdStr = COMMAND_SET_INTERVAL + this._interval / 10 + this._interval % 10;
                        this.sendCommand(this._sensor[i].getUnitId(), cmdStr, RESPONSE_OK);
                        this.sleep(500);
                    }
                    if (this._timeSynch) {
                        cmdStr = COMMAND_SET_DATE + AsciiTime.getDate("MMDDYY");
                        this.sendCommand(this._sensor[i].getUnitId(), cmdStr, RESPONSE_OK);
                        this.sleep(500);
                        cmdStr = COMMAND_SET_TIME + AsciiTime.getTime("HHmmss");
                        this.sendCommand(this._sensor[i].getUnitId(), cmdStr, RESPONSE_OK);
                        this.sleep(500);
                        DebugMessage.println("Date: " + AsciiTime.getDate("MMDDYY") + " Time: " + AsciiTime.getTime("HHmmss"));
                    }
                    this.sendCommand(this._sensor[i].getUnitId(), COMMAND_START_LOGGING, RESPONSE_START_LOGGING);
                    this._sensor[i].setStatus(1);
                    System.out.print("*");
                }
                catch (Exception e) {
                    this._sensor[i].setStatus(4);
                    System.out.print("!");
                }
                ++i;
            }
        }
        try {
            this.sendCommand(COMMAND_PWR_OFF);
        }
        catch (Exception e) {
            throw new InitializeException("initializeInstrument(): " + e);
        }
        System.out.println(" ..OK");
    }

    protected void prepareToSample() throws Exception {
        this.sendCommand(COMMAND_FORCE_PROMPT);
        this.sleep(500);
        this.sendCommand(COMMAND_PWR_ON);
        this.sleep(500);
    }

    protected void requestSample(int moduleRef) throws TimeoutException, Exception {
        this.sendCommand(COMMAND_FORCE_PROMPT);
        DebugMessage.println("Requesting last sample from logging MicroCATs ...");
        if (this._sensor[moduleRef].getStatus() == 1) {
            this.sendCommand(this._sensor[moduleRef].getUnitId(), COMMAND_GET_LAST_SAMPLE);
        }
    }

    protected void validateSample(byte[] buffer, int nBytes) throws InvalidDataException {
        StringTokenizer temp = new StringTokenizer(new String(buffer), ",\\r");
        if (nBytes == 49 && temp.countTokens() == 5 || nBytes == 57 && temp.countTokens() == 6 || nBytes == 67 && temp.countTokens() == 7) {
            return;
        }
        throw new InvalidDataException("Length=" + nBytes + " Fields=" + temp.countTokens());
    }

    protected void postSample() {
        try {
            this.sendCommand(COMMAND_PWR_OFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void printData(byte[] buf) {
        PrintUtils.printFull(buf, 0, buf.length);
    }

    protected byte[] getInstrumentMetadata() {
        return "Not supported".getBytes();
    }

    public void setClock(long t) {
    }

    private void sendCommand(String cmd) throws Exception {
        int i = 0;
        while (i < this.getMaxSampleTries()) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, "\r\nS>".getBytes(), 8000L, 100);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
                this.incBadResponseCount();
            }
            this.write(this._toDevice, this.mkCmd(COMMAND_FORCE_PROMPT));
            this.sleep(500);
            ++i;
        }
        this.incRetryExceededCount();
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void sendCommand(int unitId, String cmd) throws Exception, TimeoutException, NullPointerException, IOException {
        this.flushInput();
        this.write(this._toDevice, this.mkCmd(unitId, cmd));
        this.skipUntil(this._fromDevice, "\r\n".getBytes(), 2000L, this.mkCmd(unitId, cmd).length + 2);
    }

    private void sendCommand(int unitId, String cmd, String response) throws Exception {
        int i = 0;
        while (i < this.getMaxSampleTries()) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(unitId, cmd));
                this.skipUntil(this._fromDevice, response.getBytes(), 10000L, 0);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
                this.incTimeoutCount();
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
                this.incBadResponseCount();
            }
            this.write(this._toDevice, this.mkCmd(COMMAND_FORCE_PROMPT));
            this.sleep(500);
            ++i;
        }
        this.incRetryExceededCount();
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void sleep(int msDelay) {
        while (true) {
            try {
                Thread.sleep(msDelay);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private int[] parseIdProperty(String idProperty) throws NumberFormatException, Exception {
        boolean bRange = false;
        int[] ids = new int[30];
        StringTokenizer str = new StringTokenizer(idProperty, "-, \\t\\n\\r\\f", true);
        int i = 0;
        while (i < ids.length && str.hasMoreTokens()) {
            String token = str.nextToken();
            if (token.equals("-")) {
                bRange = true;
                continue;
            }
            if (token.equals(",") || token.equals(" ")) {
                bRange = false;
                continue;
            }
            int currentId = new Integer(token);
            if (bRange) {
                if (currentId < ids[i - 1]) {
                    throw new Exception("Range error");
                }
                int from = ids[i - 1] + 1;
                while (from <= currentId) {
                    ids[i++] = from++;
                }
                bRange = false;
                continue;
            }
            ids[i++] = currentId;
        }
        int[] temp = new int[i];
        System.arraycopy(ids, 0, temp, 0, i);
        return temp;
    }

    private byte[] mkCmd(int i, String cmd) {
        return new String("#" + i / 10 + i % 10 + cmd + "\r").getBytes();
    }

    private byte[] mkCmd(String cmd) {
        return new String(cmd + "\r").getBytes();
    }

    class MicroCAT {
        private int _unitId;
        private String _serialNum;
        private int _status = 0;

        public MicroCAT() {
        }

        public MicroCAT(int unitId) {
            this();
            this._unitId = unitId;
        }

        public int getStatus() {
            return this._status;
        }

        public void setStatus(int status) {
            this._status = status;
        }

        public void setSerialNum(String serialNum) {
            this._serialNum = serialNum;
        }

        public String getSerialNum() {
            return this._serialNum;
        }

        public void setUnitId(int unitId) {
            this._unitId = unitId;
        }

        public int getUnitId() {
            return this._unitId;
        }

        class Status {
            static final int IDLE = 0;
            static final int LOGGING = 1;
            static final int LOW_BATTERY = 2;
            static final int UNKNOWN = 3;
            static final int NOT_RESPONDING = 4;

            Status() {
            }
        }
    }
}

