/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.pumpedSeabird;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.Naming;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.devices.seabird.CTD_SeabirdSBE37SM;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class CTD_SeabirdSBE37SMP
extends CTD_SeabirdSBE37SM
implements Instrument {
    private static String _pumpRegistryName = null;
    public static final String PUMPREGISTRYNAME_KEY = "pumpRegistryName";
    public Device _pumpService = null;

    protected void requestSample() {
        DebugMessage.setLevel(0L);
        if (this.getPump() == null) {
            System.out.println("No Pump available...forging ahead");
        } else {
            try {
                DebugMessage.println("CTD_SBE37SMP  requestSample()");
                DebugMessage.println("CTD_SBE37SMP  requestSample(): turning pump ON");
                this._pumpService.powerOn();
                DebugMessage.println("CTD_SBE37SMP  requestSample(): waiting 10 sec...");
                Thread.sleep(10000L);
                DebugMessage.println("CTD_SBE37SMP  requestSample(): turning pump OFF");
                this._pumpService.powerOff();
            }
            catch (InterruptedException e) {
            }
            catch (RemoteException r) {
                System.err.println("CTD_SBE37SMP  requestSample: remote exception" + r);
            }
        }
        try {
            DebugMessage.println("requestSample(): looking for prompt...");
            super.getPrompt(3000L, 0);
            DebugMessage.println("requestSample(): sending sample requesting...");
            this.write(this._toDevice, this._requestSample);
        }
        catch (Exception e) {
            DebugMessage.println("CTD_SBE37SMP  requestSample() caught exception " + e);
        }
        DebugMessage.setLevel(0L);
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(30000L);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        super.loadProperties(input);
        String pumpRegistryName = this._serviceProperties.getProperty(PUMPREGISTRYNAME_KEY);
        if (pumpRegistryName != null) {
            _pumpRegistryName = pumpRegistryName;
        }
        DebugMessage.println("CTD_SBE37SMP : _pumpRegistryName=" + _pumpRegistryName);
    }

    protected Device getPump() {
        if (this._pumpService != null) {
            DebugMessage.println("Already have pump service");
            return this._pumpService;
        }
        DebugMessage.println("getPump(): lookup pump service (" + _pumpRegistryName + ")");
        if (_pumpRegistryName == null) {
            System.err.println("getPump(): No Registry Name; setting _pumpService=null");
            this._pumpService = null;
        } else {
            try {
                this._pumpService = (Device)Naming.lookup("rmi://localhost/" + _pumpRegistryName);
            }
            catch (Exception e) {
                System.err.println("getPump() caught exception: " + e);
                this._pumpService = null;
            }
        }
        return this._pumpService;
    }
}

