/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.pumpUser;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.Naming;
import java.rmi.RemoteException;
import moos.deployed.InstrumentService;
import moos.deployed.SerialPortParameters;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.SensorDataPacket;

public class PumpUser
extends InstrumentService
implements Instrument {
    private static String _pumpRegistryName = null;
    public static final String PUMPREGISTRYNAME_KEY = "pumpRegistryName";
    public Device _pumpService = null;

    protected int initInstrumentStartDelay() {
        return 500;
    }

    protected byte[] initPromptString() {
        return ">".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return "\r\n".getBytes();
    }

    protected int initMaxSampleBytes() {
        return 32;
    }

    protected int initCurrentLimit() {
        return 500;
    }

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 2;
    }

    protected void requestSample() throws IOException {
        System.out.println("PumpUser.RequestSample");
    }

    protected void getAttention(int maxTries) throws Exception {
    }

    protected byte[] getInstrumentMetadata() {
        return "PumpUser METADATA GOES HERE".getBytes();
    }

    public SensorDataPacket getData() throws NoDataException {
        if (this.getPump() == null) {
            System.out.println("No Pump available...forging ahead");
        } else {
            try {
                System.out.println("PumpUser.getData()");
                System.out.println("PumpUser.getData(): turning pump ON");
                this._pumpService.powerOn();
                System.out.println("PumpUser.getData(): waiting 5 sec...");
                Thread.sleep(5000L);
                System.out.println("PumpUser.getData(): turning pump OFF");
                this._pumpService.powerOff();
            }
            catch (InterruptedException e) {
            }
            catch (RemoteException r) {
                System.err.println("PumpUser.getData: remote exception" + r);
            }
        }
        SensorDataPacket packet = new SensorDataPacket(this.getId(), 100);
        packet.setSystemTime(System.currentTimeMillis());
        packet.setDataBuffer("This is pump user data".getBytes());
        return packet;
    }

    public void setClock(long t) {
    }

    public int test() {
        return 0;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(20000L);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        System.out.println("PumpUser: Setting Properties ***************");
        super.loadProperties(input);
        String pumpRegistryName = this._serviceProperties.getProperty(PUMPREGISTRYNAME_KEY);
        if (pumpRegistryName != null) {
            _pumpRegistryName = pumpRegistryName;
        }
        System.out.println("PumpUser: _pumpRegistryName=" + _pumpRegistryName);
    }

    protected Device getPump() {
        if (this._pumpService != null) {
            System.out.println("Already have pump service");
            return this._pumpService;
        }
        System.out.println("getPump(): lookup pump service (" + _pumpRegistryName + ")");
        if (_pumpRegistryName == null) {
            System.err.println("getPump(): No Registry Name; setting _pumpService=null");
            this._pumpService = null;
        } else {
            try {
                this._pumpService = (Device)Naming.lookup("rmi://localhost/" + _pumpRegistryName);
            }
            catch (Exception e) {
                System.err.println("getPump() caught exception: " + e);
                this._pumpService = null;
            }
        }
        return this._pumpService;
    }
}

