/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.pump;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.Naming;
import java.rmi.RemoteException;
import moos.deployed.InstrumentService;
import moos.deployed.SerialPortParameters;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.SensorDataPacket;

public class Pump
extends InstrumentService
implements Instrument {
    protected int initInstrumentStartDelay() {
        return 500;
    }

    protected byte[] initPromptString() {
        return ">".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return "\r\n".getBytes();
    }

    protected int initMaxSampleBytes() {
        return 32;
    }

    protected int initCurrentLimit() {
        return 1500;
    }

    protected int initInstrumentPowerPolicy() {
        return 1;
    }

    protected int initCommunicationPowerPolicy() {
        return 2;
    }

    protected void requestSample() throws IOException {
        System.out.println("Pump.requestSample()");
    }

    protected void getAttention(int maxTries) throws Exception {
    }

    protected byte[] getInstrumentMetadata() {
        return "Pump METADATA GOES HERE".getBytes();
    }

    public SensorDataPacket getData() throws NoDataException {
        SensorDataPacket packet = new SensorDataPacket(this.getId(), 100);
        packet.setSystemTime(System.currentTimeMillis());
        packet.setDataBuffer("This is dummy pump data".getBytes());
        return packet;
    }

    public void setClock(long t) {
    }

    public int test() {
        return 0;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier();
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        super.loadProperties(input);
        System.out.println("Pump.setProperties(): registering as (" + this._registryName + ")");
        if (this._registryName == null) {
            return;
        }
        System.out.println("Pump.setProperties(): binding name");
        try {
            Naming.bind(this._registryName, this);
        }
        catch (Exception e) {
            System.out.println("Pump.setProperties(): " + e);
        }
    }
}

