/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.msp430;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.SerialPortParameters;
import moos.deployed.TimeoutException;
import moos.utils.StopWatch;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class MSP430
extends InstrumentService
implements Instrument {
    protected static MSP430 _instance = null;
    private byte[] _tmpBuf = new byte[256];
    protected static final int ENV_METADATA_BYTES = 50;

    public MSP430() throws RemoteException {
        _instance = this;
    }

    protected byte[] initPromptString() {
        return "> ".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return "\r\n".getBytes();
    }

    protected int initMaxSampleBytes() {
        return 256;
    }

    protected int initCurrentLimit() {
        return 500;
    }

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 2;
    }

    protected int initInstrumentStartDelay() {
        return 500;
    }

    protected synchronized void requestSample() throws IOException {
        this.flushInput();
        this.write(this._toDevice, "\n".getBytes());
        try {
            this.readUntil(this._fromDevice, this._tmpBuf, this.getPromptString(), 15000L);
        }
        catch (Exception e) {
            System.err.println(this.getName() + ".requestSample() - caught exception: " + e.getMessage());
        }
        this.flushInput();
        this.write(this._toDevice, "get data\n".getBytes());
    }

    protected synchronized void initializeInstrument() throws InitializeException, Exception {
        this.setSampleTimeout(3000L);
        this.managePowerWake();
        this.flushInput();
        this.write(this._toDevice, "set echo off\n".getBytes());
        this.flushInput();
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    public void setClock(long t) {
    }

    public int test() {
        return 0;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(30000L);
    }

    public static MSP430 getInstance() {
        return _instance;
    }

    public synchronized String commandAndReply(String cmd, long timeout) throws TimeoutException, NullPointerException, IOException, Exception {
        byte[] buf = this.getSampleBuf();
        DebugMessage.print("MSP430.commandAndReply: " + cmd);
        this.write(this._toDevice, "\n".getBytes());
        StopWatch.delay(100);
        this.flushInput();
        this.write(this._toDevice, cmd.getBytes());
        if (cmd.indexOf(10) < 0) {
            this.write(this._toDevice, "\n".getBytes());
        }
        this.readUntil(this._fromDevice, buf, this.getPromptString(), timeout);
        String reply = new String(buf).trim();
        DebugMessage.println(" = " + reply);
        return reply;
    }

    public String commandAndReply(String cmd) throws TimeoutException, NullPointerException, IOException, Exception {
        return this.commandAndReply(cmd, this.getSampleTimeout());
    }
}

