/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.metsys;

import gnu.io.UnsupportedCommOperationException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.StringTokenizer;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.SerialPortParameters;
import moos.utils.AsciiTime;
import moos.utils.PrintUtils;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidDataException;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.TimeoutException;

public class Metsys
extends InstrumentService
implements Instrument {
    static final int CHARS_PER_RECORD = 10;
    static final int RECORDS_PER_ARRAY = 15;
    static final int CHARS_PER_ARRAY = 160;
    static final int MAX_RESPONSE_BYTES = 256;
    static final int MAX_ARRAYS = 4;
    static final int MAX_SAMPLE_BYTES = 640;
    static final int MAX_SAMPLE_TRIES = 3;
    static final int MAX_COMMAND_TRIES = 3;
    static final int WAKEUP_TIME = 2000;
    static final int RESPONSE_TIME = 2000;
    static final int SAMPLE_RESPONSE_TIME = 2000;
    static final int ECHO_RESPONSE_TIME = 1000;
    static final String DEFAULT_TIME_SYNC = "Y";
    static final String DEFAULT_RETRO_SAVE = "100";
    static final String COMMAND_PROMPT = "";
    static final String COMMAND_SET_DATE = "C";
    static final String COMMAND_ACQUIRE = "D";
    static final String COMMAND_BACKUP = "B";
    static final String COMMAND_GOTO = "G";
    static final String COMMAND_SLEEP = "E";
    static final String COMMAND_STATUS = "A";
    static final String SAMPLE_TERMINATOR = "\r\n A";
    static final String RESPONSE_PROMPT = "*";
    static final int BYTES_PER_ARRAY = 16;
    static final int CHECKSUM_MODULUS = 8192;
    static final String SIAM_HOME_KEY = "siam_home";
    private boolean _timeSynch = false;
    private int _reference = 0;
    private int _arraysToFetch = 0;
    private File _metLoc;
    private int _retroSave;

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected byte[] initPromptString() {
        return COMMAND_PROMPT.getBytes();
    }

    protected byte[] initSampleTerminator() {
        return SAMPLE_TERMINATOR.getBytes();
    }

    protected int initMaxSampleBytes() {
        return 640;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected int initInstrumentPowerPolicy() {
        return 0;
    }

    protected int initCommunicationPowerPolicy() {
        return 1;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(600L);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        System.out.print("Loading properties for " + this._serviceName + " ...");
        super.loadProperties(input);
        String timeSynch = this._serviceProperties.getProperty("timeSynchronization", DEFAULT_TIME_SYNC);
        this._timeSynch = timeSynch.compareTo(DEFAULT_TIME_SYNC) == 0;
        String retroSave = this._serviceProperties.getProperty("retroSave", DEFAULT_RETRO_SAVE);
        this._retroSave = Integer.parseInt(retroSave);
        System.out.println("OK");
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        System.out.print("Initializing " + this._serviceName + "...");
        Properties props = System.getProperties();
        String siamHome = props.getProperty(SIAM_HOME_KEY);
        this._metLoc = new File(siamHome + "/logs/metloc");
        this.setMaxSampleTries(3);
        this.setSampleTimeout(2000L);
        this.setMaxSampleBytes(160 * this._retroSave);
        this.managePowerWake();
        try {
            try {
                this.enterCommandMode();
                if (this._timeSynch) {
                    this.setTime();
                }
                this.getCurrentLocation();
            }
            catch (Exception e) {
                throw new InitializeException("initializeInstrument() " + e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.exitCommandMode();
            this.managePowerSleep();
            throw throwable;
        }
        this.exitCommandMode();
        this.managePowerSleep();
        System.out.println("OK");
    }

    private void setTime() throws Exception {
        String now = AsciiTime.getDate("YY:ddd") + ":" + AsciiTime.getTime("HH:mm:ss");
        this.sendCommand(now + COMMAND_SET_DATE);
    }

    protected void prepareToSample() throws Exception {
        System.out.print("Preparing to sample " + this._serviceName + "...");
        this.enterCommandMode();
        String response = this.sendRequest(COMMAND_STATUS);
        this._reference = this.getParameter(response, 'R');
        int limit = this.getParameter(response, 'F');
        int location = this.getCurrentLocation();
        int offset = this._reference - location;
        if (offset < 0) {
            offset += limit;
        }
        this._arraysToFetch = offset / 16;
        System.out.println(COMMAND_PROMPT);
        System.out.println("Reference = " + this._reference + " Limit = " + limit + " Location = " + location);
        if (this._arraysToFetch == 0) {
            this.exitCommandMode();
            throw new Exception("No Samples to fetch!");
        }
        if (this._arraysToFetch > this._retroSave) {
            System.out.println("WARNING: loss of " + (this._arraysToFetch - this._retroSave) + " arrays!");
            this._arraysToFetch = this._retroSave;
        }
        System.out.println("Fetching " + this._arraysToFetch + " Arrays");
        this.sendCommand(this._arraysToFetch + COMMAND_BACKUP);
        System.out.println("OK");
    }

    protected void requestSample() throws TimeoutException, Exception {
        System.out.println("Sampling " + this._serviceName + "...");
        this.sendCommand(this._arraysToFetch + COMMAND_ACQUIRE, this._arraysToFetch + COMMAND_ACQUIRE + "\r\n");
    }

    private int getParameter(String buf, char ch) {
        String format = new Character(ch).toString();
        buf = buf.replace('+', '0');
        buf = buf.replace('.', ' ');
        StringTokenizer st = new StringTokenizer(buf, format + " ", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equals(format)) continue;
            return Integer.parseInt(st.nextToken());
        }
        return 0;
    }

    protected void validateSample(byte[] _sampleBuf, int nBytes) throws InvalidDataException {
        int actualChecksum = 0;
        byte[] buf = new byte[256];
        try {
            this.readUntil(this._fromDevice, buf, RESPONSE_PROMPT.getBytes(), 2000L);
        }
        catch (Exception e) {
            throw new InvalidDataException("Failed to read checksum line");
        }
        int expectedChecksum = this.getParameter(new String(buf), 'C');
        int i = 0;
        while (i < nBytes) {
            actualChecksum += _sampleBuf[i];
            ++i;
        }
        byte[] temp = SAMPLE_TERMINATOR.getBytes();
        int i2 = 0;
        while (i2 < temp.length) {
            actualChecksum += temp[i2];
            ++i2;
        }
        temp = new String(this._arraysToFetch + COMMAND_ACQUIRE + "\r\n").getBytes();
        int i3 = 0;
        while (i3 < temp.length) {
            actualChecksum += temp[i3];
            ++i3;
        }
        int i4 = 0;
        while (i4 < buf.length) {
            actualChecksum += buf[i4];
            if (buf[i4] == 67) break;
            ++i4;
        }
        if (actualChecksum % 8192 != expectedChecksum) {
            throw new InvalidDataException("Bad Checksum");
        }
    }

    protected void postSample() {
        try {
            this.setCurrentLocation(this._reference);
            this.exitCommandMode();
        }
        catch (Exception e) {
            System.err.println("postSample() failed: " + e);
        }
    }

    protected byte[] getInstrumentMetadata() {
        return "Not supported".getBytes();
    }

    public void setClock(long t) {
    }

    private void sendCommand(String cmd) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, RESPONSE_PROMPT.getBytes(), 2000L, 256);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void sendCommand(String cmd, String rsp) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, rsp.getBytes(), 2000L, 256);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private String sendRequest(String request) throws Exception {
        byte[] response = new byte[256];
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(request));
                this.skipUntil(this._fromDevice, "\r\n".getBytes(), 1000L, this.mkCmd(request).length + 2);
                this.readUntil(this._fromDevice, response, RESPONSE_PROMPT.getBytes(), 2000L);
                return new String(response);
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + request + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + request + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Request=" + request);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            this.write(this._toDevice, "\r".getBytes());
            this.sleep(500);
            ++i;
        }
        throw new Exception("sendCommand(" + request + ") - Maximum retries attempted");
    }

    private void enterCommandMode() throws Exception {
        this.write(this._toDevice, "\r".getBytes());
        this.sleep(100);
        this.flushInput();
        this.sendCommand(COMMAND_PROMPT, RESPONSE_PROMPT);
    }

    private void exitCommandMode() throws Exception {
        this.sendCommand(COMMAND_SLEEP, COMMAND_SLEEP);
    }

    private void sleep(int msDelay) {
        while (true) {
            try {
                Thread.sleep(msDelay);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private byte[] mkCmd(String cmd) {
        return new String(cmd + "\r").getBytes();
    }

    protected void printData(byte[] buf) {
        PrintUtils.printFull(buf, 0, 64);
    }

    public int test() {
        return 0;
    }

    private void setCurrentLocation(int location) throws Exception, IOException {
        if (!this._metLoc.exists()) {
            this._metLoc.createNewFile();
        }
        FileOutputStream os = new FileOutputStream(this._metLoc);
        DataOutputStream dout = new DataOutputStream(os);
        dout.writeInt(location);
        dout.close();
    }

    private int getCurrentLocation() throws Exception, IOException {
        int location = 0;
        if (this._metLoc.exists()) {
            FileInputStream is = new FileInputStream(this._metLoc);
            DataInputStream din = new DataInputStream(is);
            location = din.readInt();
            din.close();
        } else {
            String response = this.sendRequest(COMMAND_STATUS);
            location = this.getParameter(response, 'R');
            this.setCurrentLocation(location);
        }
        return location;
    }
}

