/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.kvh;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.SerialPortParameters;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class CompassKVHC100
extends InstrumentService
implements Instrument {
    protected static final int KVH_METADATA_BYTES = 50;

    protected int initInstrumentStartDelay() {
        return 500;
    }

    protected byte[] initPromptString() {
        return ">".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return "\r\n".getBytes();
    }

    protected int initMaxSampleBytes() {
        return 32;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 2;
    }

    protected void requestSample() throws IOException {
        this.flushInput();
        this.write(this._toDevice, "d0\r".getBytes());
    }

    protected void getAttention(int maxTries) throws Exception {
        int i = 0;
        while (i < maxTries) {
            this.write(this._toDevice, "h\r".getBytes());
            try {
                this.skipUntil(this._fromDevice, this.getPromptString(), 500L);
                break;
            }
            catch (Exception e) {
                System.err.println(new String(this.getName()) + ".getAttention(): " + "Couldn't set to polled mode");
                if (i == maxTries - 1) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        this.setSampleTimeout(1000L);
        this.managePowerWake();
        this.getAttention(5);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(4800, 8, 0, 1);
    }

    protected byte[] getInstrumentMetadata() {
        byte[] tmpBuf = new byte[50];
        byte[] buf = "\nKVH metadata: ".getBytes();
        System.arraycopy(buf, 0, tmpBuf, 0, buf.length);
        int offset = buf.length;
        buf = new byte[50];
        int nBytes = 0;
        try {
            this.getAttention(20);
            this.write(this._toDevice, "?w\r".getBytes());
            nBytes = this.readUntil(this._fromDevice, buf, this.getSampleTerminator(), 500L);
        }
        catch (Exception e) {
            System.out.println("Couldn't get KVH metadata!");
            buf = "Couldn't get KVH metadata".getBytes();
            nBytes = buf.length;
        }
        DebugMessage.println("Copy KVH metadata: offset=" + offset + ", nBytes=" + nBytes);
        System.arraycopy(buf, 0, tmpBuf, offset, nBytes);
        byte[] returnBuf = new byte[tmpBuf.length];
        System.arraycopy(tmpBuf, 0, returnBuf, 0, tmpBuf.length);
        return returnBuf;
    }

    public void setClock(long t) {
    }

    public int test() {
        return 0;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(15000L);
    }
}

