/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.hobilabs;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.SerialPortParameters;
import moos.utils.AsciiTime;
import moos.utils.PrintUtils;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.TimeoutException;

public class HydroRad
extends InstrumentService
implements Instrument {
    static final int MAX_RESPONSE_BYTES = 1000;
    static final int MAX_RESPONSE_COMMAND_BYTES = 20;
    static final int MAX_SAMPLE_TRIES = 3;
    static final int MAX_COMMAND_TRIES = 3;
    static final int MAX_REQUEST_BYTES = 80;
    static final int MAX_SAMPLE_BYTES = 33600;
    static final int RESPONSE_TIME = 10000;
    static final int PROMPT_RESPONSE_TIME = 1000;
    static final int ECHO_RESPONSE_TIME = 2000;
    static final int SAMPLE_RESPONSE_TIME = 360000;
    static final int POWER_UP_TIME = 10000;
    static final String DEFAULT_TIME_SYNC = "N";
    static final String DEFAULT_ACQUIRE_PARAM = "AUTO,3,1,,0,0,2,1234";
    static final String COMMAND_FORCE_PROMPT = "";
    static final String COMMAND_CONTROL_C = "\u0003";
    static final String COMMAND_SLEEP = "SLEEP";
    static final String COMMAND_SET_RTC = "DATE";
    static final String COMMAND_ACQUIRE = "ACQUIRE";
    static final String COMMAND_POWER_ON = "POWER ON";
    static final String COMMAND_SHUTTER_OPEN = "SHUTTER OPEN";
    static final String COMMAND_SHUTTER_CLOSED = "SHUTTER CLOSE";
    static final String SAMPLE_TERMINATOR = "Hydro";
    static final String RESPONSE_PROMPT = "Rad>";
    static final String RESPONSE_EOL = "\r\n";
    static final String DATA_SYNC = ", .";
    private String _acquireParams;
    private boolean _timeSynch;

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected byte[] initPromptString() {
        return RESPONSE_PROMPT.getBytes();
    }

    protected byte[] initSampleTerminator() {
        return SAMPLE_TERMINATOR.getBytes();
    }

    protected int initMaxSampleBytes() {
        return 33600;
    }

    protected int initCurrentLimit() {
        return 2000;
    }

    protected int initInstrumentPowerPolicy() {
        return 1;
    }

    protected int initCommunicationPowerPolicy() {
        return 1;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(600L);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        super.loadProperties(input);
        System.out.print("Loading properties for " + this._serviceName + " ...");
        String timeSynch = this._serviceProperties.getProperty("timeSynchronization", DEFAULT_TIME_SYNC);
        this._timeSynch = timeSynch.compareTo("Y") == 0;
        this._acquireParams = this._serviceProperties.getProperty("acquireParams", DEFAULT_ACQUIRE_PARAM);
        System.out.println("OK");
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        System.out.print("Initializing " + this._serviceName + "...");
        this.setMaxSampleTries(3);
        this.setSampleTimeout(360000L);
        this.managePowerWake();
        if (this.getInstrumentPowerPolicy() == 1) {
            this.sleep(10000);
        }
        try {
            block5: {
                try {
                    this.enterCommandMode();
                    this.sendCommand(COMMAND_SHUTTER_CLOSED);
                    if (!this._timeSynch) break block5;
                    this.setTime();
                }
                catch (Exception e) {
                    throw new InitializeException("initializeInstrument() " + e);
                }
            }
            Object var6_1 = null;
        }
        catch (Throwable throwable) {
            Object var6_2 = null;
            this.exitCommandMode();
            this.managePowerSleep();
            throw throwable;
        }
        this.exitCommandMode();
        this.managePowerSleep();
        System.out.println("OK");
    }

    private void setTime() throws Exception {
        String now = AsciiTime.getDate("MM/DD/YYYY") + " " + AsciiTime.getTime("HH:mm:ss");
        this.sendCommand("DATE " + now);
    }

    protected void prepareToSample() throws Exception {
        if (this.getInstrumentPowerPolicy() == 1) {
            this.sleep(10000);
            this.enterCommandMode();
            this.setTime();
        }
        this.sendCommand(COMMAND_POWER_ON);
        this.sendCommand(COMMAND_SHUTTER_OPEN);
    }

    protected void requestSample() throws TimeoutException, Exception {
        String cmd = "ACQUIRE " + this._acquireParams;
        System.out.println("requestSample() - " + cmd);
        this.sendCommand(cmd, RESPONSE_EOL);
        this.skipUntil(this._fromDevice, DATA_SYNC.getBytes(), 360000L, 1000);
    }

    protected void postSample() {
        try {
            this.sendCommand(COMMAND_SHUTTER_CLOSED);
            this.exitCommandMode();
        }
        catch (Exception e) {
            System.err.println("postSample() failed: " + e);
        }
    }

    protected byte[] getInstrumentMetadata() {
        return "Not supported".getBytes();
    }

    public void setClock(long t) {
    }

    private void sendCommand(String cmd) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, RESPONSE_PROMPT.getBytes(), 10000L, 1000);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            this.write(this._toDevice, this.mkCmd(COMMAND_FORCE_PROMPT));
            this.sleep(500);
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void sendCommand(String cmd, String rsp) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, rsp.getBytes(), 10000L, 1000);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            this.write(this._toDevice, this.mkCmd(COMMAND_FORCE_PROMPT));
            this.sleep(500);
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void enterCommandMode() throws Exception {
        int i = 0;
        while (i < this.getMaxSampleTries()) {
            try {
                this.flushInput();
                this.write(this._toDevice, COMMAND_CONTROL_C.getBytes());
                this.skipUntil(this._fromDevice, RESPONSE_PROMPT.getBytes(), 1000L, 20);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("skipUntil() " + e);
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("skipUntil() " + e);
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("enterCommandMode() - Maximum retries attempted");
    }

    private void exitCommandMode() throws IOException, Exception {
        this.write(this._toDevice, this.mkCmd(COMMAND_SLEEP));
    }

    private void sleep(int msDelay) {
        while (true) {
            try {
                Thread.sleep(msDelay);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private byte[] mkCmd(String cmd) {
        return new String(cmd + "\r").getBytes();
    }

    private int mkInt(byte loByte, byte hiByte) {
        int temp1 = loByte & 0xFF;
        int temp2 = hiByte & 0xFF;
        return temp1 + (temp2 << 8);
    }

    private String getProperty(String response) throws InvalidPropertyException {
        StringTokenizer tkzResponse = new StringTokenizer(response, " ", false);
        while (tkzResponse.countTokens() > 0) {
            String property = tkzResponse.nextToken();
            if (!property.equals("=")) continue;
            property = tkzResponse.nextToken();
            return property;
        }
        throw new InvalidPropertyException("Invalid HydroRad property");
    }

    private String[] parseProperty(String response, String delim, int fieldCount) throws InvalidPropertyException {
        StringTokenizer tkzResponse = new StringTokenizer(response, delim, false);
        if (fieldCount > tkzResponse.countTokens()) {
            throw new InvalidPropertyException("Invalid HydroRad property");
        }
        String[] property = new String[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            property[i] = tkzResponse.nextToken();
            ++i;
        }
        return property;
    }

    protected void printData(byte[] buf) {
        PrintUtils.printFull(buf, 0, 64);
    }

    public int test() {
        return 0;
    }
}

