/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.gashound;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.SerialPortParameters;
import moos.utils.AsciiTime;
import moos.utils.PrintUtils;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.TimeoutException;

public class GashoundSubsystem
extends InstrumentService
implements Instrument {
    static final int MAX_RESPONSE_BYTES = 256;
    static final int MAX_SAMPLE_BYTES = 512;
    static final int MAX_SAMPLE_TRIES = 3;
    static final int MAX_COMMAND_TRIES = 3;
    static final int MAX_ATTENTION_TRIES = 20;
    static final int WAKEUP_TIME = 60000;
    static final int SYNC_TIME = 2000;
    static final int RESPONSE_TIME = 60000;
    static final int SAMPLE_RESPONSE_TIME = 60000;
    static final String DEFAULT_SCHEDULE = "A 0 50 * * * * * * GMT *";
    static final String COMMAND_PROMPT = "";
    static final String COMMAND_SET_DATE = "date";
    static final String COMMAND_ACQUIRE = "data";
    static final String COMMAND_SLEEP = "quit";
    static final String COMMAND_STOPLOG = "stoplog";
    static final String COMMAND_DEPLOY = "deploy";
    static final String SAMPLE_TERMINATOR = "<<";
    static final String RESPONSE_PROMPT = "SOON>";
    static final String DATA_SYNC = ">>";
    private boolean _bInitialized = false;

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected byte[] initPromptString() {
        return COMMAND_PROMPT.getBytes();
    }

    protected byte[] initSampleTerminator() {
        return SAMPLE_TERMINATOR.getBytes();
    }

    protected int initMaxSampleBytes() {
        return 512;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected int initInstrumentPowerPolicy() {
        return 0;
    }

    protected int initCommunicationPowerPolicy() {
        return 1;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(DEFAULT_SCHEDULE);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        System.out.print("Loading properties for " + this._serviceName + " ...");
        super.loadProperties(input);
        System.out.println("OK");
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        System.out.print("Initializing " + this._serviceName + "...");
        this.setMaxSampleTries(3);
        this.setSampleTimeout(60000L);
        System.out.println("OK");
    }

    private void setTime() throws Exception {
        String now = AsciiTime.getDate("MM/DD/YY") + " " + AsciiTime.getTime("HH:mm:ss");
        this.sendCommand(COMMAND_SET_DATE, "?");
        this.sendCommand(now);
    }

    protected void prepareToSample() throws Exception {
        System.out.print("Preparing to sample " + this._serviceName + "...");
        this.enterCommandMode();
        if (!this._bInitialized) {
            this.sendCommand(COMMAND_STOPLOG);
            this.setTime();
        }
        System.out.println("OK");
    }

    protected void requestSample() throws TimeoutException, Exception {
        System.out.print("Sampling " + this._serviceName + "...");
        this.sendCommand(COMMAND_ACQUIRE, DATA_SYNC);
        System.out.println("detected!");
    }

    protected void postSample() {
        try {
            this.sendCommand(COMMAND_PROMPT);
            if (!this._bInitialized) {
                this.sendCommand(COMMAND_DEPLOY, COMMAND_DEPLOY);
                this._bInitialized = true;
            } else {
                this.sendCommand(COMMAND_SLEEP, COMMAND_SLEEP);
            }
        }
        catch (Exception e) {
            System.err.println("postSample() failed: " + e);
        }
    }

    protected byte[] getInstrumentMetadata() {
        return "Not supported".getBytes();
    }

    public void setClock(long t) {
    }

    private void sendCommand(String cmd) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, RESPONSE_PROMPT.getBytes(), 60000L, 256);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void sendCommand(String cmd, String rsp) throws Exception {
        int i = 0;
        while (i < 3) {
            try {
                this.flushInput();
                this.write(this._toDevice, this.mkCmd(cmd));
                this.skipUntil(this._fromDevice, rsp.getBytes(), 60000L, 256);
                return;
            }
            catch (IOException e) {
                DebugMessage.println("IOException" + e);
                throw new Exception("sendCommand(" + cmd + ") - Stream I/O failure");
            }
            catch (NullPointerException e) {
                DebugMessage.println("Null Pointer Exception" + e);
                throw new Exception("sendCommand(" + cmd + ") - Null pointer");
            }
            catch (TimeoutException e) {
                DebugMessage.println("Timeout Exception: " + e + "Cmd=" + cmd);
            }
            catch (Exception e) {
                DebugMessage.println("Exception" + e);
            }
            ++i;
        }
        throw new Exception("sendCommand(" + cmd + ") - Maximum retries attempted");
    }

    private void enterCommandMode() throws Exception {
        int i = 0;
        while (i < 20) {
            this.flushInput();
            byte[] ch = new byte[]{33};
            this.write(this._toDevice, ch);
            long t0 = System.currentTimeMillis();
            while (System.currentTimeMillis() - t0 < 60000L) {
                if (this._fromDevice.available() == 0) continue;
                this.write(this._toDevice, ch);
                this.skipUntil(this._fromDevice, RESPONSE_PROMPT.getBytes(), 60000L, 256);
                return;
            }
            ++i;
        }
        throw new Exception("Failed to wake up Gashound!");
    }

    private void sleep(int msDelay) {
        while (true) {
            try {
                Thread.sleep(msDelay);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private byte[] mkCmd(String cmd) {
        return new String(cmd + "\r").getBytes();
    }

    protected void printData(byte[] buf) {
        PrintUtils.printFull(buf, 0, 64);
    }

    public int test() {
        return 0;
    }
}

