/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.garmin;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.RangeException;
import moos.deployed.SerialPortParameters;
import moos.devices.garmin.NMEAString;
import moos.utils.ByteUtility;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class Garmin_25HVS_GPS
extends InstrumentService
implements Instrument {
    int _firstFixTimeout = 900000;
    int _warmupDelay = 2000;
    int _GPS_BAUD = 4800;
    int _GPS_DATA = 8;
    int _GPS_STOP = 1;
    int _GPS_PARITY = 0;
    boolean _warmupDone = false;

    public Garmin_25HVS_GPS() throws RemoteException {
        try {
            this.setSampleTimeout(10000L);
            this.setMaxSampleTries(15);
        }
        catch (RangeException e) {
            DebugMessage.println(this.getName() + " caught exception " + e);
        }
    }

    protected byte[] initPromptString() {
        return "\r\n".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return "\r\n".getBytes();
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 2;
    }

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected int initMaxSampleBytes() {
        return 512;
    }

    public void initializeInstrument() {
        DebugMessage.setLevel(0L);
        this.managePowerWake();
        DebugMessage.println("initializeInstrument(): Setting Up GPS");
        try {
            this.initializeGPS();
        }
        catch (Exception e) {
            DebugMessage.println(this.getName() + ": initialize() caught Exception initializeGPS() " + e);
        }
        this.managePowerSleep();
        DebugMessage.setLevel(0L);
    }

    private void initializeGPS() throws IOException, Exception {
        DebugMessage.setLevel(0L);
        try {
            Thread.sleep(this._warmupDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.disableAllNMEA();
        this.setNMEAMessage("GPRMC,1");
        this.setNMEAMessage("GPGSV,1");
        this.setNMEAMessage("PGRMT,1");
        this._warmupDone = false;
        DebugMessage.setLevel(0L);
    }

    public void cyclePower(int delay) {
        DebugMessage.setLevel(0L);
        DebugMessage.println("Cycling Power OFF");
        this._instrumentPort.disconnectPower();
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        DebugMessage.println("Cycling Power ON");
        this._instrumentPort.connectPower();
        DebugMessage.setLevel(0L);
    }

    public boolean searchSky(long timeout, NMEAString theMessage, byte[] sample) throws Exception {
        DebugMessage.setLevel(0L);
        long now = System.currentTimeMillis();
        while (System.currentTimeMillis() - now < timeout) {
            long minute = System.currentTimeMillis();
            DebugMessage.println("searchSky() GPS warming up..." + (timeout - (System.currentTimeMillis() - now)) + " remaining");
            while (System.currentTimeMillis() - minute < 60000L) {
                Thread.yield();
            }
            DebugMessage.println("searchSky(): attempting fix");
            if (!this.getFix(theMessage, sample)) continue;
            return true;
        }
        DebugMessage.setLevel(0L);
        return false;
    }

    public void setNMEAMessage(String msg) {
        DebugMessage.setLevel(0L);
        String m = "$PGRMO," + msg + "\r\n";
        DebugMessage.println("setNMEAMessage(): setting " + m);
        try {
            this.write(this._toDevice, m.getBytes());
            this.skipUntil(this._fromDevice, m.getBytes(), this.getSampleTimeout(), 0);
        }
        catch (Exception e) {
            DebugMessage.println("setNMEAMessage():  caught Exception " + e);
        }
        DebugMessage.setLevel(0L);
    }

    public void sync() {
        DebugMessage.setLevel(0L);
        DebugMessage.println("getNextMessage(): Synchronizing...");
        try {
            this.flushInput();
            this.skipUntil(this._fromDevice, this.getPromptString(), this.getSampleTimeout(), 0);
        }
        catch (Exception e) {
            DebugMessage.println("sync() caught " + e);
        }
        DebugMessage.setLevel(0L);
    }

    public void enableNMEAMessage(String msg) {
        this.setNMEAMessage(msg + ",1");
    }

    public void disableNMEAMessage(String msg) {
        this.setNMEAMessage(msg + ",2");
    }

    public void disableAllNMEA() {
        DebugMessage.setLevel(0L);
        DebugMessage.println("disableAllNMEA(): Turning all NMEA messages OFF ");
        this.setNMEAMessage(",2");
        DebugMessage.setLevel(0L);
    }

    protected void requestSample() {
        DebugMessage.setLevel(0L);
        if (this.getInstrumentPowerPolicy() == 1) {
            DebugMessage.println("requestSample(): GPS Warming up for " + this._warmupDelay + " ms");
            try {
                Thread.sleep(this._warmupDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.sync();
        DebugMessage.println("requestSample(): done");
        DebugMessage.setLevel(0L);
    }

    private void getMessage(String type, NMEAString msg, byte[] sample, long skipTimeout, long readTimeout) throws Exception {
        DebugMessage.setLevel(0L);
        int bytesRead = 0;
        DebugMessage.setLevel(0L);
        ByteUtility.fillByteArray(sample, '\u0000');
        try {
            this.skipUntil(this._fromDevice, type.getBytes(), skipTimeout, 0);
            bytesRead = this.readUntil(this._fromDevice, sample, this.getPromptString(), readTimeout);
            msg.parseByteArray(ByteUtility.concatByteArrays(type.getBytes(), sample));
            DebugMessage.println("getMessage(): looking for " + type + " got " + msg + " (" + bytesRead + "," + msg.length() + ") bytes");
            return;
        }
        catch (Exception e) {
            DebugMessage.println("getMessage() caught " + e);
            DebugMessage.setLevel(0L);
            return;
        }
    }

    protected boolean getFix(NMEAString theMessage, byte[] sample) throws Exception {
        DebugMessage.setLevel(0L);
        long now = System.currentTimeMillis();
        DebugMessage.println("getFix() - call sync()");
        this.sync();
        now = System.currentTimeMillis();
        while (System.currentTimeMillis() - now < this.getSampleTimeout()) {
            DebugMessage.println("getFix() - call getMessage()");
            this.getMessage("$GPRMC", theMessage, sample, this.getSampleTimeout(), this.getSampleTimeout());
            DebugMessage.println("getFix() - check theMessage()");
            if (theMessage != null) {
                if (!theMessage.getField(0).equals("$GPRMC") || !theMessage.getField(2).equals("A")) continue;
                DebugMessage.println("Got valid GPRMC message");
                DebugMessage.setLevel(0L);
                return true;
            }
            System.err.println("getFix() - got null message!");
        }
        DebugMessage.setLevel(0L);
        return false;
    }

    protected int readSample(byte[] sample) throws Exception {
        DebugMessage.setLevel(0L);
        boolean bytesRead = false;
        NMEAString theMessage = null;
        DebugMessage.println("readSample(): acquiring fix...");
        boolean gotValidFix = false;
        theMessage = new NMEAString(25);
        long now = System.currentTimeMillis();
        gotValidFix = this.getFix(theMessage, sample);
        if (!gotValidFix && !this._warmupDone) {
            gotValidFix = this.searchSky(this._firstFixTimeout, theMessage, sample);
            this._warmupDone = true;
            if (!gotValidFix) {
                gotValidFix = this.getFix(theMessage, sample);
            }
            if (!gotValidFix) {
                this.cyclePower(10000);
                this.initializeGPS();
                gotValidFix = this.getFix(theMessage, sample);
            }
        }
        if (gotValidFix) {
            ByteUtility.fillByteArray(sample, '\u0000');
            int i = 0;
            while (i < theMessage.length()) {
                sample[i] = theMessage.getBytes()[i];
                ++i;
            }
            return theMessage.length();
        }
        DebugMessage.println("Could not acquire fix; getting Status Info...");
        NMEAString[] status = new NMEAString[4];
        int i = 0;
        while (i < 4) {
            status[i] = new NMEAString(25);
            ++i;
        }
        this.sync();
        int i2 = 0;
        while (i2 < 3) {
            this.getMessage("$GPGSV", status[i2], sample, this.getSampleTimeout(), this.getSampleTimeout());
            ++i2;
        }
        this.sync();
        this.getMessage("$PGRMT", status[3], sample, 75000L, this.getSampleTimeout());
        String retString = new String("Could not acquire valid fix; GPS Status:");
        int j = 0;
        while (j < 4) {
            if (status[j] != null) {
                retString = retString + status[j] + "\r\n";
            }
            ++j;
        }
        int i3 = 0;
        while (i3 < retString.length()) {
            sample[i3] = retString.getBytes()[i3];
            ++i3;
        }
        DebugMessage.println("Returning status info:\n" + retString);
        DebugMessage.setLevel(0L);
        return retString.length();
    }

    protected byte[] getInstrumentMetadata() {
        String mdString = "<Garmin25GPSMetadata>\r\n";
        mdString = mdString + "FirstFixTimeout=\"" + this._firstFixTimeout + "\"\r\n";
        mdString = mdString + "WarmupDelay=\"" + this._warmupDelay + "\"\r\n";
        mdString = mdString + "GPS_BAUD=\"" + this._GPS_BAUD + "\"\r\n";
        mdString = mdString + "GPS_DATA=\"" + this._GPS_DATA + "\"\r\n";
        mdString = mdString + "GPS_STOP=\"" + this._GPS_STOP + "\"\r\n";
        mdString = mdString + "GPS_PARITY=\"" + this._GPS_PARITY + "\"\r\n";
        mdString = mdString + "</Garmin25GPSMetadata>\r\n";
        return mdString.getBytes();
    }

    public void setClock(long t) {
    }

    public int test() {
        return 0;
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(this._GPS_BAUD, this._GPS_DATA, this._GPS_PARITY, this._GPS_STOP);
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(60000L);
    }
}

