/*
 * Decompiled with CFR 0.152.
 */
package moos.devices.asimet;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.SerialPortParameters;
import moos.deployed.TimeoutException;
import moos.devices.asimet.ASIMETSensor;
import moos.devices.asimet.LWaveRadiometer;
import moos.devices.asimet.RelHumidity;
import moos.devices.asimet.SWaveRadiometer;
import moos.utils.StopWatch;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class WhoiAsimet
extends InstrumentService
implements Instrument {
    static final int MAX_RETRIES = 5;
    static final int MAX_SENSOR_TYPES = 3;
    static final int CAL_QUERY_TIMEOUT = 10000;
    static final String PROPERTY_MODULE_ADDRESS = "moduleAddress";
    static final String COMMAND_PREFIX = "#";
    static final String SAMPLE_BOTH_COMMAND = "B";
    static final String ADDRESS_ACK_COMMAND = "A";
    static final String ADDRESS_ID_COMMAND = "I";
    static final String QUERY_CALCON_COMMAND = "Q";
    static final String GET_CALIBRATION_CONSTANTS_COMMAND = "L";
    static final String OKACK_RESPONSE = "OK!";
    static final String RESPONSE_TERMINATOR = "\r\n\u0003";
    static final String RETURN_TO_KNOWN_STATE = "\r\r\r\r\r\r0";
    private ASIMETSensor[] _sensor = new ASIMETSensor[3];
    private ASIMETSensor _validSensor;

    public WhoiAsimet() throws RemoteException {
        this._sensor[0] = new SWaveRadiometer();
        this._sensor[1] = new LWaveRadiometer();
        this._sensor[2] = new RelHumidity();
    }

    protected int initInstrumentStartDelay() {
        return 4000;
    }

    protected byte[] initPromptString() {
        return "".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return RESPONSE_TERMINATOR.getBytes();
    }

    protected int initMaxSampleBytes() {
        return 512;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected int initInstrumentPowerPolicy() {
        return 2;
    }

    protected int initCommunicationPowerPolicy() {
        return 1;
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        super.loadProperties(input);
        String type = this._serviceProperties.getProperty("sensorType");
        String module = this._serviceProperties.getProperty(PROPERTY_MODULE_ADDRESS);
        int i = 0;
        while (i < 3) {
            if (this._sensor[i].getType().equals(type)) {
                this._validSensor = this._sensor[i];
                this._validSensor.setModuleAddr(module);
                break;
            }
            ++i;
        }
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        this.setSampleTimeout(3000L);
        this.managePowerWake();
        StopWatch.delay(this.getInstrumentStartDelay());
        if (!this.getAttention(5)) {
            throw new InitializeException("Instrument Failed To Respond!");
        }
    }

    protected void requestSample() throws TimeoutException, Exception {
        DebugMessage.println("Verifying Connection...");
        this.getAttention(5);
        DebugMessage.println("Requesting Sample...");
        this.write(this._toDevice, this._validSensor.mkCmd(SAMPLE_BOTH_COMMAND));
    }

    protected byte[] getInstrumentMetadata() {
        byte[] retval = new byte[1];
        if (!this.getAttention(5)) {
            DebugMessage.println("getAttention() failed - ");
        }
        try {
            DebugMessage.println("Requesting ID Info...");
            this.write(this._toDevice, this._validSensor.mkCmd(ADDRESS_ID_COMMAND));
            byte[] IDBuf = new byte[this._validSensor.getMaxIDBytes()];
            int IDBytes = this.readUntil(this._fromDevice, IDBuf, this.getPromptString(), this.getSampleTimeout());
            DebugMessage.println("Requesting Cal Info Stage 1...");
            this.write(this._toDevice, this._validSensor.mkCmd(QUERY_CALCON_COMMAND));
            this.skipUntil(this._fromDevice, OKACK_RESPONSE.getBytes(), 10000L, 0);
            this.flushInput();
            DebugMessage.println("Requesting Cal Info Stage 2...");
            this.write(this._toDevice, this._validSensor.mkCmd(GET_CALIBRATION_CONSTANTS_COMMAND));
            byte[] calBuf = new byte[this._validSensor.getMaxCalBytes()];
            int calBytes = this.readUntil(this._fromDevice, calBuf, this.getPromptString(), this.getSampleTimeout());
            String drvConfig = "";
            drvConfig = drvConfig + "\n_sampleCmd:B\n";
            drvConfig = drvConfig + "_sn:" + this._validSensor.getModuleAddr() + "\n";
            drvConfig = drvConfig + "_type:" + this._validSensor.getType() + "\n";
            retval = new byte[IDBytes + calBytes + drvConfig.length()];
            int i = 0;
            while (i < IDBytes) {
                retval[i] = IDBuf[i];
                ++i;
            }
            int i2 = 0;
            while (i2 < calBytes) {
                retval[IDBytes + i2] = calBuf[i2];
                ++i2;
            }
            int i3 = 0;
            while (i3 < drvConfig.length()) {
                retval[IDBytes + calBytes + i3] = (byte)drvConfig.charAt(i3);
                ++i3;
            }
            DebugMessage.println(this.getName() + " Returning...");
        }
        catch (TimeoutException e) {
            DebugMessage.println("Timeout collecting metadata: " + e);
        }
        catch (Exception e) {
            DebugMessage.println("IO Failure collecting metadata: " + e);
        }
        return retval;
    }

    public void setClock(long t) {
    }

    public int test() {
        return 0;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(60000L);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(9600, 8, 0, 1);
    }

    private boolean getAttention(int maxTries) {
        DebugMessage.println("getting attention...");
        if (this.getPrompt()) {
            DebugMessage.println("sanity check ok");
            return true;
        }
        DebugMessage.println("are we in menu mode?..");
        int i = 0;
        while (i < maxTries) {
            try {
                this.flushInput();
                this.writePace(this._toDevice, RETURN_TO_KNOWN_STATE.getBytes(), 400);
            }
            catch (IOException e) {
                DebugMessage.println("flushInput: " + e);
            }
            if (this.getPrompt()) {
                DebugMessage.println("sanity check ok");
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean getPrompt() {
        try {
            this.flushInput();
            this.write(this._toDevice, this._validSensor.mkCmd(ADDRESS_ACK_COMMAND));
            int s = this.skipUntil(this._fromDevice, this._validSensor.getAddressReply(), this.getSampleTimeout(), 0);
            if (s >= 0) {
                DebugMessage.println("prompt ok");
                return true;
            }
            DebugMessage.println("no prompt");
            return false;
        }
        catch (Exception e) {
            DebugMessage.println("getPrompt: " + e);
            return false;
        }
    }

    private void writePace(OutputStream ostream, byte[] src, int msDelay) throws IOException {
        byte[] temp = new byte[1];
        int i = 0;
        while (i < src.length) {
            temp[0] = src[i];
            this.write(ostream, temp);
            try {
                Thread.sleep(msDelay);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            ++i;
        }
    }
}

