/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import moos.deployed.DebugMessage;

public class SpiMaster {
    public static final String SPI_DEVICE_NAME = "/dev/spi";
    public static final String GPIO_DEVICE_NAME = "/dev/gpio";
    public static final int SPI_WORD_WIDTH_8 = 8;
    public static final int SPI_WORD_WIDTH_16 = 16;
    public static final int SPI_WORD_WIDTH_32 = 32;
    public static final int SPI_CLOCK_DIVIDER_256 = 256;
    public static final int SPI_CLOCK_DIVIDER_64 = 64;
    public static final int SPI_SLAVE_SELECT_NONE = 7;
    public static final int SPI_SLAVE_SELECT_0 = 0;
    public static final int SPI_SLAVE_SELECT_1 = 1;
    public static final int SPI_SLAVE_SELECT_2 = 2;
    public static final int SPI_SLAVE_SELECT_3 = 3;
    public static final int SPI_SLAVE_SELECT_4 = 4;
    public static final int SPI_SLAVE_SELECT_5 = 5;
    public static final int SPI_SLAVE_SELECT_GPIO_OFFSET = 4;
    public static final int SPI_SLAVE_SELECT_MASK = 7;
    public static final int SPI_USE_PORT = 0;
    public static final int SPI_USE_GPIO = 1;
    public static final int SPI_PASSTHROUGH = 0;
    public static final int SPI_LOOPBACK = 1;
    public static final int SPI_DEFAULT_PHASE = 0;
    public static final int SPI_ALT_PHASE = 1;
    public static final int SPI_DEFAULT_CLOCK = 0;
    public static final int SPI_INVERTED_CLOCK = 1;
    public static final int SPI_SET_OCE_01 = 20496;
    public static final int SPI_SET_OCE_10 = 20512;
    public static final int SPI_READ_OCE = 49152;
    private static SpiMaster cInstance = new SpiMaster();
    private static RandomAccessFile spiDevice;
    private static RandomAccessFile gpioDevice;

    public static synchronized SpiMaster getInstance() {
        if (cInstance != null) {
            return cInstance;
        }
        DebugMessage.println("SpiMaster.getInstance() no instance -- returning null");
        return null;
    }

    public void setClkDivider(int d) {
        this.writeSpi(Integer.toHexString(d) + "S");
    }

    public void setSlaveSelect(int cs) {
        cs &= 7;
        this.writeGpio(Integer.toHexString(cs <<= 4) + "=");
    }

    public int writeReadData(int dataOut) {
        try {
            spiDevice.writeBytes(Integer.toHexString(dataOut) + "=");
            String dataIn = spiDevice.readLine();
            return Integer.parseInt(dataIn, 16);
        }
        catch (FileNotFoundException f) {
            System.err.println("Cannot access: /dev/spi");
        }
        catch (IOException i) {
            System.err.println(i);
        }
        catch (NumberFormatException n) {
            System.err.println(n);
        }
        System.exit(-2);
        return -1;
    }

    public void writeSpi(String data) {
        try {
            spiDevice.writeBytes(data);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open device:  /dev/spi");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void writeGpio(String data) {
        try {
            gpioDevice.writeBytes(data);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open device:  /dev/gpio");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    static {
        try {
            spiDevice = new RandomAccessFile(SPI_DEVICE_NAME, "rw");
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open device:  /dev/spi");
        }
        try {
            gpioDevice = new RandomAccessFile(GPIO_DEVICE_NAME, "rw");
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open device:  /dev/gpio");
        }
        try {
            String cfgString = Integer.toHexString(16) + "W" + Integer.toHexString(0) + "G" + Integer.toHexString(256) + "S" + Integer.toHexString(0) + "L" + Integer.toHexString(0) + "P" + Integer.toHexString(0) + "I";
            spiDevice.writeBytes(cfgString);
            int gpioNone = 112;
            gpioDevice.writeBytes(Integer.toHexString(gpioNone) + "=");
            DebugMessage.println("SPI configured with " + cfgString + " cs=" + Integer.toHexString(gpioNone) + "=");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

