/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import moos.deployed.DebugMessage;
import moos.deployed.NodeManager;
import moos.deployed.NodeProperties;
import moos.deployed.NodeService;
import moos.deployed.Scheduler;
import moos.deployed.SiamTimer;
import moos.deployed.SleepRollCallListener;
import moos.deployed.SpiMaster;
import moos.devices.msp430.MSP430;
import org.mbari.isi.interfaces.Device;

public class SleepManager {
    private static final String PROP_PREFIX = "SleepManager.";
    private static final int DFLT_LOOKUP_RETRIES = 30;
    private static final int DFLT_ENV_RETRIES = 3;
    private static final int COUNTDOWN_ALARM_BIT = 32;
    private static final int DFLT_ROOTSRV_PORT = 7932;
    private static final int DFLT_WAKEUP_TIME = 3;
    private static final int DFLT_MIN_SLEEP_TIME = 5;
    private static final int DFLT_LOOKAHEAD_TIME = 1800;
    private static final int DFLT_POLL_TIME = 2;
    protected static int _instanceCount = 0;
    protected static SleepManager _instance = null;
    protected Thread _sleepThread = null;
    protected Thread _testThread = null;
    protected boolean _runSleepThread = true;
    protected NodeManager _nodeManager = null;
    protected NodeProperties _nodeProperties;
    protected boolean _sleepManagerEnabled = false;
    protected String _sleepString = "sleep\n";
    protected int _lookupRetries = 30;
    protected int _envRetries = 3;
    protected int _rootsrvPort = 7932;
    protected int _wakeupTime = 3;
    protected int _pollTime = 2;
    protected int _minSleepTime = 5;
    protected int _lookaheadTime = 1800;
    protected Vector _sleepRollCallList;
    protected String _envReply;
    protected String _envSubstring;
    protected boolean _debug = true;

    SleepManager() {
        if (++_instanceCount > 1) {
            System.err.println("Only ONE instance of SleepManager allowed!");
            System.exit(1);
        }
        this.debugPrint("SleepManager constructor");
        _instance = this;
        this._nodeManager = NodeManager.getInstance();
        this._nodeProperties = this._nodeManager.getNodeProperties();
        this._sleepRollCallList = new Vector();
        String enblString = this._nodeProperties.getProperty("SleepManager.enabled");
        if (enblString != null) {
            this._sleepManagerEnabled = enblString.equalsIgnoreCase("true");
        }
    }

    public static synchronized SleepManager getInstance() {
        if (_instanceCount < 1) {
            _instance = new SleepManager();
        }
        return _instance;
    }

    public void start() {
        if (this._sleepManagerEnabled) {
            this._sleepThread = new SleepThread();
            this._sleepThread.start();
        } else {
            this.debugPrint("SleepManager disabled");
        }
    }

    public final byte[] getName() {
        return this.getClass().getName().getBytes();
    }

    public void addSleepRollCallListener(SleepRollCallListener listener) {
        this._sleepRollCallList.add(listener);
    }

    protected void debugPrint(String message) {
        if (this._debug) {
            System.out.println(message);
        }
    }

    private class TestThread
    extends Thread {
        TestThread() {
            super("testThread");
            System.out.println("Test Thread running every 40 seconds");
        }

        public void run() {
            long lastTime = System.currentTimeMillis();
            while (true) {
                long now = System.currentTimeMillis();
                System.out.println("***************Test Thread: elapsed time = " + (now - lastTime));
                lastTime = now;
                try {
                    Thread.sleep(40000L);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("TestThread: " + e);
                    continue;
                }
                break;
            }
        }
    }

    private class SleepThread
    extends Thread {
        private MSP430 _env;
        private Socket _rootCmdSock = null;
        private OutputStream _rootCmdOutstream = null;
        private InputStream _rootCmdInstream = null;
        private NodeService _nodeService = null;
        private Scheduler _scheduler = null;
        private SpiMaster _spiMaster = null;
        private byte[] inbuf = new byte[256];
        DateFormat _dateFormatter = null;

        SleepThread() {
            super("sleepThread");
            this._spiMaster = SpiMaster.getInstance();
            this._dateFormatter = DateFormat.getDateTimeInstance();
            SleepManager.this.debugPrint("SleepThread constructor");
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            SleepManager.this.debugPrint("SleepThread starting, NodeManager = " + SleepManager.this._nodeManager.toString());
            try {
                this._nodeService = SleepManager.this._nodeManager.getNodeService();
                SleepManager.this.debugPrint("NodeService = " + this._nodeService.toString());
            }
            catch (Exception e) {
                System.err.println("SleepThread: can't get NodeService: " + e);
                e.printStackTrace();
                return;
            }
            try {
                this._scheduler = Scheduler.getInstance();
            }
            catch (Exception e) {
                System.err.println("SleepThread: can't get Scheduler " + e);
                e.printStackTrace();
                return;
            }
            this.getSleepManagerProperties();
            this._env = this.getEnvironmentalService();
            if (this._env == null) {
                System.err.println("SleepThread: can't get MSP430 service.  Exiting");
                return;
            }
            try {
                this._rootCmdSock = new Socket(InetAddress.getByName("localhost"), SleepManager.this._rootsrvPort);
                this._rootCmdSock.setKeepAlive(false);
                this._rootCmdSock.setSoLinger(false, 0);
                this._rootCmdSock.setTcpNoDelay(true);
                this._rootCmdOutstream = this._rootCmdSock.getOutputStream();
                this._rootCmdInstream = this._rootCmdSock.getInputStream();
            }
            catch (Exception e) {
                System.err.println("SleepThread: error creating rootCmd socket" + e);
                return;
            }
            if (this.sendEnvCmd("set amask 20\n")) ** GOTO lbl52
            System.err.println("SleepThread: can't set amask. Exiting");
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(SleepManager.this._pollTime * 1000);
                    sleepTime = this.okToSuspend();
                    if (sleepTime <= SleepManager.this._minSleepTime || (sleepTime -= SleepManager.this._wakeupTime) <= 0) continue;
                    SleepManager.this.debugPrint("Sleep Thread - going to sleep for " + sleepTime + " seconds");
                    System.out.flush();
                    if (!this.doSuspend(sleepTime)) {
                        SleepManager.this.debugPrint("SleepThread staying awake");
                    } else {
                        SleepManager.this.debugPrint("SleepThread awake:  " + this._dateFormatter.format(new Date(System.currentTimeMillis())));
                    }
                    this._spiMaster.writeSpi("10W0G100S0L0I0P");
                    SiamTimer.recalculate();
                    continue;
                }
                catch (Exception e) {
                    System.err.println("SleepThread.run(): " + e);
                    e.printStackTrace();
                }
lbl52:
                // 4 sources

                ** while (SleepManager.this._runSleepThread)
            }
lbl53:
            // 1 sources

        }

        private void getSleepManagerProperties() {
            String newSleepString = SleepManager.this._nodeProperties.getProperty("SleepManager.sleepString");
            if (newSleepString != null) {
                SleepManager.this._sleepString = newSleepString;
                if (SleepManager.this._sleepString.indexOf(10) < 0) {
                    SleepManager.this._sleepString = SleepManager.this._sleepString + "\n";
                }
            }
            SleepManager.this._rootsrvPort = SleepManager.this._nodeProperties.getIntegerProperty("SleepManager.rootsrvPort", 7932);
            SleepManager.this._lookupRetries = SleepManager.this._nodeProperties.getIntegerProperty("SleepManager.lookupRetries", 30);
            SleepManager.this._envRetries = SleepManager.this._nodeProperties.getIntegerProperty("SleepManager.environmentalRetries", 3);
            SleepManager.this._wakeupTime = SleepManager.this._nodeProperties.getIntegerProperty("SleepManager.wakeupSeconds", 3);
            SleepManager.this._pollTime = SleepManager.this._nodeProperties.getIntegerProperty("SleepManager.pollSeconds", 2);
            SleepManager.this._minSleepTime = SleepManager.this._nodeProperties.getIntegerProperty("SleepManager.minSleepSeconds", 5);
            SleepManager.this._lookaheadTime = SleepManager.this._nodeProperties.getIntegerProperty("SleepManager.schedLookaheadSeconds", 1800);
            DebugMessage.println("SleepManager sleepString = " + SleepManager.this._sleepString);
            DebugMessage.println("SleepManager wakeupTime = " + SleepManager.this._wakeupTime);
        }

        protected MSP430 getEnvironmentalService() {
            MSP430 env = null;
            int retries = 0;
            while (retries < SleepManager.this._lookupRetries) {
                env = MSP430.getInstance();
                if (env != null) {
                    return env;
                }
                SleepManager.this.debugPrint("SleepThread: no MSP430, retrying");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    System.err.println("SleepThread.getEnvironmentalService(): " + e);
                    e.printStackTrace();
                }
                ++retries;
            }
            return null;
        }

        protected boolean sendEnvCmd(String cmd) {
            int i = 0;
            while (i < SleepManager.this._envRetries) {
                try {
                    this._env.commandAndReply(cmd);
                    return true;
                }
                catch (Exception e) {
                    DebugMessage.println("sendEnvCmd: " + e);
                    ++i;
                }
            }
            return false;
        }

        protected int getEnvValue(String cmd, String expectedReply) {
            int i = 0;
            while (i < SleepManager.this._envRetries) {
                try {
                    String reply;
                    SleepManager.this._envReply = reply = this._env.commandAndReply(cmd);
                    if (reply.startsWith(expectedReply)) {
                        int intStart = expectedReply.length() + 1;
                        int intEnd = reply.indexOf(44, intStart);
                        SleepManager.this._envSubstring = reply.substring(intStart, intEnd).trim();
                        return Integer.parseInt(reply.substring(intStart, intEnd).trim(), 16);
                    }
                }
                catch (Exception e) {
                    System.err.println("getEnvValue: " + e);
                    SleepManager.this._envSubstring = SleepManager.this._envReply = "";
                }
                ++i;
            }
            return -1;
        }

        protected int getEnvAlarmValue() {
            return this.getEnvValue("get alarm\n", "$PALARM");
        }

        protected int clearAlarms(int checkClear) {
            int alarmVal = -1;
            int i = 0;
            while (i < SleepManager.this._envRetries) {
                this.sendEnvCmd("clear alarm 3f\n");
                alarmVal = this.getEnvAlarmValue();
                if ((alarmVal & checkClear) == 0) {
                    return alarmVal;
                }
                ++i;
            }
            return alarmVal;
        }

        boolean waitForReply(InputStream instream, long waitTime) throws IOException, InterruptedException {
            long startTime = System.currentTimeMillis();
            do {
                if (instream.available() > 0) {
                    return true;
                }
                Thread.sleep(100L);
            } while (System.currentTimeMillis() < startTime + waitTime);
            return false;
        }

        protected boolean doSuspend(long seconds) {
            if ((this.clearAlarms(32) & 0x20) != 0) {
                System.err.println("SleepThread: can't clear countdown alarm");
                System.err.println("Reply = \"" + SleepManager.this._envReply + "\"");
                System.err.println("Substring = \"" + SleepManager.this._envSubstring + "\"");
                return false;
            }
            if (!this.sendEnvCmd("set countdown " + seconds + "\n")) {
                System.err.println("SleepThread: can't set countdown timer");
                return false;
            }
            try {
                while (this._rootCmdInstream.available() > 0) {
                    this._rootCmdInstream.read(this.inbuf);
                }
            }
            catch (IOException ioe) {
                System.err.println("SleepThread exception in reading socket: " + ioe);
            }
            try {
                this._rootCmdOutstream.write(SleepManager.this._sleepString.getBytes());
            }
            catch (IOException ioe) {
                System.err.println("SleepThread.doSuspend: IOException on socket write" + ioe);
                System.err.println(ioe.getMessage());
            }
            catch (Exception e) {
                System.err.println("SleepThread.doSuspend: " + e);
            }
            try {
                this.waitForReply(this._rootCmdInstream, 2000L);
                while (this._rootCmdInstream.available() > 0) {
                    int nChars = this._rootCmdInstream.read(this.inbuf);
                    DebugMessage.println("SleepManager rootcmd response: " + new String(this.inbuf, 0, nChars));
                }
            }
            catch (Exception e) {
                System.err.println("SleepThread exception in reading socket: " + e);
            }
            return true;
        }

        private long doSleepRollCall() {
            Enumeration e = SleepManager.this._sleepRollCallList.elements();
            long wakeupTime = Long.MAX_VALUE;
            while (e.hasMoreElements()) {
                long thisTime = ((SleepRollCallListener)e.nextElement()).okToSleep();
                if (thisTime <= 0L) {
                    return 0L;
                }
                if (thisTime >= wakeupTime) continue;
                wakeupTime = thisTime;
            }
            return wakeupTime;
        }

        private int okToSuspend() {
            int rtn;
            Device[] devices = null;
            int status = 0;
            String name = null;
            long rollCallTime = this.doSleepRollCall();
            if (rollCallTime <= 0L) {
                return 0;
            }
            devices = this._nodeService.getDevices();
            int i = 0;
            while (i < devices.length) {
                try {
                    status = devices[i].getStatus();
                    name = new String(devices[i].getName());
                    if (status == 5) {
                        return 0;
                    }
                    if (status == 2) {
                        return 0;
                    }
                }
                catch (Exception e) {
                    System.err.println("SleepThread.okToSuspend(): " + e);
                    e.printStackTrace();
                }
                ++i;
            }
            long sleepTime = this._scheduler.getNextScheduledJob(SleepManager.this._lookaheadTime);
            if (rollCallTime < sleepTime) {
                sleepTime = rollCallTime;
            }
            if ((rtn = (int)(sleepTime / 1000L)) > SleepManager.this._lookaheadTime) {
                rtn = SleepManager.this._lookaheadTime;
            }
            return rtn;
        }
    }
}

