/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import moos.deployed.DebugMessage;
import moos.deployed.DpaBoard;
import moos.deployed.PowerPort;
import moos.deployed.RangeException;

public class SidearmPowerPort
implements PowerPort {
    private DpaBoard.DpaChannel _dpaChannel = null;
    private int _currentLimit = 0;
    private String _name = null;

    public SidearmPowerPort(String name, DpaBoard.DpaChannel c) {
        this._name = name;
        this._dpaChannel = c;
    }

    public SidearmPowerPort(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setDpaChannel(DpaBoard.DpaChannel c) {
        DebugMessage.println("SidearmPowerPort.initialize()");
        this._dpaChannel = c;
    }

    public void initialize() {
        DebugMessage.println("SidearmPowerPort.initialize()");
        if (this._dpaChannel != null) {
            DebugMessage.println("Driver: " + this.getName() + " initializing channel " + this._dpaChannel);
            DebugMessage.println("Connecting Comms Ground");
            this._dpaChannel._relayReg.connectCommunicationsGround();
            DebugMessage.println("Connecting Instrument Power");
            this._dpaChannel._relayReg.connectInstrumentPower();
            this._dpaChannel._relayReg.write();
        } else {
            DebugMessage.println("Driver: " + this.getName() + " startup(): DPA channel is NULL");
        }
        DebugMessage.println("startup(): Done with DPA initialization");
    }

    public int getCurrentLimit() {
        return this._currentLimit;
    }

    public int getVoltageLevel() {
        if (this._dpaChannel != null) {
            return this._dpaChannel._channelAdc.getVoltage();
        }
        DebugMessage.println("getVoltageLevel(): null _dpaChannel in " + this.getName());
        return 0;
    }

    public int getRelayReg() {
        return this._dpaChannel._relayReg.read();
    }

    public int getChannelControlReg() {
        return this._dpaChannel._channelCtrlReg.read();
    }

    public void getPowerState() {
        int rr = this.getRelayReg();
        int cr = this.getChannelControlReg();
        DebugMessage.println("Power Relay: " + ((rr & 1) != 0 ? "ISO" : "CON") + "\nInstrument Power: " + ((cr & 1) != 0 ? "ON" : "OFF"));
    }

    public void getCommsState() {
        int rr = this.getRelayReg();
        int cr = this.getChannelControlReg();
        DebugMessage.println("Comms Relay: " + ((rr & 2) != 0 ? "ISO" : "CON") + "\nRS485 Terminators: " + ((rr & 4) != 0 ? "CON" : "ISO") + "\nSerial Direction: " + ((cr & 0x20) != 0 ? "HI" : "LOW") + "\nComm Fast: " + ((cr & 0x10) != 0 ? "FAST" : "SRL") + "\nComm Mode: " + ((cr & 8) != 0 ? "485" : "232") + "\nDuplex: " + ((cr & 4) != 0 ? "HALF" : "FULL") + "\nComms Power: " + ((cr & 2) != 0 ? "ON" : "OFF"));
    }

    public int getCurrentLevel() {
        if (this._dpaChannel != null) {
            return this._dpaChannel._channelAdc.getCurrent();
        }
        DebugMessage.println("getCurrentLevel(): null _dpaChannel in " + this.getName());
        return 0;
    }

    public void setCurrentLimit(int currentLimit) throws RangeException {
        if (this._dpaChannel != null) {
            DebugMessage.println("SidearmPowerPort.setCurrentLimit()");
            if (currentLimit < 0) {
                throw new RangeException("current limit must be positive");
            }
            this._currentLimit = currentLimit;
            this._dpaChannel.setCurrentLimit(this._currentLimit);
        } else {
            this._currentLimit = currentLimit;
            DebugMessage.println("setCurrentLimit() null _dpaChannel in " + this.getName());
        }
    }

    public void enableCommunications() {
        DebugMessage.println("SidearmPowerPort.enableCommunications()");
        this.commPowerOn();
        this.commTxHiPower();
    }

    public void disableCommunications() {
        DebugMessage.println("SidearmPowerPort.disableCommunications()");
        this.commPowerOff();
        this.commTxLoPower();
    }

    public void connectPower() {
        DebugMessage.println("SidearmPowerPort.connectPower()");
        this.instrumentPowerOn();
    }

    public void disconnectPower() {
        DebugMessage.println("SidearmPowerPort.disconnectPower()");
        this.instrumentPowerOff();
    }

    public void isolatePort() {
        DebugMessage.println("SidearmPowerPort.isolatePort()");
        this.isolateCommGround();
        this.isolateInstrumentPower();
    }

    protected void instrumentPowerOn() {
        if (this._dpaChannel != null) {
            this._dpaChannel._channelCtrlReg.setInstrumentPowerOn();
            this._dpaChannel._channelCtrlReg.write();
        } else {
            DebugMessage.println("instrumentPowerOn() null _dpaChannel in " + this.getName());
        }
    }

    protected void instrumentPowerOff() {
        if (this._dpaChannel != null) {
            this._dpaChannel._channelCtrlReg.setInstrumentPowerOff();
            this._dpaChannel._channelCtrlReg.write();
        } else {
            DebugMessage.println("instrumentPowerOff() null _dpaChannel in " + this.getName());
        }
    }

    protected void commPowerOn() {
        if (this._dpaChannel != null) {
            this._dpaChannel._channelCtrlReg.setCommPowerOn();
            this._dpaChannel._channelCtrlReg.write();
        } else {
            DebugMessage.println("commPowerOn() null _dpaChannel in " + this.getName());
        }
    }

    protected void commPowerOff() {
        if (this._dpaChannel != null) {
            this._dpaChannel._channelCtrlReg.setCommPowerOff();
            this._dpaChannel._channelCtrlReg.write();
        } else {
            DebugMessage.println("commPowerOff() null _dpaChannel in " + this.getName());
        }
    }

    protected void commTxHiPower() {
        if (this._dpaChannel != null) {
            this._dpaChannel._channelCtrlReg.setTxHiPower();
            this._dpaChannel._channelCtrlReg.write();
        } else {
            DebugMessage.println("commTxHiPower() null _dpaChannel in " + this.getName());
        }
    }

    protected void commTxLoPower() {
        if (this._dpaChannel != null) {
            this._dpaChannel._channelCtrlReg.setTxLoPower();
            this._dpaChannel._channelCtrlReg.write();
        } else {
            DebugMessage.println("commTxLoPower() null _dpaChannel in " + this.getName());
        }
    }

    protected void isolateInstrumentPower() {
        if (this._dpaChannel != null) {
            this._dpaChannel._relayReg.isolateInstrumentPower();
            this._dpaChannel._relayReg.write();
        } else {
            DebugMessage.println("isolateInstrumentPower() null _dpaChannel in " + this.getName());
        }
    }

    protected void connectInstrumentPower() {
        if (this._dpaChannel != null) {
            this._dpaChannel._relayReg.connectInstrumentPower();
            this._dpaChannel._relayReg.write();
        } else {
            DebugMessage.println("connectInstrumentPower() null _dpaChannel in " + this.getName());
        }
    }

    protected void isolateCommGround() {
        if (this._dpaChannel != null) {
            this._dpaChannel._relayReg.isolateCommunicationsGround();
            this._dpaChannel._relayReg.write();
        } else {
            DebugMessage.println("isolateCommGround() null _dpaChannel in " + this.getName());
        }
    }

    protected void connectCommGround() {
        if (this._dpaChannel != null) {
            this._dpaChannel._relayReg.connectCommunicationsGround();
            this._dpaChannel._relayReg.write();
        } else {
            DebugMessage.println("connectCommGround() null _dpaChannel in " + this.getName());
        }
    }
}

