/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import moos.deployed.SiamTimerTask;
import moos.deployed.TaskQueue;
import moos.deployed.TimerThread;

public class SiamTimer {
    private TaskQueue queue = new TaskQueue();
    private TimerThread thread = new TimerThread(this.queue);
    private Object threadReaper = new Object(){

        protected void finalize() throws Throwable {
            TaskQueue taskQueue = SiamTimer.this.queue;
            synchronized (taskQueue) {
                ((SiamTimer)SiamTimer.this).thread.newTasksMayBeScheduled = false;
                SiamTimer.this.queue.notify();
            }
        }
    };
    private static Vector _allTimers = new Vector();

    public SiamTimer() {
        Vector vector = _allTimers;
        synchronized (vector) {
            _allTimers.addElement(this);
        }
        this.thread.start();
    }

    public SiamTimer(boolean isDaemon) {
        this.thread.setDaemon(isDaemon);
        this.thread.start();
    }

    public void schedule(SiamTimerTask task, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(task, System.currentTimeMillis() + delay, 0L);
    }

    public void schedule(SiamTimerTask task, Date time) {
        this.sched(task, time.getTime(), 0L);
    }

    public void schedule(SiamTimerTask task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, System.currentTimeMillis() + delay, -period);
    }

    public void schedule(SiamTimerTask task, Date firstTime, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, firstTime.getTime(), -period);
    }

    public void scheduleAtFixedRate(SiamTimerTask task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, System.currentTimeMillis() + delay, period);
    }

    public void scheduleAtFixedRate(SiamTimerTask task, Date firstTime, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, firstTime.getTime(), period);
    }

    private void sched(SiamTimerTask task, long time, long period) {
        if (time < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (!this.thread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object = task.lock;
            synchronized (object) {
                if (task.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                task.nextExecutionTime = time;
                task.period = period;
                task.state = 1;
            }
            this.queue.add(task);
            if (this.queue.getMin() == task) {
                this.queue.notify();
            }
        }
    }

    public void cancel() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.thread.newTasksMayBeScheduled = false;
            this.queue.clear();
            this.queue.notify();
        }
        Vector vector = _allTimers;
        synchronized (vector) {
            _allTimers.removeElement(this);
        }
    }

    public void forceNotify() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            SiamTimerTask task = this.queue.getMin();
            if (task != null) {
                Object object = task.lock;
                synchronized (object) {
                    if (task.period != 0L || task.state != 2) {
                        this.queue.notify();
                    }
                }
            }
        }
    }

    public static void recalculate() {
        Vector vector = _allTimers;
        synchronized (vector) {
            Enumeration e = _allTimers.elements();
            while (e.hasMoreElements()) {
                SiamTimer t = (SiamTimer)e.nextElement();
                TaskQueue taskQueue = t.queue;
                synchronized (taskQueue) {
                    if (t.thread.newTasksMayBeScheduled) {
                        t.queue.notify();
                    } else {
                        _allTimers.removeElement(t);
                    }
                }
            }
        }
    }
}

