/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import moos.deployed.DebugMessage;
import moos.deployed.SiamProperties;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class ServiceProperties
extends SiamProperties {
    public static final String DEVICEID_KEY = "isiID";
    public static final String DEVICEPOWERPOLICY_KEY = "powerPolicy";
    public static final String DEVICECOMMSPOLICY_KEY = "commsPolicy";
    public static final String REGISTRYNAME_KEY = "registryName";
    public static final String SERVICENAME_KEY = "serviceName";
    public static final String SAMPLESCHEDULE_KEY = "sampleSchedule";
    public static final String SAMPLETIMEOUT_KEY = "sampleTimeout";
    public static final String MAXSAMPLETRIES_KEY = "sampleRetries";
    public static final String CURRENTLIMIT_KEY = "currentLimit";
    public static final String MAXSKIPBYTES_KEY = "skipBytes";
    public static final String PROMPTSTRING_KEY = "promptString";
    public static final String SAMPLETERMINATOR_KEY = "sampleTerminator";
    public static final String STARTDELAY_KEY = "startDelay";
    public static final String MAXSAMPLEBYTES_KEY = "maxSampleBytes";
    public static final String PREEMPTION_TIME_KEY = "preemptionTime";
    public static final String TIME_SYNC_KEY = "timeSynchronization";
    public static final String ACQUIRE_PARAMS_KEY = "acquireParams";
    public static final String SAMPLES_PER_PKT_KEY = "samplesPerPacket";
    public static final String AVERAGE_COUNT_KEY = "averageCount";
    public static final String SENSOR_TYPE_KEY = "sensorType";
    public static final String RETRO_SAVE_KEY = "retroSave";
    public static final String POWER_NEVER_MNEM = "never";
    public static final String POWER_WHEN_SAMPLING_MNEM = "sampling";
    public static final String POWER_ALWAYS_MNEM = "always";

    public long getDeviceID() throws MissingPropertyException, InvalidPropertyException {
        String value = this.getProperty(DEVICEID_KEY);
        if (value == null) {
            throw new MissingPropertyException(DEVICEID_KEY);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException("deviceID:Expected 64-bit integer");
        }
    }

    public ScheduleSpecifier getSampleSchedule() throws MissingPropertyException, InvalidPropertyException {
        ScheduleSpecifier _sampleSchedule;
        String value = this.getProperty(SAMPLESCHEDULE_KEY);
        if (value == null) {
            throw new MissingPropertyException("sampleSchedule not found; using default");
        }
        DebugMessage.println("scheduleString: " + value);
        try {
            Long interval = Long.decode(value);
            _sampleSchedule = new ScheduleSpecifier(interval * 1000L);
        }
        catch (NumberFormatException e) {
            DebugMessage.println("sampleSchedule:NumberFormatException: " + value);
            try {
                _sampleSchedule = new ScheduleSpecifier(value);
            }
            catch (ScheduleParseException e2) {
                throw new InvalidPropertyException("sampleSchedule: Invalid schedule: " + value);
            }
        }
        catch (ScheduleParseException e) {
            throw new InvalidPropertyException("sampleSchedule:ScheduleParseException: " + value);
        }
        return _sampleSchedule;
    }

    public int getSampleRetries() throws MissingPropertyException, InvalidPropertyException {
        String value = this.getProperty(MAXSAMPLETRIES_KEY);
        if (value == null) {
            throw new MissingPropertyException("sampleRetries not found; using default");
        }
        try {
            int retval = Integer.parseInt(value);
            if (retval < 0) {
                throw new InvalidPropertyException("maxSampleTries: must be > 0 (" + retval + ")");
            }
            return retval;
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException("maxSampleTries: Expected integer (" + value + ")");
        }
    }

    public int getCurrentLimit() throws MissingPropertyException, InvalidPropertyException {
        String value = this.getProperty(CURRENTLIMIT_KEY);
        if (value == null) {
            throw new MissingPropertyException("currentLimit not found; using default");
        }
        try {
            int retval = Integer.parseInt(value);
            if (retval < 0 || retval > 12000) {
                throw new InvalidPropertyException("currentLimit: must be 12000<n<0 (" + retval + ")");
            }
            return retval;
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException("currentLimit: Expected integer (" + value + ")");
        }
    }

    public int getMaxSkipBytes() throws MissingPropertyException, InvalidPropertyException {
        String value = this.getProperty(MAXSKIPBYTES_KEY);
        if (value == null) {
            throw new MissingPropertyException("maxSkipBytes not found; using default");
        }
        try {
            int retval = Integer.parseInt(value);
            if (retval < 0) {
                throw new InvalidPropertyException("maxSkipBytes: must be n>0 (" + retval + ")");
            }
            return retval;
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException("maxSkipBytes: Expected integer (" + value + ")");
        }
    }

    public byte[] getPromptString() throws MissingPropertyException, InvalidPropertyException {
        String value = this.getProperty(PROMPTSTRING_KEY);
        if (value == null) {
            throw new MissingPropertyException("promptString not found; using default");
        }
        byte[] retval = this.unescapeString(value).getBytes();
        return retval;
    }

    public byte[] getSampleTerminator() throws MissingPropertyException, InvalidPropertyException {
        String value = this.getProperty(SAMPLETERMINATOR_KEY);
        if (value == null) {
            throw new MissingPropertyException("sampleTerminator not found; using default");
        }
        byte[] retval = this.unescapeString(value).getBytes();
        return retval;
    }

    public int getStartDelay() throws MissingPropertyException, InvalidPropertyException {
        String value = this.getProperty(STARTDELAY_KEY);
        if (value == null) {
            throw new MissingPropertyException("startDelay not found; using default");
        }
        try {
            int retval = Integer.parseInt(value);
            if (retval < 0) {
                throw new InvalidPropertyException("startDelay: must be n>0 (" + retval + ")");
            }
            return retval;
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException("startDelay:Expected integer (" + value + ")");
        }
    }

    public int getMaxSampleBytes() throws MissingPropertyException, InvalidPropertyException {
        String value = this.getProperty(MAXSAMPLEBYTES_KEY);
        if (value == null) {
            throw new MissingPropertyException("maxSampleBytes not found; using default");
        }
        try {
            int retval = Integer.parseInt(value);
            if (retval < 0) {
                throw new InvalidPropertyException("maxSampleBytes: must be n>0 (" + retval + ")");
            }
            return retval;
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException("maxSampleBytes: Expected integer (" + value + ")");
        }
    }

    public String unescapeString(String s) {
        int escChar = 0;
        byte[] retBytes = new byte[s.length()];
        int retIndex = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                if (s.substring(i).length() <= 1) break;
                switch ((byte)s.charAt(i + 1)) {
                    case 114: {
                        escChar = 13;
                        ++i;
                        break;
                    }
                    case 110: {
                        escChar = 10;
                        ++i;
                        break;
                    }
                    case 48: {
                        escChar = 0;
                        ++i;
                        break;
                    }
                    case 92: {
                        escChar = 92;
                        ++i;
                        break;
                    }
                    case 120: {
                        try {
                            escChar = (byte)Integer.parseInt(s.substring(i + 2, i + 4), 16);
                            i += 3;
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new NumberFormatException("unescapeString: Invalid escape sequence");
                        }
                    }
                    case 116: {
                        escChar = 9;
                        ++i;
                        break;
                    }
                    default: {
                        retBytes[retIndex++] = 92;
                        escChar = (byte)s.charAt(++i);
                    }
                }
                retBytes[retIndex++] = escChar;
            } else {
                retBytes[retIndex++] = (byte)s.charAt(i);
            }
            ++i;
        }
        byte[] foo = new byte[retIndex];
        int i2 = 0;
        while (i2 < retIndex) {
            foo[i2] = retBytes[i2];
            ++i2;
        }
        return new String(foo);
    }

    public int getDevicePowerPolicy() throws MissingPropertyException, InvalidPropertyException {
        return this.getPowerPolicy(DEVICEPOWERPOLICY_KEY);
    }

    public int getCommsPowerPolicy() throws MissingPropertyException, InvalidPropertyException {
        return this.getPowerPolicy(DEVICECOMMSPOLICY_KEY);
    }

    protected int getPowerPolicy(String key) throws MissingPropertyException, InvalidPropertyException {
        String value = this.getProperty(key);
        if (value == null) {
            throw new MissingPropertyException(key);
        }
        if (value.equals(POWER_NEVER_MNEM)) {
            return 0;
        }
        if (value.equals(POWER_WHEN_SAMPLING_MNEM)) {
            return 1;
        }
        if (value.equals(POWER_ALWAYS_MNEM)) {
            return 2;
        }
        throw new InvalidPropertyException("Valid values: never, sampling, always");
    }

    public String getRegistryName() throws MissingPropertyException, InvalidPropertyException {
        return this.getProperty(REGISTRYNAME_KEY);
    }

    public String getServiceName() {
        return this.getProperty(SERVICENAME_KEY);
    }
}

