/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moos.deployed.InstrumentConsole;
import moos.deployed.InstrumentPort;
import moos.deployed.InstrumentPortInputStream;
import moos.deployed.InstrumentPortOutputStream;
import moos.deployed.PowerPort;
import moos.deployed.RangeException;
import moos.deployed.SerialPortParameters;
import org.mbari.isi.interfaces.InitializeException;

public class SerialInstrumentPort
implements InstrumentPort {
    protected SerialPort _serialPort = null;
    protected PowerPort _powerPort = null;
    private boolean _instrumentPortSuspeneded = false;
    private InstrumentPortInputStream _fromInstrument = null;
    private InstrumentPortOutputStream _toInstrument = null;

    public SerialInstrumentPort(SerialPort serial, PowerPort power) {
        this._serialPort = serial;
        this._powerPort = power;
    }

    public void initialize() throws InitializeException {
        try {
            this._fromInstrument = new InstrumentPortInputStream(this, this._serialPort.getInputStream());
        }
        catch (Exception e) {
            throw new InitializeException("getInputStream() failure: " + e);
        }
        try {
            this._toInstrument = new InstrumentPortOutputStream(this, this._serialPort.getOutputStream());
        }
        catch (Exception e) {
            throw new InitializeException("getOutputStream() failure: " + e);
        }
        if (this._powerPort == null) {
            throw new InitializeException("PowerPort is null");
        }
        this._powerPort.initialize();
    }

    public void resume() {
        this._instrumentPortSuspeneded = false;
    }

    public void suspend() {
        this._instrumentPortSuspeneded = true;
    }

    public void shutDown() {
        this.disconnectPower();
        this.disableCommunications();
        this.isolatePort();
        this._serialPort.close();
    }

    public boolean isSuspended() {
        return this._instrumentPortSuspeneded;
    }

    public InputStream getInputStream() throws IOException {
        if (this._fromInstrument == null) {
            throw new IOException("InputStream is null");
        }
        return this._fromInstrument;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this._toInstrument == null) {
            throw new IOException("OutputStream is null");
        }
        return this._toInstrument;
    }

    public InstrumentConsole getInstrumentConsole() throws IOException {
        return new InstrumentConsole(this, this._serialPort.getInputStream(), this._serialPort.getOutputStream());
    }

    public String getCommPortName() {
        return this._serialPort.getName();
    }

    public void enableCommunications() {
        this._powerPort.enableCommunications();
    }

    public void disableCommunications() {
        this._powerPort.disableCommunications();
    }

    public void connectPower() {
        this._powerPort.connectPower();
    }

    public void disconnectPower() {
        this._powerPort.disconnectPower();
    }

    public void setCurrentLimit(int currentLimit) throws RangeException {
        this._powerPort.setCurrentLimit(currentLimit);
    }

    public int getCurrentLimit() {
        return this._powerPort.getCurrentLimit();
    }

    public int getVoltageLevel() {
        return this._powerPort.getVoltageLevel();
    }

    public int getCurrentLevel() {
        return this._powerPort.getCurrentLevel();
    }

    public void isolatePort() {
        this._powerPort.isolatePort();
    }

    public void setSerialPortParams(SerialPortParameters params) throws IOException, UnsupportedCommOperationException {
        this._serialPort.setSerialPortParams(params.getBaud(), params.getDataBits(), params.getStopBits(), params.getParity());
    }

    public SerialPortParameters getSerialPortParams() throws IOException, UnsupportedCommOperationException {
        return new SerialPortParameters(this._serialPort.getBaudRate(), this._serialPort.getDataBits(), this._serialPort.getParity(), this._serialPort.getStopBits());
    }

    public boolean isCTS() {
        return this._serialPort.isCTS();
    }

    public void setRTS(boolean state) {
        this._serialPort.setRTS(state);
    }

    public void sendBreak(int duration) {
        this._serialPort.sendBreak(duration);
    }
}

