/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import moos.deployed.RangeException;
import org.mbari.isi.interfaces.SequenceGenerator;

public class SequenceNumber
implements SequenceGenerator {
    long _current;
    long _greatest;
    long _least;

    public SequenceNumber(long least, long greatest, long start) throws RangeException {
        this.initialize(least, greatest, start);
    }

    public synchronized long getNext() {
        long retval = this._current;
        this._current = this._current == this._greatest ? this._least : ++this._current;
        return retval;
    }

    public synchronized long getLeast() {
        return this._least;
    }

    public synchronized long getGreatest() {
        return this._greatest;
    }

    public synchronized void initialize(long least, long greatest, long current) throws RangeException {
        if (least > greatest) {
            this._least = greatest;
            this._greatest = least;
        } else {
            this._least = least;
            this._greatest = greatest;
        }
        if (current > this._greatest || current < least) {
            throw new RangeException("setSequenceRange: Invalid current value: " + current);
        }
        this._current = current;
    }

    public synchronized void reset() {
        this._current = this._least;
    }

    public synchronized long peek(long offset, boolean wrap) {
        long retval = 0L;
        long span = this._greatest - this._least;
        if (span < 0L) {
            System.err.println("peek: detected overflow(g-l): span=" + span);
        }
        if (wrap && offset > span) {
            offset %= span;
        }
        if (offset == 0L) {
            retval = this._current;
        } else if (offset > 0L) {
            span = this._greatest - this._current;
            if (span < 0L) {
                System.err.println("peek: detected overflow(g-c): span=" + span);
            }
            retval = span >= offset ? this._current + offset : (wrap ? this._least + (offset - span) : this._greatest);
        } else {
            span = this._current - this._least;
            if (span < 0L) {
                System.err.println("peek: detected overflow(c-l): span=" + span);
            }
            retval = span >= -offset ? this._current + offset : (wrap ? this._greatest + (offset + span) : this._least);
        }
        return retval;
    }

    public static void main(String[] args) {
        try {
            long init = args.length > 0 ? Long.parseLong(args[0]) : 0L;
            long min = 0L;
            long max = Long.MAX_VALUE;
            System.out.println("init(" + min + "," + max + "," + init + ")");
            SequenceNumber sn = new SequenceNumber(min, max, init);
            System.out.println("current:" + sn.peek(0L, false));
            sn.getNext();
            System.out.println("getNext()");
            System.out.println("current:" + sn.peek(0L, false));
            sn.getNext();
            System.out.println("getNext()");
            System.out.println("current:" + sn.peek(0L, false));
            System.out.println("peek(-3,false):" + sn.peek(-3L, false));
            System.out.println("peek(-2,false):" + sn.peek(-2L, false));
            System.out.println("peek(-1,false):" + sn.peek(-1L, false));
            System.out.println("peek(0,false):" + sn.peek(0L, false));
            System.out.println("peek(1,false):" + sn.peek(1L, false));
            System.out.println("peek(2,false):" + sn.peek(2L, false));
            System.out.println("peek(3,false):" + sn.peek(3L, false));
            sn.initialize(min, max, 5L);
            System.out.println("init(" + min + "," + max + ",5)");
            System.out.println("current:" + sn.peek(0L, false));
            System.out.println("peek(3,true):" + sn.peek(3L, true));
            System.out.println("peek(-1,true):" + sn.peek(-1L, true));
            System.out.println("peek(-9,true):" + sn.peek(-9L, true));
            System.out.println("peek(MAXLONG,true):" + sn.peek(Long.MAX_VALUE, true));
            init = max - 2L;
            sn.initialize(min, max, init);
            System.out.println("init(" + min + "," + max + "," + init + ")");
            System.out.println("current:" + sn.peek(0L, false));
            System.out.println("peek(3,true):" + sn.peek(3L, true));
            System.out.println("peek(-1,true):" + sn.peek(-1L, true));
            System.out.println("peek(-9,true):" + sn.peek(-9L, true));
            System.out.println("peek(MAXLONG,true):" + sn.peek(Long.MAX_VALUE, true));
            sn.reset();
            System.out.println("reset()");
            System.out.println("current:" + sn.peek(0L, false));
            try {
                init = 12L;
                min = 3L;
                max = 8L;
                System.out.println("init(" + min + "," + max + "," + init + ")");
                sn.initialize(min, max, init);
                System.err.println("Range Exception Test - FAILED");
            }
            catch (RangeException e) {
                System.err.println("Range Exception Test - PASS");
            }
            System.out.println("");
            System.out.println("MAXLONG=9223372036854775807");
            System.out.println("MINLONG=-9223372036854775808");
            System.out.println("MAXLONG+1=-9223372036854775808");
            System.out.println("MAXLONG+2=-9223372036854775807");
            System.out.println("MAXLONG+MAXLONG=-2");
            System.out.println("MINLONG+MINLONG=0");
            System.out.println("MINLONG-1=9223372036854775807");
            System.out.println("MINLONG-2=9223372036854775806");
            System.out.println("MINLONG-MINLONG=0");
            System.out.println("MAXLONG+MINLONG=-1");
            System.out.println("MAXLONG-MINLONG=-1");
            System.out.println("MINLONG-MAXLONG=1");
        }
        catch (RangeException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (NumberFormatException e) {
            System.err.println(e);
            System.exit(1);
        }
    }
}

