/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import moos.deployed.DebugMessage;
import moos.deployed.EventManager;
import moos.deployed.NodeManager;
import moos.deployed.NodeService;
import moos.deployed.Scheduler;
import moos.deployed.SchedulerJobEntry;
import moos.deployed.ServiceEvent;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.SensorDataPacket;

public class SchedulerJob {
    String _jobFile = null;
    Vector _jobEntries = new Vector(10);

    public SchedulerJob() {
    }

    public SchedulerJob(String jobFile) {
        this._jobFile = jobFile;
    }

    public String getJobFile() {
        return this._jobFile;
    }

    public void setJobFile(String jobFile) {
        this._jobFile = jobFile;
    }

    /*
     * Loose catch block
     */
    public void parse() {
        block17: {
            BufferedReader br = null;
            String jobPath = null;
            if (this._jobFile != null) {
                jobPath = Scheduler.getSchedulePath() + "/" + this._jobFile;
                try {
                    br = new BufferedReader(new FileReader(jobPath));
                }
                catch (FileNotFoundException e) {
                    System.out.println("Could not find file: " + jobPath);
                }
            }
            int lineNumber = 1;
            String line = br.readLine();
            while (line != null) {
                DebugMessage.println("SchedulerJob.parse: parsing " + line);
                line.trim();
                if (line.indexOf("#") >= 0) {
                    line = line.substring(0, line.indexOf("#"));
                }
                if (line.length() >= 3) {
                    SchedulerJobEntry e = new SchedulerJobEntry();
                    this._jobEntries.add(e.parse(line));
                } else {
                    DebugMessage.println("hmmm...Looks like a comment " + line.length());
                }
                line = br.readLine();
            }
            Object var7_9 = null;
            try {
                br.close();
            }
            catch (IOException e2) {
                System.err.println("IOException in SchedulerJob.parse(): " + e2);
            }
            break block17;
            {
                catch (IOException e) {
                    System.out.println("IOException in SchedulerJob.parse(): " + e);
                    Object var7_10 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        System.err.println("IOException in SchedulerJob.parse(): " + e2);
                    }
                    break block17;
                }
                catch (ScheduleParseException e) {
                    System.out.println("ScheduleParseException at line " + lineNumber + ": " + e);
                    Object var7_11 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        System.err.println("IOException in SchedulerJob.parse(): " + e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                try {
                    br.close();
                }
                catch (IOException e2) {
                    System.err.println("IOException in SchedulerJob.parse(): " + e2);
                }
                throw throwable;
            }
        }
    }

    public void execute() {
        Enumeration e = this._jobEntries.elements();
        while (e.hasMoreElements()) {
            Instrument instrument;
            SchedulerJobEntry entry;
            block9: {
                entry = (SchedulerJobEntry)e.nextElement();
                instrument = null;
                try {
                    NodeService nodeService = NodeManager.getInstance().getNodeService();
                    Device device = nodeService.getDevice(entry.getLongServiceID());
                    if (device instanceof Instrument) {
                        instrument = (Instrument)device;
                        break block9;
                    }
                    System.out.println("Could not get instrument service");
                    return;
                }
                catch (DeviceNotFound e1) {
                    System.err.println(e1);
                    ServiceEvent se = new ServiceEvent(this, 1, 2, (int)entry.getLongServiceID());
                    EventManager.getInstance().postEvent(se);
                    return;
                }
            }
            try {
                Method m = instrument.getClass().getMethod(entry.getServiceRequest(), null);
                Object obj = m.invoke((Object)instrument, null);
                if (obj instanceof SensorDataPacket) {
                    System.out.println(((SensorDataPacket)obj).toString());
                    continue;
                }
                System.err.println("Returned object is not a SensorDataPacket");
            }
            catch (NoSuchMethodException e2) {
                System.out.println(e2);
            }
            catch (IllegalAccessException e3) {
                System.out.println(e3);
            }
            catch (InvocationTargetException e4) {
                System.out.println("ID " + entry.getLongServiceID() + "." + entry.getServiceRequest() + " threw exception:");
                System.out.println(e4 + "\nException:" + e4.getTargetException());
            }
        }
    }

    public static String getAutoJobName(long serviceID) {
        return serviceID + "auto.job";
    }

    public static String createDefaultJobFile(long serviceID, String serviceMethod) {
        String schedulePath = Scheduler.getSchedulePath();
        String jobName = SchedulerJob.getAutoJobName(serviceID);
        try {
            FileOutputStream fos = new FileOutputStream(schedulePath + "/" + jobName, true);
            fos.close();
            fos = new FileOutputStream(schedulePath + "/" + jobName, false);
            String hdr = "# Auto-Generated job file for service " + serviceID + "\n";
            hdr = hdr + "# Do not edit\n\n";
            hdr = hdr + "# Request data from service " + serviceID + "\n";
            fos.write(hdr.getBytes());
            String line = serviceID + " " + serviceMethod + " nowait\n";
            fos.write(line.getBytes());
            fos.close();
            return jobName;
        }
        catch (FileNotFoundException e) {
            System.err.println("FileNotFoundException: Could not open " + schedulePath + jobName + "\n" + e);
            return null;
        }
        catch (SecurityException s) {
            System.err.println("SecurityException: Could not open " + schedulePath + jobName + "\n" + s);
            return null;
        }
        catch (IOException i) {
            System.err.println("IOException: Could not write to " + schedulePath + jobName + "\n" + i);
            return null;
        }
    }
}

