/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import moos.deployed.DebugMessage;
import moos.deployed.EventManager;
import moos.deployed.NodeManager;
import moos.deployed.NodeService;
import moos.deployed.Schedule;
import moos.deployed.ScheduleEntry;
import moos.deployed.SchedulerJob;
import moos.deployed.ServiceEvent;
import moos.deployed.ServiceListener;
import moos.deployed.SiamTimer;
import moos.deployed.SiamTimerTask;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class Scheduler
extends SiamTimerTask
implements ServiceListener {
    public static boolean OVERWRITE = true;
    public static boolean PRESERVE = false;
    public static final int OK = 0;
    public static final int ALREADY_EXISTS = -1;
    public static final int NOT_FOUND = -2;
    public static final long MAX_LOOKAHEAD_SEC = 30L;
    SiamTimer _timer = null;
    Calendar _calendar;
    protected static boolean _defaultsLoaded = false;
    Vector _schedules = new Vector(10);
    public static Scheduler _theScheduler = null;
    static /* synthetic */ Class class$moos$deployed$ServiceListener;

    public Vector getSchedules() {
        return this._schedules;
    }

    public static synchronized Scheduler getInstance() {
        if (_theScheduler == null) {
            _theScheduler = new Scheduler();
            Scheduler._theScheduler._timer = new SiamTimer();
            EventManager.getInstance().addListener(class$moos$deployed$ServiceListener == null ? (class$moos$deployed$ServiceListener = Scheduler.class$("moos.deployed.ServiceListener")) : class$moos$deployed$ServiceListener, _theScheduler);
        }
        return _theScheduler;
    }

    public static String getStatusString(int status) {
        switch (status) {
            case 0: {
                return "OK";
            }
            case -1: {
                return "Already exists";
            }
            case -2: {
                return "Not Found";
            }
        }
        return "Unknown Status";
    }

    public synchronized int addSchedule(String scheduleFile, boolean overwrite) {
        boolean isMatch = false;
        Schedule match = null;
        Enumeration s = this._schedules.elements();
        while (s.hasMoreElements()) {
            Schedule nextSchedule = (Schedule)s.nextElement();
            if (!nextSchedule.getScheduleFile().equals(scheduleFile)) continue;
            isMatch = true;
            match = nextSchedule;
            break;
        }
        if (isMatch && !overwrite) {
            DebugMessage.println("addSchedule(): schedule exists");
            return -1;
        }
        if (!isMatch || isMatch && overwrite) {
            if (match != null) {
                this._schedules.remove(match);
            }
            Schedule schedule = new Schedule(scheduleFile);
            DebugMessage.println("Parsing " + scheduleFile);
            try {
                schedule.parse();
                this._schedules.add(schedule);
                DebugMessage.println("Added schedule " + scheduleFile);
            }
            catch (ScheduleParseException e) {
                System.err.println("Parse error in Schedule " + scheduleFile);
            }
        }
        return 0;
    }

    public synchronized int removeSchedule(String scheduleFile) {
        boolean removed = false;
        Enumeration s = this._schedules.elements();
        while (s.hasMoreElements()) {
            Schedule schedule = (Schedule)s.nextElement();
            if (!schedule.getScheduleFile().equals(scheduleFile)) continue;
            DebugMessage.println("Found schedule " + schedule.getScheduleFile());
            Enumeration e = schedule.getEntries().elements();
            while (e.hasMoreElements()) {
                ScheduleEntry entry = (ScheduleEntry)e.nextElement();
                DebugMessage.println("Cancelling entry for " + entry.get(11));
                entry.cancelTimer();
            }
            DebugMessage.println("Removing schedule " + schedule.getScheduleFile());
            this._schedules.remove(schedule);
            removed = true;
        }
        if (!removed) {
            System.err.println("Scheduler: Could not find schedule file \"" + scheduleFile + "\"");
            return -2;
        }
        System.out.println("Scheduler: Schedule " + scheduleFile + " removed");
        return 0;
    }

    public String showSchedule() {
        return this.showSchedule(30L);
    }

    public String showSchedule(long lookAheadSeconds) {
        String retval = "";
        Enumeration s = this._schedules.elements();
        while (s.hasMoreElements()) {
            Schedule schedule = (Schedule)s.nextElement();
            Enumeration e = schedule.getEntries().elements();
            while (e.hasMoreElements()) {
                retval = retval + "Schedule: " + schedule.getScheduleFile() + "\n";
                ScheduleEntry entry = (ScheduleEntry)e.nextElement();
                long r = entry.timeRemaining(lookAheadSeconds);
                String t = r == Long.MAX_VALUE ? "-" : Long.toString(r);
                retval = retval + "   Index: " + schedule.getEntries().indexOf(entry) + "\n";
                retval = retval + "    Name: " + entry.getScheduleSpecifier().get(12) + "\n";
                retval = retval + "Job File: " + entry.getScheduleSpecifier().get(11) + "\n";
                retval = retval + "Schedule: " + entry.getScheduleSpecifier().get(14) + "\n";
                retval = retval + "  Status: " + entry.getStateName(entry.getState()) + "\t" + t + "\n\n";
            }
            retval = retval + "\n";
        }
        return retval;
    }

    public Schedule getSchedule(String schedule) {
        Enumeration s = this._schedules.elements();
        while (s.hasMoreElements()) {
            Schedule nextSchedule = (Schedule)s.nextElement();
            if (!nextSchedule.getScheduleFile().equals(schedule)) continue;
            return nextSchedule;
        }
        return null;
    }

    public int[] lookupScheduleEntries(String schedule, String job) {
        Schedule nextSchedule = null;
        long dbLevel = DebugMessage.getLevel();
        DebugMessage.setLevel(1L);
        Enumeration s = this._schedules.elements();
        while (s.hasMoreElements()) {
            nextSchedule = (Schedule)s.nextElement();
            if (nextSchedule.getScheduleFile().equals(schedule)) break;
        }
        if (nextSchedule == null) {
            return null;
        }
        int[] indices = new int[4];
        Arrays.fill(indices, -1);
        int nextIndex = 0;
        Vector entries = nextSchedule.getEntries();
        Enumeration e = entries.elements();
        while (e.hasMoreElements()) {
            ScheduleEntry thisEntry = (ScheduleEntry)e.nextElement();
            if (!thisEntry.get(11).equals(job)) continue;
            if (nextIndex >= indices.length) {
                int[] temp = new int[indices.length + 16];
                Arrays.fill(temp, -1);
                System.arraycopy(indices, 0, temp, 0, indices.length);
                indices = temp;
            }
            indices[nextIndex++] = entries.indexOf(thisEntry);
            DebugMessage.println("Scheduler.lookup...: found " + job + " @ index " + entries.indexOf(thisEntry));
        }
        DebugMessage.setLevel(dbLevel);
        return indices;
    }

    public ScheduleEntry[] lookupScheduleEntries(Schedule schedule, long serviceID) {
        Schedule nextSchedule = null;
        Enumeration s = this._schedules.elements();
        while (s.hasMoreElements()) {
            nextSchedule = (Schedule)s.nextElement();
            if (nextSchedule.getScheduleFile().equals(schedule)) break;
        }
        if (nextSchedule == null) {
            return null;
        }
        Object[] scheduleEntries = new ScheduleEntry[4];
        Arrays.fill(scheduleEntries, null);
        int nextEntry = 0;
        Vector entries = nextSchedule.getEntries();
        Enumeration e = entries.elements();
        while (e.hasMoreElements()) {
            ScheduleEntry thisEntry = (ScheduleEntry)e.nextElement();
            if (thisEntry.getOwnerID() != serviceID) continue;
            if (nextEntry >= scheduleEntries.length) {
                Object[] temp = new ScheduleEntry[scheduleEntries.length + 16];
                Arrays.fill(temp, null);
                System.arraycopy(scheduleEntries, 0, temp, 0, scheduleEntries.length);
                scheduleEntries = temp;
            }
            scheduleEntries[nextEntry++] = thisEntry;
        }
        return scheduleEntries;
    }

    public synchronized int addScheduleEntry(String scheduleFile, long serviceID, String entry) {
        DebugMessage.println("Scheduler adding '" + entry + "' to " + scheduleFile);
        Schedule theSchedule = this.getSchedule(scheduleFile);
        if (theSchedule == null) {
            System.err.println("Schedule not found:" + scheduleFile);
            return -2;
        }
        return theSchedule.addEntry(serviceID, entry);
    }

    public synchronized int addScheduleEntry(String scheduleFile, long serviceID, ScheduleSpecifier spec, String serviceMethod) {
        DebugMessage.println("Scheduler adding '" + spec + "' for service " + serviceID + " to " + scheduleFile);
        Schedule theSchedule = this.getSchedule(scheduleFile);
        if (theSchedule == null) {
            System.err.println("Schedule not found:" + scheduleFile);
            return -2;
        }
        return theSchedule.addEntry(serviceID, spec, serviceMethod);
    }

    public synchronized int removeScheduleEntry(String scheduleFile, int index) {
        DebugMessage.println("Scheduler removing '" + index + "' from " + scheduleFile);
        Schedule theSchedule = this.getSchedule(scheduleFile);
        if (theSchedule == null) {
            System.err.println("Schedule not found:" + scheduleFile);
            return -2;
        }
        return theSchedule.removeEntry(index);
    }

    public synchronized int suspendScheduleEntry(String scheduleFile, int index) {
        Schedule theSchedule = this.getSchedule(scheduleFile);
        if (theSchedule == null) {
            System.err.println("Schedule not found:" + scheduleFile);
            return -2;
        }
        DebugMessage.println("Scheduler suspending entry " + index + " in " + scheduleFile);
        return theSchedule.suspendEntry(index);
    }

    public synchronized int resumeScheduleEntry(String scheduleFile, int index) {
        DebugMessage.println("Scheduler resuming '" + index + "' in " + scheduleFile);
        Schedule theSchedule = this.getSchedule(scheduleFile);
        if (theSchedule == null) {
            System.err.println("Schedule not found:" + scheduleFile);
            return -2;
        }
        return theSchedule.resumeEntry(index);
    }

    public void run() {
        long nextTime = Long.MAX_VALUE;
        Enumeration e = this._schedules.elements();
        while (e.hasMoreElements()) {
            Schedule schedule = (Schedule)e.nextElement();
            long timerem = schedule.getNextScheduledJob(60L);
            if (timerem >= nextTime) continue;
            nextTime = timerem;
        }
    }

    public long getNextScheduledJob() {
        return this.getNextScheduledJob(30L);
    }

    public synchronized long getNextScheduledJob(long lookAheadSeconds) {
        long nextTime = Long.MAX_VALUE;
        Enumeration e = this._schedules.elements();
        while (e.hasMoreElements()) {
            Schedule schedule = (Schedule)e.nextElement();
            long thisTime = schedule.getNextScheduledJob(lookAheadSeconds);
            if (thisTime >= nextTime) continue;
            nextTime = thisTime;
        }
        return nextTime;
    }

    public static Properties getSchedulerProperties() {
        Properties _nodeProps = new Properties();
        String _siamHome = Scheduler.getSiamHome();
        try {
            FileInputStream in = new FileInputStream(_siamHome + "/properties/scheduler.cfg");
            _nodeProps.load(in);
            in.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("NodeManager: FileNotFound " + e);
        }
        catch (IOException e) {
            System.err.println("NodeManager: IOException " + e);
        }
        return _nodeProps;
    }

    public static String getSiamHome() {
        Properties sys_props = new Properties();
        sys_props = System.getProperties();
        return sys_props.getProperty("siam_home").trim();
    }

    public static String getScheduleDirectory() {
        Properties _nodeProps = Scheduler.getSchedulerProperties();
        return _nodeProps.getProperty("scheduleDirectory").trim();
    }

    public String getDefaultSystemScheduleName() {
        Properties _nodeProps = Scheduler.getSchedulerProperties();
        return _nodeProps.getProperty("defaultSystemSchedule").trim();
    }

    public String getDefaultSampleScheduleName() {
        Properties _nodeProps = Scheduler.getSchedulerProperties();
        return _nodeProps.getProperty("defaultSampleSchedule").trim();
    }

    public static String getSchedulePath() {
        String siamHome = Scheduler.getSiamHome();
        String scheduleDirectory = Scheduler.getScheduleDirectory();
        while (scheduleDirectory.startsWith("/")) {
            scheduleDirectory = scheduleDirectory.substring(scheduleDirectory.indexOf("/") + 1);
        }
        while (scheduleDirectory.endsWith("/")) {
            scheduleDirectory = scheduleDirectory.substring(0, scheduleDirectory.lastIndexOf("/"));
        }
        while (siamHome.endsWith("/")) {
            siamHome = siamHome.substring(0, siamHome.lastIndexOf("/"));
        }
        return siamHome + "/" + scheduleDirectory;
    }

    public static void loadDefaults() {
        if (_defaultsLoaded) {
            return;
        }
        Scheduler s = Scheduler.getInstance();
        String systemScheduleName = s.getDefaultSystemScheduleName();
        DebugMessage.println("Default System Schedule is " + systemScheduleName);
        if (systemScheduleName != null || systemScheduleName.length() < 1) {
            s.addSchedule(systemScheduleName, PRESERVE);
        } else {
            System.err.println("Invalid defaultSystemSchedule in " + Scheduler.getSiamHome() + "/properties/scheduler.cfg");
        }
        String sampleScheduleName = s.getDefaultSampleScheduleName();
        DebugMessage.println("Default Sample Schedule is " + sampleScheduleName);
        if (sampleScheduleName != null || sampleScheduleName.length() < 1) {
            s.addSchedule(sampleScheduleName, PRESERVE);
        } else {
            System.err.println("Invalid defaultSampleSchedule in " + Scheduler.getSiamHome() + "/properties/scheduler.cfg");
        }
        _defaultsLoaded = true;
    }

    public void refreshSchedules() {
        Enumeration s = this._schedules.elements();
        while (s.hasMoreElements()) {
            Schedule nextSchedule = (Schedule)s.nextElement();
            nextSchedule.refreshTimers();
        }
    }

    public synchronized int sync(int index, long delayMillis) {
        Schedule schedule = Scheduler.getInstance().getSchedule(this.getDefaultSampleScheduleName());
        ScheduleEntry entry = schedule.getEntry(index);
        System.err.println("Scheduler: sync(" + index + "," + delayMillis + ")");
        entry.sync(delayMillis);
        return 0;
    }

    public void serviceInstalled(ServiceEvent event) {
        DebugMessage.println("Scheduler: Heard ServiceInstalledEvent");
        Scheduler s = Scheduler.getInstance();
        try {
            DebugMessage.println("Scheduler: getting Instrument Service...");
            Instrument instrument = null;
            NodeService nodeService = NodeManager.getInstance().getNodeService();
            Device device = nodeService.getDevice(event.getServiceID());
            if (!(device instanceof Instrument)) {
                System.err.println("Scheduler: Could not get instrument service");
                return;
            }
            instrument = (Instrument)device;
            byte[] scheduleBytes = instrument.getScheduleByteArray();
            if (scheduleBytes.length > 0) {
                ScheduleSpecifier schedule = new ScheduleSpecifier(new String(scheduleBytes));
                DebugMessage.println("Scheduler: created auto entry: " + schedule);
                schedule.setDisplayName(new String(instrument.getName()));
                DebugMessage.println("Scheduler: set displayname : " + schedule);
                s.addScheduleEntry(s.getDefaultSampleScheduleName(), event.getServiceID(), schedule, "getData");
            }
        }
        catch (RemoteException e0) {
            System.err.println(e0);
            return;
        }
        catch (DeviceNotFound e1) {
            System.err.println(e1);
            return;
        }
        catch (IOException e4) {
            System.err.println("IOException: " + e4.getMessage());
        }
        catch (ScheduleParseException e5) {
            System.err.println("ScheduleParseException: " + e5.getMessage());
        }
    }

    public void serviceRemoved(ServiceEvent event) {
        long dbLevel = DebugMessage.getLevel();
        DebugMessage.setLevel(1L);
        DebugMessage.println("Scheduler: Heard ServiceRemovedEvent");
        Scheduler s = Scheduler.getInstance();
        String schedule = s.getDefaultSampleScheduleName();
        String job = SchedulerJob.getAutoJobName(event.getServiceID());
        int[] entries = s.lookupScheduleEntries(schedule, job);
        int i = 0;
        if (entries.length > 0) {
            i = 0;
            while (i < entries.length && entries[i] != -1) {
                try {
                    DebugMessage.println("Scheduler removing " + job + " from " + schedule + " at index " + entries[i]);
                    s.removeScheduleEntry(schedule, entries[i]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("serviceRemoved: i=" + i + " entries.length=" + entries.length + " exception:\n" + e);
                }
                ++i;
            }
        }
        DebugMessage.setLevel(dbLevel);
    }

    public void serviceRequestComplete(ServiceEvent event) {
        DebugMessage.println("Scheduler: Heard ServiceRequestCompleteEvent id=" + event.getID() + " stateChange=" + event.getStateChange());
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            DebugMessage.setLevel(Long.parseLong(args[0]));
        } else {
            DebugMessage.setLevel(0L);
        }
        Scheduler s = Scheduler.getInstance();
        Scheduler.loadDefaults();
        while (true) {
            // Infinite loop
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

