/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import moos.deployed.DebugMessage;
import moos.deployed.JobRunner;
import moos.deployed.SchedulerJob;
import moos.deployed.SiamTimer;
import moos.deployed.SiamTimerTask;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class ScheduleEntry {
    public static final int WAITING = 0;
    public static final int EXECUTING = 1;
    public static final int SUSPENDED = 2;
    public static final int READY = 3;
    public static final int COUNTER_EXPIRED = 4;
    public static final int RUN = 1;
    public static final int CHECK_TIME = 2;
    String _line = null;
    ScheduleSpecifier _scheduleSpecifier = null;
    Calendar _calendar;
    SiamTimer _timer = new SiamTimer();
    SiamTimerTask _timerTask;
    SchedulerJob _schedulerJob = null;
    int _state;
    int _readyAction = 1;
    long _ownerID = -1L;

    public String getStateName(int state) {
        switch (state) {
            case 0: {
                return "Waiting";
            }
            case 1: {
                return "Executing";
            }
            case 2: {
                return "Suspended";
            }
            case 3: {
                return "Ready";
            }
            case 4: {
                return "Counter Expired";
            }
        }
        return "Invalid State";
    }

    public ScheduleSpecifier getScheduleSpecifier() {
        return this._scheduleSpecifier;
    }

    public void setSpecifier(ScheduleSpecifier spec) {
        this._scheduleSpecifier = spec;
    }

    public int getState() {
        return this._state;
    }

    protected void setState(int state) {
        this._state = state;
    }

    public SiamTimer getTimer() {
        return this._timer;
    }

    public void setTimer(SiamTimer timer) {
        this._timer = timer;
    }

    public void setTimerTask(SiamTimerTask task) {
        this._timerTask = task;
    }

    public SiamTimerTask getTimerTask() {
        return this._timerTask;
    }

    public long getPeriod() {
        return this._scheduleSpecifier.getPeriod();
    }

    public SchedulerJob getSchedulerJob() {
        return this._schedulerJob;
    }

    public void setSchedulerJob(SchedulerJob job) {
        this._schedulerJob = job;
    }

    public String get(int field) {
        return this._scheduleSpecifier.get(field);
    }

    public TimeZone getTZ() {
        return this._scheduleSpecifier.getTZ();
    }

    public long getLongCycles() {
        return this._scheduleSpecifier.getLongCycles();
    }

    public void setLongCycles(long cycles) {
        this._scheduleSpecifier.setLongCycles(cycles);
    }

    public long getOwnerID() {
        return this._ownerID;
    }

    public void setOwnerID(long id) {
        this._ownerID = id;
    }

    public boolean isAbsolute() {
        return this._scheduleSpecifier.isAbsolute();
    }

    public boolean isRelative() {
        return this._scheduleSpecifier.isRelative();
    }

    public boolean isSelectedTime(Calendar calendar) {
        return this._scheduleSpecifier.isSelectedTime(calendar);
    }

    public ScheduleEntry parse(String line) throws ScheduleParseException {
        line.trim();
        StringTokenizer lt = new StringTokenizer(line, "#");
        if (lt.hasMoreTokens()) {
            line = lt.nextToken();
        }
        DebugMessage.println("parsing line " + line);
        this._scheduleSpecifier = new ScheduleSpecifier(line);
        DebugMessage.println("Entry Complete; period = " + this.getPeriod());
        return this;
    }

    public Calendar getEntryTime() {
        return this.getEntryTime(System.currentTimeMillis());
    }

    public Calendar getEntryTime(long time) {
        this._calendar = Calendar.getInstance();
        long localOffset = this._calendar.get(15);
        this._calendar.setTimeZone(this.getTZ());
        long entryOffset = this._calendar.get(15);
        time = time - localOffset + entryOffset;
        this._calendar.setTime(new Date(time));
        return this._calendar;
    }

    public boolean isReady() {
        return this.isReady(System.currentTimeMillis());
    }

    public boolean isMasked() {
        if (this.isAbsolute() && this._readyAction == 2) {
            return true;
        }
        if (this._state == 2 || this._state == 4 || this._state == 1) {
            return true;
        }
        if (this.getLongCycles() == 0L) {
            System.out.println("Cycle counter expired for " + this.get(11));
            this.cancelTimer();
            this.setState(4);
            return true;
        }
        return false;
    }

    public boolean isReady(long time) {
        if (this.isMasked()) {
            return false;
        }
        Calendar entryTime = this.getEntryTime(time);
        DebugMessage.println("ScheduleEntry.isReady(): time= " + entryTime.getTime());
        boolean ready = this.isSelectedTime(entryTime);
        if (ready) {
            this.setState(3);
        }
        return ready;
    }

    public void startJob() {
        if (this._schedulerJob != null) {
            this.setState(1);
            this._schedulerJob.execute();
            System.out.println(" ");
            this.setState(0);
        }
    }

    public void fakeJob() {
        this.setState(1);
        DebugMessage.println("executing " + this.get(11) + " at " + this.getEntryTime().getTime());
        System.out.println(" ");
        this.setState(0);
    }

    public String toString() {
        return this._scheduleSpecifier.toString();
    }

    public long timeRemaining() {
        if (this.isAbsolute()) {
            return this.timeRemaining(30L);
        }
        return this.timeRemaining(0L);
    }

    public long timeRemaining(long lookAheadSeconds) {
        Calendar cal = this.getEntryTime();
        long now = cal.getTime().getTime();
        long remaining = 0L;
        int state = this.getState();
        if (state == 1 || state == 4 || state == 2) {
            return Long.MAX_VALUE;
        }
        if (this.isRelative() && this._timerTask != null) {
            long execTime = this._timerTask.scheduledExecutionTime();
            long period = this.getPeriod();
            remaining = period - (now - execTime);
            DebugMessage.println("timeRemaining: period = " + period + " now = " + now + " schedExecTime = " + execTime);
        }
        if (this.isAbsolute()) {
            this._readyAction = 2;
            long i = 0L;
            while (i < lookAheadSeconds) {
                cal.add(13, 1);
                if (this.isSelectedTime(cal)) {
                    this._readyAction = 1;
                    break;
                }
                ++i;
            }
            remaining = cal.getTime().getTime() - now;
        }
        return remaining;
    }

    public void sync() {
        this.sync(0L);
    }

    public void sync(long delayMillis) {
        if (this._timer != null) {
            System.err.println("sync(" + delayMillis + ") cancelling timer");
            this._timer.cancel();
        }
        if (this.isRelative()) {
            System.err.println("sync(" + delayMillis + ") rescheduling relative");
            this.rescheduleTimer(delayMillis);
        }
        if (this.isAbsolute()) {
            System.err.println("sync(" + delayMillis + ") running absolute");
            this.setTimer(new SiamTimer());
            JobRunner t = new JobRunner(this);
            this.setTimerTask(t);
            this.getTimer().schedule((SiamTimerTask)t, delayMillis);
            System.err.println("sync(" + delayMillis + ") rescheduling absolute");
        }
    }

    public void resetAbsoluteTimer(long delayMillis) {
        this._timer.cancel();
    }

    public void resetAbsoluteTimer() {
        if (this._state == 1 || this._state == 2 || this._state == 4) {
            return;
        }
        if (this.isAbsolute()) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            this.setTimer(new SiamTimer());
            long remaining = 0L;
            while (remaining <= 0L) {
                remaining = this.timeRemaining();
            }
            JobRunner t = new JobRunner(this);
            this.setTimerTask(t);
            this.getTimer().schedule((SiamTimerTask)t, remaining);
        }
    }

    public void rescheduleTimer(long delay) {
        if (this.isRelative()) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            this.setTimer(new SiamTimer());
            JobRunner t = new JobRunner(this);
            this.setTimerTask(t);
            this.getTimer().scheduleAtFixedRate((SiamTimerTask)t, delay, this.getPeriod());
        }
    }

    public void rescheduleTimer(Date startTime) {
        if (this.isRelative()) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            this.setTimer(new SiamTimer());
            JobRunner t = new JobRunner(this);
            this.setTimerTask(t);
            this.getTimer().scheduleAtFixedRate((SiamTimerTask)t, startTime, this.getPeriod());
        }
    }

    public void cancelTimer() {
        if (this._timerTask != null) {
            this._timerTask.cancel();
            DebugMessage.println("ScheduleEntry.cancelTimer(): cancelling timerTask");
        }
        if (this._timer != null) {
            this._timer.cancel();
            DebugMessage.println("ScheduleEntry.cancelTimer(): cancelling timer");
        }
        this._timer = null;
        this._timerTask = null;
    }

    public boolean equals(ScheduleEntry schedule) {
        return this._scheduleSpecifier.equals(schedule.getScheduleSpecifier());
    }
}

