/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import moos.deployed.DebugMessage;
import moos.deployed.JobRunner;
import moos.deployed.ScheduleEntry;
import moos.deployed.Scheduler;
import moos.deployed.SchedulerJob;
import moos.deployed.SiamTimer;
import moos.deployed.SiamTimerTask;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;

public class Schedule {
    Calendar _calendar;
    String _scheduleFile;
    Vector _scheduleEntries = new Vector(10);

    public Schedule() {
    }

    public Schedule(String file) {
        this._scheduleFile = file;
    }

    public void setScheduleFile(String file) {
        this._scheduleFile = file;
    }

    public String getScheduleFile() {
        return this._scheduleFile;
    }

    public Vector getEntries() {
        return this._scheduleEntries;
    }

    /*
     * Loose catch block
     */
    public void parse() throws ScheduleParseException {
        block19: {
            BufferedReader br = null;
            if (this._scheduleFile != null) {
                String schedulePath = Scheduler.getSchedulePath() + "/" + this._scheduleFile;
                try {
                    br = new BufferedReader(new FileReader(schedulePath));
                }
                catch (FileNotFoundException e) {
                    System.out.println("Schedule: Could not find file: " + schedulePath);
                    return;
                }
            }
            int lineNumber = 1;
            String line = br.readLine();
            while (line != null) {
                DebugMessage.println("Schedule.parse: parsing " + line);
                line.trim();
                if (line.indexOf("#") >= 0) {
                    line = line.substring(0, line.indexOf("#"));
                }
                if (line.length() >= 19) {
                    ScheduleEntry e = new ScheduleEntry();
                    this._scheduleEntries.add(e.parse(line));
                    JobRunner j = new JobRunner(e);
                    e.setTimerTask(j);
                    if (e.isRelative()) {
                        e.getTimer().scheduleAtFixedRate((SiamTimerTask)j, 0L, e.getPeriod());
                    }
                    if (e.isAbsolute()) {
                        e.getTimer().schedule((SiamTimerTask)j, e.timeRemaining());
                    }
                } else {
                    DebugMessage.println("hmmm...Looks like a comment " + line.length());
                }
                line = br.readLine();
                ++lineNumber;
            }
            Object var7_10 = null;
            try {
                br.close();
            }
            catch (IOException e2) {
                System.err.println("IOException in SchedulerJob.parse(): " + e2);
            }
            break block19;
            {
                catch (IOException e) {
                    System.out.println("IOException in Schedule.parse(): " + e);
                    var7_10 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        System.err.println("IOException in SchedulerJob.parse(): " + e2);
                    }
                    break block19;
                }
                catch (ScheduleParseException e) {
                    System.out.println("ScheduleParseException at line " + lineNumber + ": " + e.getMessage());
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    br.close();
                }
                catch (IOException e2) {
                    System.err.println("IOException in SchedulerJob.parse(): " + e2);
                }
                throw throwable;
            }
        }
        DebugMessage.println("Parsing Jobs...");
        Enumeration e = this._scheduleEntries.elements();
        while (e.hasMoreElements()) {
            ScheduleEntry entry = (ScheduleEntry)e.nextElement();
            String jobFile = entry.get(11);
            SchedulerJob job = new SchedulerJob(jobFile);
            job.parse();
            entry.setSchedulerJob(job);
        }
    }

    public ScheduleEntry getEntry(String entry) {
        Enumeration e = this._scheduleEntries.elements();
        while (e.hasMoreElements()) {
            ScheduleEntry match = (ScheduleEntry)e.nextElement();
            if (!match.get(11).equals(entry)) continue;
            return match;
        }
        return null;
    }

    public ScheduleEntry getEntry(ScheduleEntry entry) {
        Enumeration e = this._scheduleEntries.elements();
        while (e.hasMoreElements()) {
            ScheduleEntry match = (ScheduleEntry)e.nextElement();
            if (!match.equals(entry)) continue;
            return match;
        }
        return null;
    }

    public ScheduleEntry getEntry(int index) {
        ScheduleEntry entry;
        try {
            entry = (ScheduleEntry)this._scheduleEntries.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        return entry;
    }

    public int addEntry(long serviceID, ScheduleSpecifier spec, String serviceMethod) {
        try {
            String jobName = spec.get(11);
            if (jobName == null) {
                jobName = SchedulerJob.createDefaultJobFile(serviceID, serviceMethod);
            }
            if (jobName == null) {
                return -2;
            }
            System.out.println("Schedule.addEntry(id,spec,smeth): setting JOB " + jobName + ":" + serviceID + "," + spec + "," + serviceMethod);
            spec.set(11, jobName);
            ScheduleEntry newEntry = new ScheduleEntry();
            newEntry.setSpecifier(spec);
            newEntry.setOwnerID(serviceID);
            ScheduleEntry existingEntry = this.getEntry(newEntry);
            if (existingEntry != null) {
                return -1;
            }
            JobRunner j = new JobRunner(newEntry);
            newEntry.setTimerTask(j);
            if (newEntry.isRelative()) {
                newEntry.getTimer().scheduleAtFixedRate((SiamTimerTask)j, 0L, newEntry.getPeriod());
            }
            if (newEntry.isAbsolute()) {
                newEntry.getTimer().schedule((SiamTimerTask)j, newEntry.timeRemaining());
            }
            SchedulerJob job = new SchedulerJob(jobName);
            System.err.println("Schedule.addScheduleEntry(): parsing " + jobName);
            job.parse();
            newEntry.setSchedulerJob(job);
            this.addEntry(newEntry);
        }
        catch (ScheduleParseException e) {
            System.out.println("ScheduleParseException: " + e);
        }
        return 0;
    }

    public int addEntry(long serviceID, String line) {
        try {
            ScheduleEntry newEntry = new ScheduleEntry();
            newEntry = newEntry.parse(line);
            ScheduleEntry existingEntry = this.getEntry(newEntry);
            if (existingEntry != null) {
                return -1;
            }
            JobRunner j = new JobRunner(newEntry);
            newEntry.setTimerTask(j);
            if (newEntry.isRelative()) {
                newEntry.getTimer().scheduleAtFixedRate((SiamTimerTask)j, 0L, newEntry.getPeriod());
            }
            if (newEntry.isAbsolute()) {
                newEntry.getTimer().schedule((SiamTimerTask)j, newEntry.timeRemaining());
            }
            String jobFile = newEntry.get(11);
            SchedulerJob job = new SchedulerJob(jobFile);
            job.parse();
            newEntry.setSchedulerJob(job);
            newEntry.setOwnerID(serviceID);
            this.addEntry(newEntry);
        }
        catch (ScheduleParseException e) {
            System.out.println("ScheduleParseException in " + line + ": " + e);
        }
        return 0;
    }

    public int removeEntry(int index) {
        ScheduleEntry entry = this.getEntry(index);
        if (entry == null) {
            return -2;
        }
        DebugMessage.println("Schedule.removeEntry(): Removing entry " + index + " (" + entry.get(11) + ") from " + this.getScheduleFile());
        DebugMessage.println("Schedule.removeEntry(): cancelling timer");
        entry.cancelTimer();
        this._scheduleEntries.remove(entry);
        return 0;
    }

    public int suspendEntry(int index) {
        ScheduleEntry entry = this.getEntry(index);
        if (entry == null) {
            return -2;
        }
        DebugMessage.println("Suspending entry " + entry.get(11) + " in " + this.getScheduleFile());
        entry.setState(2);
        return 0;
    }

    public int resumeEntry(int index) {
        ScheduleEntry entry = this.getEntry(index);
        if (entry == null) {
            return -2;
        }
        DebugMessage.println("Resuming entry " + entry.get(11) + " in " + this.getScheduleFile());
        entry.setState(0);
        if (entry.isAbsolute()) {
            entry.resetAbsoluteTimer();
        }
        return 0;
    }

    public void addEntry(ScheduleEntry entry) {
        this._scheduleEntries.add(entry);
    }

    public String toString() {
        return this._scheduleEntries.toString();
    }

    public long getNextScheduledJob() {
        return this.getNextScheduledJob(30L);
    }

    public long getNextScheduledJob(long lookAheadSeconds) {
        long nextTime = Long.MAX_VALUE;
        ScheduleEntry nextEntry = null;
        Enumeration e = this._scheduleEntries.elements();
        while (e.hasMoreElements()) {
            ScheduleEntry entry = (ScheduleEntry)e.nextElement();
            long test = entry.timeRemaining(lookAheadSeconds);
            if (test >= nextTime) continue;
            nextTime = test;
            nextEntry = entry;
        }
        DebugMessage.println("next job in " + nextTime + " ms");
        return nextTime;
    }

    public void refreshTimers() {
        Enumeration e = this._scheduleEntries.elements();
        while (e.hasMoreElements()) {
            ScheduleEntry entry = (ScheduleEntry)e.nextElement();
            SiamTimer schedTimer = entry.getTimer();
            schedTimer.forceNotify();
        }
    }

    public static void main(String[] args) {
        Schedule s = new Schedule("sched.test");
        try {
            s.parse();
            System.out.println("\nDing! here it is: " + s);
        }
        catch (ScheduleParseException e) {
            System.out.println(e);
        }
    }
}

