/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import moos.deployed.PuckHeader;
import org.doomdark.uuid.UUID;

public class SandBox {
    private String _sandBoxPath = null;
    private static final String _PROPERTIES_NAME = "service.properties";
    private static final String _JAR_NAME = "puck.jar";
    private static final String _PUCK_HEADER_NAME = "puck.header";

    public SandBox(String sandBoxPath) throws IOException {
        this._sandBoxPath = sandBoxPath;
        File f = new File(this._sandBoxPath);
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("failed to create sand box directory " + this._sandBoxPath);
        }
    }

    public void empty() throws IOException {
        this.removeFile(_PROPERTIES_NAME);
        this.removeFile(_JAR_NAME);
        this.removeFile(_PUCK_HEADER_NAME);
    }

    public String getPath() {
        return this._sandBoxPath;
    }

    public String getPropertiesPath() {
        return this._sandBoxPath + File.separator + _PROPERTIES_NAME;
    }

    public String getJarPath() {
        return this._sandBoxPath + File.separator + _JAR_NAME;
    }

    public String getPuckHeaderPath() {
        return this._sandBoxPath + File.separator + _PUCK_HEADER_NAME;
    }

    public String getPropertiesName() {
        return _PROPERTIES_NAME;
    }

    public String getJarName() {
        return _JAR_NAME;
    }

    public String getPuckHeaderName() {
        return _PUCK_HEADER_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PuckHeader getPuckHeader() throws IOException {
        File headerFile = new File(this._sandBoxPath + File.separator + _PUCK_HEADER_NAME);
        long headerFileSize = headerFile.length();
        if (headerFileSize == 0L) {
            throw new IOException("could not find puck.header in the sand box");
        }
        if (headerFileSize < 304L) {
            throw new IOException("the file puck.header contained too few bytes to be a puck header");
        }
        byte[] b = new byte[304];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(headerFile);
            int i = 0;
            while (i < 304) {
                b[i] = (byte)fis.read();
                ++i;
            }
            Object var8_7 = null;
            if (fis == null) return new PuckHeader(b);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (fis == null) throw throwable;
            fis.close();
            throw throwable;
        }
        fis.close();
        return new PuckHeader(b);
    }

    public UUID getUUID() throws IOException {
        return this.getPuckHeader().getUUID();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compareChecksum() {
        block27: {
            block22: {
                block26: {
                    try {
                        headerChecksum = this.getPuckHeader().getChecksum();
                    }
                    catch (IOException e) {
                        return false;
                    }
                    fis = null;
                    cis = null;
                    try {
                        try {
                            fis = new FileInputStream(this._sandBoxPath + File.separator + "puck.jar");
                            cis = new CheckedInputStream(fis, new CRC32());
                            tempBuf = new byte[128];
                            while (cis.read(tempBuf) >= 0) {
                            }
                            if (headerChecksum != cis.getChecksum().getValue()) break block22;
                            var6_7 = true;
                            var8_9 = null;
                        }
                        catch (IOException e) {
                            var6_8 = false;
                            var8_11 = null;
                            try {
                                if (cis != null) {
                                    cis.close();
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                if (fis == null) return var6_8;
                                fis.close();
                                return var6_8;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return var6_8;
                        }
                    }
                    catch (Throwable var7_17) {
                        block25: {
                            var8_12 = null;
                            ** try [egrp 3[TRYBLOCK] [3 : 143->156)] { 
lbl42:
                            // 1 sources

                            if (cis != null) {
                                cis.close();
                            }
                            break block25;
lbl45:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [4 : 158->169)] { 
lbl49:
                        // 1 sources

                        if (fis == null) throw var7_17;
                        fis.close();
                        throw var7_17;
lbl52:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                        throw var7_17;
                    }
                    ** try [egrp 3[TRYBLOCK] [3 : 143->156)] { 
lbl57:
                    // 1 sources

                    if (cis != null) {
                        cis.close();
                    }
                    break block26;
lbl60:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ** try [egrp 4[TRYBLOCK] [4 : 158->169)] { 
lbl64:
                // 1 sources

                if (fis == null) return var6_7;
                fis.close();
                return var6_7;
lbl67:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                return var6_7;
            }
            var8_10 = null;
            ** try [egrp 3[TRYBLOCK] [3 : 143->156)] { 
lbl73:
            // 1 sources

            if (cis != null) {
                cis.close();
            }
            break block27;
lbl76:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        try {}
        catch (Exception e) {}
        if (fis == null) return false;
        fis.close();
        return false;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storePuckHeader(PuckHeader puckHeader) throws IOException {
        FileOutputStream fos = null;
        byte[] headerBytes = puckHeader.getBytes();
        try {
            fos = new FileOutputStream(this.getPuckHeaderPath());
            int i = 0;
            while (i < headerBytes.length) {
                fos.write(headerBytes[i]);
                ++i;
            }
            Object var6_6 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        fos.close();
    }

    private void removeFile(String file) throws IOException {
        File f = new File(this._sandBoxPath + File.separator + file);
        if (f.exists()) {
            try {
                if (!f.delete()) {
                    throw new IOException("failed to remove " + file + " from the sandbox");
                }
            }
            catch (SecurityException e) {
                throw new IOException("caught SecurityException while removing " + file + " from the " + "sandbox:" + e);
            }
        }
    }
}

