/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import moos.deployed.DebugMessage;
import moos.deployed.DeviceService;
import moos.deployed.InstrumentConsole;
import moos.deployed.InstrumentPort;
import moos.deployed.InstrumentService;
import moos.deployed.RangeException;
import moos.utils.StopWatch;
import org.mbari.isi.interfaces.Instrument;

public class RemoteSerialPortServer
extends Thread {
    ServerSocket _serverSocket = null;
    InstrumentConsole _instrumentConsole = null;
    DeviceService _deviceService = null;
    byte[] _annotationBuffer = new byte[512];
    private static final int _MAX_TIMEOUT = 3600000;
    private static final int _MIN_TIMEOUT = 1000;
    private static final int _SOCKET_WRITES_MAX = 32;
    private static final int _SOCKET_READS_MAX = 32;
    public static final int _DEFAULT_TIMEOUT = 60000;
    private int _serverTimeout = 60000;
    private boolean _shutdownRequest = false;

    public RemoteSerialPortServer(InstrumentPort instPort, int sockPort) throws IOException {
        this.initialize(instPort, null, sockPort);
    }

    public RemoteSerialPortServer(InstrumentPort instPort) throws IOException {
        this.initialize(instPort, null, 0);
    }

    public RemoteSerialPortServer(InstrumentPort instPort, DeviceService deviceService) throws IOException {
        this.initialize(instPort, deviceService, 0);
    }

    private void initialize(InstrumentPort instPort, DeviceService deviceService, int sockPort) throws IOException {
        this._serverSocket = new ServerSocket(sockPort);
        this._instrumentConsole = instPort.getInstrumentConsole();
        this._deviceService = deviceService;
    }

    public int getServerPort() {
        return this._serverSocket.getLocalPort();
    }

    public InetAddress getServerInetAddress() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public int getTimeout() {
        return this._serverTimeout;
    }

    public void setTimeout(int timeout) throws RangeException {
        if (timeout > 3600000) {
            throw new RangeException("timeout value of " + timeout + " exceeds max timeout of " + 3600000);
        }
        if (timeout < 1000) {
            throw new RangeException("timeout value of " + timeout + " is less than min timeout of " + 1000);
        }
        this._serverTimeout = timeout;
    }

    public void shutdown() {
        this._shutdownRequest = true;
    }

    /*
     * Loose catch block
     */
    public void run() {
        int annotationByteCount;
        block31: {
            Socket clientSocket;
            block29: {
                block28: {
                    clientSocket = null;
                    boolean socketConnected = false;
                    try {
                        Object var6_3;
                        try {
                            this._serverSocket.setSoTimeout(this._serverTimeout);
                            clientSocket = this._serverSocket.accept();
                            socketConnected = true;
                        }
                        catch (InterruptedIOException e) {
                            System.err.println("RemoteSerialPortServer shutting down, timed out waiting for client: " + e);
                            var6_3 = null;
                            if (!socketConnected) {
                                if (this._deviceService != null) {
                                    this._deviceService.resume();
                                }
                                return;
                            }
                            break block28;
                        }
                        catch (IOException e) {
                            System.err.println("RemoteSerialPortServer shutting down, got unexpected IOException while waiting  for client: " + e);
                            var6_3 = null;
                            if (!socketConnected) {
                                if (this._deviceService != null) {
                                    this._deviceService.resume();
                                }
                                return;
                            }
                        }
                        var6_3 = null;
                        if (!socketConnected) {
                            if (this._deviceService != null) {
                                this._deviceService.resume();
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_4 = null;
                        if (!socketConnected) {
                            if (this._deviceService != null) {
                                this._deviceService.resume();
                            }
                            return;
                        }
                        throw throwable;
                    }
                }
                annotationByteCount = 0;
                OutputStream os = clientSocket.getOutputStream();
                InputStream is = clientSocket.getInputStream();
                int socketWrites = 0;
                int socketReads = 0;
                StopWatch sessionTimer = new StopWatch(true);
                do {
                    socketWrites = 0;
                    while (this._instrumentConsole.available() > 0) {
                        os.write(this._instrumentConsole.read());
                        if (++socketWrites >= 32) break;
                    }
                    socketReads = 0;
                    while (is.available() > 0) {
                        int c = is.read();
                        if (annotationByteCount < this._annotationBuffer.length) {
                            this._annotationBuffer[annotationByteCount++] = (byte)c;
                        }
                        this._instrumentConsole.write(c);
                        sessionTimer.clear();
                        if (++socketReads >= 32) break;
                    }
                    if (sessionTimer.read() <= (long)this._serverTimeout) continue;
                    System.err.println("RemoteSerialPortServer shutting down, in activity timeout");
                    if (this._deviceService != null) {
                        this._deviceService.resume();
                    }
                    break block29;
                } while (!this._shutdownRequest);
                DebugMessage.println("RemoteSerialPortServer shutting down");
            }
            Object var11_18 = null;
            try {
                clientSocket.close();
            }
            catch (Exception e2) {}
            break block31;
            {
                catch (IOException e) {
                    System.err.println("RemoteSerialPortServer shutting down, got unexpected IOException: " + e);
                    Object var11_19 = null;
                    try {
                        clientSocket.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                try {
                    clientSocket.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (this._deviceService instanceof Instrument) {
            byte[] b = new byte[annotationByteCount];
            int i = 0;
            while (i < annotationByteCount) {
                b[i] = this._annotationBuffer[i];
                ++i;
            }
            InstrumentService instrument = (InstrumentService)this._deviceService;
            instrument.annotate(b);
        }
    }
}

