/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.util.Enumeration;
import java.util.Vector;
import moos.deployed.QueueDispatcher;

public class Queue
implements Runnable {
    private Vector _queue;
    Thread _queueThread;
    QueueDispatcher _dispatcher = null;

    public Queue() {
        this._queue = new Vector(16);
    }

    public Queue(int capacity) {
        this._queue = new Vector(capacity);
    }

    public Queue(int capacity, QueueDispatcher dispatcher) {
        this._queue = new Vector(capacity);
        this._dispatcher = dispatcher;
    }

    public void setDispatcher(QueueDispatcher dispatcher) {
        this._dispatcher = dispatcher;
    }

    public synchronized void enqueue(Object o) {
        this._queue.addElement(o);
        this.notify();
    }

    public synchronized Object dequeue() {
        if (this._queue.isEmpty()) {
            return null;
        }
        Object retVal = this._queue.elementAt(0);
        this._queue.removeElementAt(0);
        return retVal;
    }

    public synchronized Object dequeue(int index) throws ArrayIndexOutOfBoundsException {
        if (this._queue.isEmpty()) {
            return null;
        }
        Object retVal = this._queue.elementAt(index);
        this._queue.removeElementAt(index);
        return retVal;
    }

    public synchronized Object blockingDequeue() {
        if (this._queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                System.err.println("Queue.blockingDequeue() caught " + ie);
            }
        }
        Object retVal = this._queue.elementAt(0);
        this._queue.removeElementAt(0);
        return retVal;
    }

    public Object peek() throws ArrayIndexOutOfBoundsException {
        return this.elementAt(0);
    }

    public Object elementAt(int index) throws ArrayIndexOutOfBoundsException {
        return this._queue.elementAt(index);
    }

    public Enumeration elements() {
        return this._queue.elements();
    }

    public synchronized boolean isEmpty() {
        return this._queue.isEmpty();
    }

    public void getNext() {
        Object next = this.blockingDequeue();
        this._dispatcher.dispatch(next);
    }

    public synchronized void startQueue() {
        this._queueThread = new Thread(this);
        this._queueThread.start();
    }

    public void run() {
        while (true) {
            this.getNext();
        }
    }
}

