/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moos.deployed.DebugMessage;
import moos.deployed.PowerPort;
import moos.deployed.PuckHeader;
import moos.deployed.PuckInputStream;
import moos.deployed.SerialInstrumentPort;
import moos.deployed.SerialPortParameters;
import moos.utils.StopWatch;
import moos.utils.StreamUtils;
import org.mbari.isi.interfaces.InitializeException;

public class PuckSerialInstrumentPort
extends SerialInstrumentPort {
    private int _powerState = 2;
    private int _commsPowerState = 2;
    private boolean _sensorMode = true;
    private InputStream _fromPuck;
    private OutputStream _toPuck;
    private static final int _POWER_OFF = 0;
    private static final int _POWER_ON = 1;
    private static final int _POWER_UNKNOWN = 2;
    private static final int _PUCK_POWER_OFF_DELAY = 200;
    private static final int _PUCK_POWER_ON_DELAY = 300;
    private static final int _PUCK_SENSOR_MODE_DELAY = 100;
    private static final int _PUCK_CURRENT_LIMIT = 8000;
    private static final int _MAX_PUCK_ATTENTION_RETRIES = 4;
    private static final int _DEFAULT_PUCK_BAUD_RATE = 9600;
    private static final int _DEFAULT_PUCK_DATA_BITS = 8;
    private static final int _DEFAULT_PUCK_STOP_BITS = 1;
    private static final int _DEFAULT_PUCK_PARITY = 0;
    private static final byte[] _PUCK_PROMPT = "RDY\r".getBytes();
    private PuckHeader _puckHeader = null;
    private SerialPortParameters _defaultPuckSerialParams = null;
    SerialPortParameters _serialPortParameters = null;

    public PuckSerialInstrumentPort(SerialPort serial, PowerPort power) {
        super(serial, power);
    }

    public void initialize() throws InitializeException {
        super.initialize();
        try {
            this._defaultPuckSerialParams = new SerialPortParameters(9600, 8, 0, 1);
        }
        catch (Exception e) {
            throw new InitializeException("SerialPortParams() failure: " + e);
        }
        try {
            this._toPuck = this._serialPort.getOutputStream();
        }
        catch (Exception e) {
            throw new InitializeException("getOutputStream() failure: " + e);
        }
        try {
            this._fromPuck = this._serialPort.getInputStream();
        }
        catch (Exception e) {
            throw new InitializeException("getInputStream() failure: " + e);
        }
        try {
            this._serialPortParameters = this.getSerialPortParams();
        }
        catch (Exception e) {
            throw new InitializeException("getSerialPortParams() failure: " + e);
        }
    }

    private void initPuckHeader() throws IOException {
        if (this._sensorMode) {
            throw new IOException("not in puck mode");
        }
        PuckInputStream pis = new PuckInputStream(this._fromPuck, this._toPuck);
        byte[] b = new byte[304];
        int i = 0;
        while (i < 304) {
            b[i] = (byte)pis.read();
            ++i;
        }
        pis.close();
        pis = null;
        this._puckHeader = new PuckHeader(b);
    }

    public void connectPower() {
        switch (this._powerState) {
            case 1: {
                break;
            }
            case 0: {
                this._powerPort.connectPower();
                this._powerState = 1;
                this._sensorMode = false;
                try {
                    this.setSensorMode();
                }
                catch (IOException e) {
                    System.err.println("failed to connectPower.");
                }
                break;
            }
            default: {
                this._powerPort.disconnectPower();
                StopWatch.delay(200);
                this._powerPort.connectPower();
                this._powerState = 1;
                this._sensorMode = false;
                try {
                    this.setSensorMode();
                    break;
                }
                catch (IOException e) {
                    System.err.println("failed to connectPower.");
                }
            }
        }
    }

    public void disconnectPower() {
        this._powerPort.disconnectPower();
        this._powerState = 0;
        this._sensorMode = true;
    }

    public void setSerialPortParams(SerialPortParameters params) throws IOException, UnsupportedCommOperationException {
        super.setSerialPortParams(params);
        this._serialPortParameters = params;
    }

    public void getPuckAttention() throws IOException {
        if (this._sensorMode) {
            throw new IOException("getPuckAttention(): not in puck mode");
        }
        StopWatch.delay(300);
        int i = 0;
        while (i < 4) {
            try {
                this._toPuck.write("SA 0\r".getBytes());
                StreamUtils.skipUntil(this._fromPuck, _PUCK_PROMPT, 1000L);
                break;
            }
            catch (Exception e) {
                System.err.println("getPuckAttention() failed on try " + (i + 1) + " :" + e);
                ++i;
            }
        }
        if (i == 4) {
            throw new IOException("getPuckAttention() failed");
        }
    }

    public InputStream getPuckInputStream() throws IOException {
        if (this._sensorMode) {
            throw new IOException("getPuckInputStream(): not in puck mode");
        }
        if (this._puckHeader == null) {
            this.initPuckHeader();
        }
        PuckInputStream pis = new PuckInputStream(this._fromPuck, this._toPuck);
        pis.skip(this._puckHeader.getPayloadStart());
        return pis;
    }

    public PuckHeader getPuckHeader() throws IOException {
        if (this._puckHeader == null) {
            this.initPuckHeader();
        }
        return this._puckHeader;
    }

    public int getPuckPayloadSize() throws IOException {
        if (this._puckHeader == null) {
            this.initPuckHeader();
        }
        return this._puckHeader.getPayloadSize();
    }

    public void setPuckBaudRate(int baud) throws IOException {
        if (this._sensorMode) {
            throw new IOException("not in puck mode");
        }
        try {
            int i = 0;
            while (i < 3) {
                String baud_str = "SB " + baud + "\r";
                try {
                    this.getPuckAttention();
                }
                catch (IOException e) {
                    DebugMessage.println("getPuckAttention() top: failed to set baud try " + (i + 1));
                }
                byte[] tmp_bytes = baud_str.getBytes();
                DebugMessage.println("setting puck baud to " + baud);
                this._toPuck.write(tmp_bytes);
                StopWatch.delay(250);
                DebugMessage.println("setting local baud to " + baud);
                this._serialPort.setSerialPortParams(baud, this._serialPort.getDataBits(), this._serialPort.getStopBits(), this._serialPort.getParity());
                DebugMessage.println("resync puck serial port");
                try {
                    this.getPuckAttention();
                    break;
                }
                catch (IOException e) {
                    DebugMessage.println("getPuckAttention() bottom: failed to set baud try " + (i + 1));
                    ++i;
                }
            }
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setPuckBaud() UnsupportedCommOperationException: " + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new IOException("setPuckBaud() IOException: " + e);
        }
    }

    public void setPuckMode() throws IOException {
        try {
            this._serialPortParameters = this.getSerialPortParams();
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setPuckMode(): failed to get serial port params");
        }
        try {
            if (!this.serialParamsEqual(this._defaultPuckSerialParams, this._serialPortParameters)) {
                this._serialPort.setSerialPortParams(9600, 8, 1, 0);
            }
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setPuckMode(): failed to set default puck serial port params");
        }
        if (this._powerState == 0) {
            this._powerPort.connectPower();
            this._powerState = 1;
            this._sensorMode = false;
            return;
        }
        this._powerPort.disconnectPower();
        this._powerState = 0;
        StopWatch.delay(200);
        this._powerPort.connectPower();
        this._powerState = 1;
        this._powerPort.enableCommunications();
        this._sensorMode = false;
    }

    public void setSensorMode() throws IOException {
        if (this._sensorMode) {
            return;
        }
        this._powerPort.enableCommunications();
        try {
            if (!this.serialParamsEqual(this._defaultPuckSerialParams, this._serialPortParameters)) {
                DebugMessage.println("setSensorMode() switching to pucks default baud rate");
                this._serialPort.setSerialPortParams(9600, 8, 1, 0);
            }
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setSensorMode(): failed to set default puck serial port params");
        }
        StopWatch.delay(300);
        this._toPuck.write("\r".getBytes());
        StopWatch.delay(50);
        this._toPuck.write("SM\r".getBytes());
        StopWatch.delay(50);
        try {
            DebugMessage.println("setSensorMode() switching to instruments baud rate");
            this.setSerialPortParams(this._serialPortParameters);
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setSensorMode(): failed to set instrument serial port params");
        }
    }

    public boolean isSensorModeSet() {
        return this._sensorMode;
    }

    private boolean serialParamsEqual(SerialPortParameters a, SerialPortParameters b) {
        return a.getBaud() == b.getBaud() && a.getDataBits() == b.getDataBits() && a.getParity() == b.getParity() && a.getStopBits() == b.getStopBits();
    }
}

