/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moos.utils.StreamUtils;

public class PuckOutputStream
extends OutputStream {
    private InputStream puckIn;
    private OutputStream puckOut;
    private int currentPosition = 0;
    private int dataBufferPosition = 0;
    private boolean streamOpen = false;
    private byte[] dataBuffer = new byte[32];
    private final int maxInitRetries = 4;
    private static final int BUFFER_SIZE = 32;
    private static final byte[] PUCK_PROMPT = "RDY\r".getBytes();

    public PuckOutputStream(InputStream in, OutputStream out) {
        this.puckIn = in;
        this.puckOut = out;
        if (!this.initPuckStream()) {
            System.out.println("failed to open PuckOutPutStream");
            return;
        }
    }

    public void close() throws IOException {
        while (this.dataBufferPosition < 32) {
            this.write(255);
        }
        this.writePacket();
        this.puckOut.write("FL\r".getBytes());
        try {
            StreamUtils.skipUntil(this.puckIn, PUCK_PROMPT, 1000L);
        }
        catch (Exception e) {
            throw new IOException("puck error: " + e.getMessage());
        }
        this.streamOpen = false;
    }

    public void write(int b) throws IOException {
        if (this.dataBufferPosition < 32) {
            ++this.currentPosition;
            this.dataBuffer[this.dataBufferPosition++] = (byte)b;
        } else {
            this.writePacket();
            this.dataBufferPosition = 0;
            ++this.currentPosition;
            this.dataBuffer[this.dataBufferPosition++] = (byte)b;
        }
    }

    private boolean writePacket() throws IOException {
        this.puckOut.write("WM ".getBytes());
        this.puckOut.write(Integer.toString(32).getBytes());
        this.puckOut.write("\r".getBytes());
        int i = 0;
        while (i < 32) {
            this.puckOut.write(this.dataBuffer[i]);
            ++i;
        }
        try {
            StreamUtils.skipUntil(this.puckIn, PUCK_PROMPT, 500L);
        }
        catch (Exception e) {
            throw new IOException("puck error: " + e.getMessage());
        }
        return true;
    }

    public boolean initPuckStream() {
        int i = 0;
        while (i < 4) {
            block3: {
                try {
                    this.puckIn.skip(this.puckIn.available());
                    this.puckOut.write(13);
                    StreamUtils.skipUntil(this.puckIn, PUCK_PROMPT, 500L);
                    this.puckOut.write("ER\r".getBytes());
                    StreamUtils.skipUntil(this.puckIn, PUCK_PROMPT, 5000L);
                }
                catch (Exception e) {
                    System.err.println("failed to synchronize on try : " + i);
                    System.err.println("received : " + e.getMessage());
                    if (i <= 4) break block3;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

