/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moos.deployed.DebugMessage;
import moos.utils.StreamUtils;

public class PuckInputStream
extends InputStream {
    private InputStream puckIn;
    private OutputStream puckOut;
    private int currentPosition = 0;
    private int dataBufferPosition = 0;
    private boolean streamOpen = false;
    private byte[] dataBuffer = new byte[256];
    private byte[] _tempBuffer = new byte[272];
    private static final byte[] PUCK_PROMPT = "RDY\r".getBytes();
    private final int maxInitRetries = 4;
    private static final int _BUFFER_SIZE = 256;

    public PuckInputStream(InputStream in, OutputStream out) {
        this.puckIn = in;
        this.puckOut = out;
        this.initPuckStream();
    }

    public void resetStream() throws IOException {
        this.puckOut.write("SA 0\r".getBytes());
        try {
            StreamUtils.skipUntil(this.puckIn, PUCK_PROMPT, 500L);
        }
        catch (Exception e) {
            throw new IOException("puck error: " + e.getMessage());
        }
        this.currentPosition = 0;
        this.dataBufferPosition = 0;
        this.streamOpen = true;
    }

    public void close() throws IOException {
        this.currentPosition = 0;
        this.streamOpen = false;
    }

    public int available() throws IOException {
        if (!this.streamOpen) {
            throw new IOException("puck stream not open");
        }
        return 256 - this.dataBufferPosition;
    }

    public int read() throws IOException {
        if (this.dataBufferPosition < 256) {
            ++this.currentPosition;
            return this.dataBuffer[this.dataBufferPosition++];
        }
        this.getPacket();
        this.dataBufferPosition = 0;
        ++this.currentPosition;
        return this.dataBuffer[this.dataBufferPosition++];
    }

    public long skip(long n) throws IOException {
        if (!this.streamOpen) {
            throw new IOException("puck stream not open");
        }
        long i = 0L;
        while (i < n) {
            this.read();
            ++i;
        }
        return i;
    }

    private void getPacket() throws IOException {
        if (!this.streamOpen) {
            throw new IOException("puck stream not open");
        }
        this.puckOut.write("RM ".getBytes());
        this.puckOut.write(Integer.toString(256).getBytes());
        this.puckOut.write("\r".getBytes());
        try {
            StreamUtils.readUntil(this.puckIn, this._tempBuffer, PUCK_PROMPT, 3000L);
        }
        catch (Exception e) {
            throw new IOException("puck error: " + e.getMessage());
        }
        String tmp_string = new String(this._tempBuffer, 0, 3);
        if (tmp_string.compareTo("ERR") == 0) {
            throw new IOException("puck error: " + new String(this._tempBuffer, 0, 8));
        }
        int i = 0;
        while (i < 256) {
            this.dataBuffer[i] = this._tempBuffer[i + 1];
            ++i;
        }
    }

    public boolean initPuckStream() {
        int i = 0;
        while (i < 4) {
            try {
                this.puckIn.skip(this.puckIn.available());
                this.resetStream();
                this.getPacket();
                DebugMessage.println("initPuckStream() successful");
                return true;
            }
            catch (IOException e) {
                System.err.println("failed to resetStream() on try : " + i);
                System.err.println("received : " + e.getMessage());
                if (i > 4) {
                    return false;
                }
                ++i;
            }
        }
        System.err.println("initPuckStream() failed: max retires exceeded");
        return false;
    }
}

