/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import moos.deployed.RangeException;
import moos.deployed.ServiceProperties;
import moos.utils.ByteUtility;
import org.doomdark.uuid.UUID;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;

public class PuckHeader {
    private byte[] _headerBytes = null;
    private byte[] _tempBuffer = new byte[256];
    public static final int _ORG_ID = 1;
    public static final int _TYPE_ID = 1;
    private static final int _ORG_SIZE = 4;
    private static final int _ORG_OFFSET = 0;
    private static final int _TYPE_SIZE = 4;
    private static final int _TYPE_OFFSET = 4;
    private static final int _UUID_SIZE = 16;
    private static final int _UUID_OFFSET = 8;
    private static final int _PAYLOAD_START_SIZE = 4;
    private static final int _PAYLOAD_START_OFFSET = 24;
    private static final int _PAYLOAD_END_SIZE = 4;
    private static final int _PAYLOAD_END_OFFSET = 28;
    private static final int _PAYLOAD_CHECKSUM_SIZE = 4;
    private static final int _PAYLOAD_CHECKSUM_OFFSET = 32;
    private static final int _SERVICE_NAME_SIZE = 256;
    private static final int _SERVICE_NAME_OFFSET = 36;
    private static final int _ISI_ID_SIZE = 8;
    private static final int _ISI_ID_OFFSET = 292;
    private static final int _CURRENT_LIMIT_SIZE = 4;
    private static final int _CURRENT_LIMIT_OFFSET = 300;
    public static final int _SIZE = 304;

    public PuckHeader(byte[] headerBytes) {
        this._headerBytes = new byte[304];
        int i = 0;
        while (i < 304) {
            this._headerBytes[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < headerBytes.length) {
            this._headerBytes[i2] = headerBytes[i2];
            ++i2;
        }
    }

    public PuckHeader() {
        this._headerBytes = new byte[304];
        this.setOrgId(1);
        this.setTypeId(1);
        this.setPayloadStart(304);
    }

    public byte[] getBytes() {
        return this._headerBytes;
    }

    public int getOrgId() {
        try {
            return ByteUtility.bytesToInt(this._headerBytes, 0);
        }
        catch (RangeException e) {
            return -1;
        }
    }

    public int getTypeId() {
        try {
            return ByteUtility.bytesToInt(this._headerBytes, 4);
        }
        catch (RangeException e) {
            return -1;
        }
    }

    public UUID getUUID() {
        return new UUID(this._headerBytes, 8);
    }

    public int getPayloadStart() {
        try {
            return ByteUtility.bytesToInt(this._headerBytes, 24);
        }
        catch (RangeException e) {
            return -1;
        }
    }

    public int getPayloadEnd() {
        try {
            return ByteUtility.bytesToInt(this._headerBytes, 28);
        }
        catch (RangeException e) {
            return -1;
        }
    }

    public int getPayloadSize() {
        return this.getPayloadEnd() - this.getPayloadStart();
    }

    public long getChecksum() {
        byte[] b = new byte[8];
        int i = 0;
        while (i < 4) {
            b[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            b[i2 + 4] = this._headerBytes[i2 + 32];
            ++i2;
        }
        try {
            return ByteUtility.bytesToLong(b);
        }
        catch (RangeException e) {
            return -1L;
        }
    }

    public String getServiceName() {
        String serviceName = new String(this._headerBytes, 36, 256);
        return serviceName.trim();
    }

    public long getIsiId() {
        try {
            return ByteUtility.bytesToLong(this._headerBytes, 292);
        }
        catch (RangeException e) {
            return -1L;
        }
    }

    public int getCurrentLimit() {
        try {
            return ByteUtility.bytesToInt(this._headerBytes, 300);
        }
        catch (RangeException e) {
            return -1;
        }
    }

    private void setOrgId(int id) {
        byte[] b = ByteUtility.intToBytes(id);
        int i = 0;
        while (i < 4) {
            this._headerBytes[i + 0] = b[i];
            ++i;
        }
    }

    private void setTypeId(int id) {
        byte[] b = ByteUtility.intToBytes(id);
        int i = 0;
        while (i < 4) {
            this._headerBytes[i + 4] = b[i];
            ++i;
        }
    }

    public void setUUID(UUID uuid) {
        byte[] b = uuid.toByteArray();
        int i = 0;
        while (i < 16) {
            this._headerBytes[i + 8] = b[i];
            ++i;
        }
    }

    private void setPayloadStart(int start) {
        byte[] b = ByteUtility.intToBytes(start);
        int i = 0;
        while (i < 4) {
            this._headerBytes[i + 24] = b[i];
            ++i;
        }
    }

    public void setPayloadSize(int size) {
        int end = this.getPayloadStart() + size;
        byte[] b = ByteUtility.intToBytes(end);
        int i = 0;
        while (i < 4) {
            this._headerBytes[i + 28] = b[i];
            ++i;
        }
    }

    public void setChecksum(long checkSum) {
        byte[] b = ByteUtility.longToBytes(checkSum);
        int i = 0;
        while (i < 4) {
            this._headerBytes[i + 32] = b[i + 4];
            ++i;
        }
    }

    public void setServiceName(String name) {
        byte[] b = name.getBytes();
        int i = 0;
        while (i < 256) {
            this._headerBytes[i + 36] = i < b.length ? b[i] : (byte)0;
            ++i;
        }
    }

    public void setIsiId(long id) {
        byte[] b = ByteUtility.longToBytes(id);
        int i = 0;
        while (i < 8) {
            this._headerBytes[i + 292] = b[i];
            ++i;
        }
    }

    public void setCurrentLimit(int limit) {
        byte[] b = ByteUtility.intToBytes(limit);
        int i = 0;
        while (i < 4) {
            this._headerBytes[i + 300] = b[i];
            ++i;
        }
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
        int currentLimit;
        long isiID;
        String serviceName = serviceProperties.getServiceName();
        if (serviceName == null) {
            serviceName = "*** UNKNOWN ***";
        }
        this.setServiceName(serviceName);
        try {
            isiID = serviceProperties.getDeviceID();
        }
        catch (MissingPropertyException e) {
            System.err.println("Can't find ISI ID in properties file.");
            System.err.println("Setting ISI ID to -1.");
            isiID = -1L;
        }
        catch (InvalidPropertyException e) {
            System.err.println("ISI ID invalid in properties file");
            System.err.println("Setting ISI ID to -1.");
            isiID = -1L;
        }
        this.setIsiId(isiID);
        try {
            currentLimit = serviceProperties.getCurrentLimit();
        }
        catch (MissingPropertyException e) {
            System.err.println("Can't find current limit in properties file.");
            System.err.println("Setting current limit to -1.");
            currentLimit = -1;
        }
        catch (InvalidPropertyException e) {
            System.err.println("Current limit invalid in properties file");
            System.err.println("Setting current limit to -1.");
            currentLimit = -1;
        }
        this.setCurrentLimit(currentLimit);
    }
}

