/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import moos.deployed.DebugMessage;
import moos.deployed.DeviceService;
import moos.deployed.DeviceServiceClassLoader;
import moos.deployed.DpaBoard;
import moos.deployed.EventManager;
import moos.deployed.InstrumentService;
import moos.deployed.NodeManager;
import moos.deployed.NodeProperties;
import moos.deployed.NullPowerPort;
import moos.deployed.PowerPort;
import moos.deployed.PuckSerialInstrumentPort;
import moos.deployed.SandBox;
import moos.deployed.SerialInstrumentPort;
import moos.deployed.ServiceEvent;
import moos.deployed.ServiceProperties;
import moos.deployed.SidearmPowerPort;
import moos.deployed.SpiMaster;
import moos.utils.FileUtils;
import moos.utils.StopWatch;
import org.apache.log4j.Logger;
import org.mbari.isi.interfaces.DuplicateIdException;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.PortNotFound;
import org.mbari.isi.interfaces.PortOccupiedException;

public class PortManager
implements CommPortOwnershipListener {
    static Logger _logger = Logger.getLogger((Class)(class$moos$deployed$PortManager == null ? (class$moos$deployed$PortManager = PortManager.class$("moos.deployed.PortManager")) : class$moos$deployed$PortManager));
    Vector _ports;
    NodeProperties _nodeProps;
    NodeManager _nodeManager;
    String _siamHome;
    String _serviceJarLocation;
    String _serviceXMLLocation = "service.xml";
    String _servicePropertiesLocation = "service.properties";
    String _serviceCacheLocation = "service.cache";
    String _codebaseLocation;
    String _logLocation;
    private static int _MAX_PUCK_READ_TRIES = 3;
    private static int _instanceCount = 0;
    private static final int MAX_NODE_PORTS = 100;
    private static final int TOTAL_DPA_CHANS = 8;
    private static final int TOTAL_DPA_BOARDS = 4;
    private static final int _PUCK_READ_TIMEOUT = 60000;
    private static final int _DEFAULT_PUCK_CURRENT = 8000;
    private static DpaBoard.DpaChannel[] _dpaChannels = new DpaBoard.DpaChannel[8];
    private static int[] _spiSlaveIndex = new int[]{0, 1, 2, 3};
    private static SpiMaster _spi = SpiMaster.getInstance();
    static /* synthetic */ Class class$moos$deployed$PortManager;

    PortManager(String siamHome, NodeProperties nodeProps) throws MissingPropertyException, InvalidPropertyException {
        if (++_instanceCount > 1) {
            System.err.println("Only ONE instance of PortManager allowed!");
            System.exit(1);
        }
        this._nodeProps = nodeProps;
        this._siamHome = siamHome;
        this._serviceJarLocation = this._nodeProps.getServiceJarDirectory();
        this._codebaseLocation = this._nodeProps.getCodebaseDirectory();
        this._logLocation = this._nodeProps.getDeviceLogDirectory();
        try {
            this.initPortVector();
        }
        catch (IOException ioe) {
            System.err.println("initPortVector threw IOException: " + ioe);
            ioe.printStackTrace();
        }
        if (this.dpasInConfig()) {
            SpiMaster spiMaster = _spi;
            synchronized (spiMaster) {
                _spi.setClkDivider(64);
            }
            this.scanDpas();
        } else {
            System.out.println("PortManager: no DPAs set in siamPorts.cfg");
        }
    }

    private void initPortVector() throws IOException, MissingPropertyException, InvalidPropertyException {
        this._ports = new Vector();
        String platform_ports = this._nodeProps.getPortNames();
        System.setProperty("gnu.io.rxtx.SerialPorts", platform_ports);
        _logger.debug((Object)("serial ports: " + platform_ports));
        int i = 0;
        while (i < 100) {
            try {
                Port port = this._nodeProps.getPort(i);
                this._ports.add(port);
            }
            catch (MissingPropertyException e) {
                System.out.println("Found " + i + " configured ports in properties file");
                break;
            }
            ++i;
        }
    }

    boolean dpasInConfig() {
        int i = 0;
        while (i < this._ports.size()) {
            Port port = (Port)this._ports.elementAt(i);
            if (port._hasPowerPort) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Vector getPorts() {
        return this._ports;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scanPort(Port port) throws PortOccupiedException, IOException, DuplicateIdException, PortNotFound {
        block69: {
            block68: {
                if (port._service != null) {
                    throw new PortOccupiedException();
                }
                if (port._jarName.length() == 0) {
                    System.err.println("Service jar not specified for port " + port._serialPortName);
                    return;
                }
                portIndex = this._ports.indexOf(port);
                if (portIndex < 0) {
                    throw new PortNotFound("bad index port index " + portIndex);
                }
                sandBoxPath = this._siamHome + File.separator + this._serviceJarLocation + File.separator + "port" + portIndex;
                sandBox = new SandBox(sandBoxPath);
                checkPuck = false;
                jarFile = null;
                if (port._jarName.equals("PUCK")) {
                    checkPuck = true;
                } else {
                    jarFileName = this._siamHome + File.separator + this._serviceJarLocation + File.separator + port._jarName;
                    jarFile = new File(jarFileName);
                    if (!jarFile.exists()) {
                        System.err.println("Service jar file " + jarFile.getName() + " not found.");
                        return;
                    }
                    FileUtils.copyFile(jarFileName, sandBox.getJarPath());
                    PortManager._logger.debug((Object)("Found service jar file " + jarFile.getName()));
                }
                powerPort /* !! */  = null;
                serialPort = null;
                try {
                    PortManager._logger.debug((Object)"Opening serial port...");
                    serialPort = PortManager.openSerialPort(port._serialPortName, 9600);
                    if (port._hasPowerPort && (port_index = this._ports.indexOf(port)) < 8 && PortManager._dpaChannels[port_index] != null) {
                        powerPort /* !! */  = new SidearmPowerPort("DPA chan " + port_index, PortManager._dpaChannels[port_index]);
                        port.setPowerPort(powerPort /* !! */ );
                        PortManager._logger.debug((Object)("PowerPort is SidearmPowerPort: at DPA Channel " + port_index));
                    }
                    if (powerPort /* !! */  == null) {
                        powerPort /* !! */  = new NullPowerPort();
                    }
                }
                catch (NoSuchPortException e) {
                    System.err.println("PortManager - NoSuchPortException: " + port._serialPortName + ": " + (Object)e);
                }
                catch (PortInUseException e) {
                    System.err.println("PortManager - PortInUseException: " + port._serialPortName + ": " + e.getMessage());
                }
                catch (UnsupportedCommOperationException e) {
                    System.err.println("PortManager - UnsupportedCommOperation: " + port._serialPortName + ": " + (Object)e);
                }
                catch (IOException e) {
                    System.err.println("PortManager - IOException: " + port._serialPortName + ": " + e);
                }
                catch (Exception e) {
                    System.err.println("PortManager - caught Exception: " + e);
                }
                instPort = null;
                if (checkPuck) {
                    PortManager._logger.debug((Object)"creating PuckSerialInstrumentPort");
                    puckInstPort = new PuckSerialInstrumentPort(serialPort, powerPort /* !! */ );
                    try {
                        try {
                            try {
                                puckInstPort.initialize();
                                puckInstPort.setCurrentLimit(8000);
                                puckInstPort.setPuckMode();
                                puckInstPort.getPuckAttention();
                            }
                            catch (Exception e) {
                                puckInstPort.disconnectPower();
                                puckInstPort.isolatePort();
                                System.err.println("Caught Exception '" + e + "' while checking for puck");
                                throw new IOException("Puck communications failed on initialize: " + e);
                            }
                            PortManager._logger.debug((Object)"initializing puck object");
                            try {
                                puckInstPort.setPuckBaudRate(38400);
                            }
                            catch (Exception e) {
                                puckInstPort.disconnectPower();
                                puckInstPort.isolatePort();
                                throw new IOException("failed to set puck baudrate: " + e);
                            }
                            puckHeader = puckInstPort.getPuckHeader();
                            getJarFileFromPuck = false;
                            try {
                                if (!sandBox.getUUID().equals(puckHeader.getUUID())) {
                                    getJarFileFromPuck = true;
                                    System.err.println("Puck unique Id didn't match the sand box unique id");
                                    System.err.println("puck unique id    : " + puckHeader.getUUID());
                                    System.err.println("sand box unique id: " + sandBox.getUUID());
                                }
                            }
                            catch (IOException e) {
                                System.err.println(e);
                                getJarFileFromPuck = true;
                            }
                            if (!sandBox.compareChecksum()) {
                                getJarFileFromPuck = true;
                            }
                            if (!getJarFileFromPuck) {
                                System.out.println("The puck has not changed since the last scanPort, using cached jar file");
                            }
                            if (getJarFileFromPuck) {
                                sandBox.empty();
                                sandBox.storePuckHeader(puckHeader);
                                payloadSize = puckInstPort.getPuckPayloadSize();
                                puckIn = null;
                                i = 0;
                                while (i < PortManager._MAX_PUCK_READ_TRIES) {
                                    block66: {
                                        puckIn = puckInstPort.getPuckInputStream();
                                        try {
                                            try {
                                                this.copyJarToHost(puckIn, sandBox.getJarPath(), payloadSize, 60000L);
                                                var18_43 = null;
                                                if (puckIn == null) break;
                                            }
                                            catch (Exception e) {
                                                System.err.println("copyJarToHost(...) failed on try " + (i + 1) + " :" + e);
                                                var18_43 = null;
                                                if (puckIn == null) break block66;
                                                puckIn.close();
                                                break block66;
                                            }
                                        }
                                        catch (Throwable var17_44) {
                                            var18_43 = null;
                                            if (puckIn == null) throw var17_44;
                                            puckIn.close();
                                            throw var17_44;
                                        }
                                        puckIn.close();
                                        break;
                                    }
                                    ++i;
                                }
                                if (i == PortManager._MAX_PUCK_READ_TRIES) {
                                    throw new IOException("failed to copy puck contents to host");
                                }
                            }
                            if (!(jarFile = new File(sandBox.getJarPath())).exists()) {
                                System.err.println("Service jar file " + sandBox.getJarPath() + " not found.");
                                var20_45 = null;
                                puckInstPort.disconnectPower();
                                return;
                            }
                            instPort = puckInstPort;
                        }
                        catch (IOException e) {
                            serialPort.close();
                            serialPort = null;
                            puckInstPort.disconnectPower();
                            puckInstPort.isolatePort();
                            System.err.println("puck failed: " + e);
                            throw new IOException("puck failed: " + e);
                        }
                        catch (Exception e) {
                            serialPort.close();
                            serialPort = null;
                            System.err.println("PortManager puck failed: " + e);
                            var20_47 = null;
                            puckInstPort.disconnectPower();
                            break block68;
                        }
                    }
                    catch (Throwable var19_49) {
                        var20_48 = null;
                        puckInstPort.disconnectPower();
                        throw var19_49;
                    }
                    var20_46 = null;
                    puckInstPort.disconnectPower();
                } else {
                    serInstPort = new SerialInstrumentPort(serialPort, powerPort /* !! */ );
                    try {
                        serInstPort.initialize();
                    }
                    catch (Exception e) {
                        System.err.println("scanPort failed: SerialInstrumentPort to initialize SerialInstrumentPort");
                        return;
                    }
                    instPort = serInstPort;
                }
            }
            idOk = false;
            try {
                this.checkIsiID(sandBox.getJarPath());
                idOk = true;
            }
            catch (Exception e) {
                System.err.println("PortManager.scanPort(): - caught " + e);
                e.printStackTrace();
                var22_51 = null;
                if (idOk) break block69;
                try {
                    if (serialPort != null) {
                        serialPort.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("PortManager.scanPort(): - caught " + e);
                }
                break block69;
            }
            var22_50 = null;
            if (idOk) break block69;
            {
                catch (Throwable var21_56) {
                    var22_52 = null;
                    if (idOk != false) throw var21_56;
                    ** try [egrp 11[TRYBLOCK] [16 : 1453->1466)] { 
lbl195:
                    // 1 sources

                    if (serialPort == null) throw var21_56;
                    serialPort.close();
                    throw var21_56;
lbl198:
                    // 1 sources

                    catch (Exception e) {
                        System.err.println("PortManager.scanPort(): - caught " + e);
                    }
                    throw var21_56;
                }
                ** try [egrp 11[TRYBLOCK] [16 : 1453->1466)] { 
lbl202:
                // 1 sources

                if (serialPort != null) {
                    serialPort.close();
                }
lbl206:
                // 1 sources

                catch (Exception e) {}
                System.err.println("PortManager.scanPort(): - caught " + e);
            }
        }
        try {
            this.copyClassesToCodeBase(jarFile);
        }
        catch (Exception e) {
            System.err.println("PortManager.copyClassesToCodeBase(): " + e);
            e.printStackTrace();
        }
        try {
            this.updateSandbox(sandBox);
        }
        catch (Exception e) {
            System.err.println("PortManager.updateSandbox(): " + e);
            e.printStackTrace();
        }
        service = null;
        serviceStarted = false;
        try {
            PortManager._logger.debug((Object)("Creating DeviceServiceClassLoader  from file " + jarFile.getName() + " size=" + jarFile.length()));
            classLoader = new DeviceServiceClassLoader(new File(sandBox.getJarPath()));
            PortManager._logger.debug((Object)"Starting service...");
            service = classLoader.startService(classLoader.getEntryClassName(), instPort);
            service.setNodeProperties(this._nodeProps);
            service.setParent(NodeManager.getInstance());
            try {
                service.initializePropertyDefaults();
                this.setServiceProperties(service, new JarFile(sandBox.getJarPath()));
                service.setServiceXMLPath(this._serviceXMLLocation.getBytes());
                service.setServicePropertiesPath(this._servicePropertiesLocation.getBytes());
                service.setServiceCachePath(this._serviceCacheLocation.getBytes());
                service.initialize();
                serviceStarted = true;
            }
            catch (Exception e) {
                System.err.println("Caught Exception from service.initialize(): " + e);
                service.setStatusError();
            }
            port._service = service;
        }
        catch (ClassNotFoundException e) {
            System.err.println("PortManager - ClassNotFoundException: " + e);
        }
        catch (InstantiationException e) {
            System.err.println("PortManager - InstantiationException: " + e);
        }
        catch (IllegalAccessException e) {
            System.err.println("PortManager - IllegalAccessException: " + e);
        }
        catch (Exception e) {
            System.err.println("PortManager - caught Exception: " + e);
            e.printStackTrace();
        }
        if (!serviceStarted) {
            System.out.println("Service not properly started; remove it");
            if (service != null) {
                service.shutdown();
            }
            if (instPort != null) {
                instPort.isolatePort();
                instPort.shutDown();
            }
        } else {
            se = new ServiceEvent(this, 1, 1, (int)service.getId());
            EventManager.getInstance().postEvent(se);
        }
        nodeManager = NodeManager.getInstance();
        nodeManager.logNodeConfiguration("Added service for device " + service.getId() + " on port " + port._serialPortName);
    }

    private void copyJarToHost(InputStream in, String dest_name, int in_size, long time_out) throws FileNotFoundException, IOException {
        long debugLevel = DebugMessage.getLevel();
        FileOutputStream out = new FileOutputStream(dest_name);
        _logger.debug((Object)"copying puck contents to the host");
        StopWatch puckReadTimer = new StopWatch(true);
        int i = 0;
        while (i < in_size) {
            out.write(in.read());
            if (i % 256 == 0) {
                DebugMessage.print("+");
            }
            ++i;
        }
        puckReadTimer.stop();
        _logger.debug((Object)"\ncopy complete...");
        out.close();
        in.close();
        _logger.debug((Object)("took " + puckReadTimer.read() + " ms to copy puck contents to the host"));
    }

    void updateSandbox(SandBox sandBox) throws Exception {
        _logger.debug((Object)"create JarFile...");
        JarFile jarFile = new JarFile(sandBox.getJarPath());
        ZipEntry zipEntry = null;
        InputStream input = null;
        File propFile = new File(sandBox.getPropertiesPath());
        if (!propFile.exists()) {
            zipEntry = jarFile.getEntry(sandBox.getPropertiesName());
            if (zipEntry == null) {
                throw new Exception("Service properties file \"" + sandBox.getPropertiesName() + "\" not found in jar file " + jarFile.getName());
            }
            input = jarFile.getInputStream(zipEntry);
            FileUtils.copyFile(input, sandBox.getPropertiesPath());
        }
        try {
            String destinationName;
            String xmlFilename = "service.xml";
            this._serviceXMLLocation = destinationName = sandBox.getPath() + File.separator + xmlFilename;
            zipEntry = jarFile.getEntry(xmlFilename);
            if (zipEntry == null) {
                throw new Exception("Service XML file \"" + xmlFilename + "\" not found in jar file " + jarFile.getName());
            }
            input.close();
            input = jarFile.getInputStream(zipEntry);
            FileUtils.copyFile(input, destinationName);
        }
        catch (Exception e) {
            System.err.println("couldn't extract service.xml...that's OK " + e);
        }
        if (jarFile != null) {
            jarFile.close();
        }
        if (input != null) {
            input.close();
        }
    }

    void checkIsiID(String file) throws DuplicateIdException, Exception {
        String fn = "service.properties";
        JarFile jf = null;
        ZipEntry ze = null;
        jf = new JarFile(file);
        ze = jf.getEntry(fn);
        if (ze == null) {
            throw new Exception("Service properties file \"" + fn + "\" not found in jar file " + jf.getName());
        }
        ServiceProperties sp = new ServiceProperties();
        sp.load(jf.getInputStream(ze));
        long id = sp.getDeviceID();
        int i = 0;
        while (i < this._ports.size()) {
            Port port = (Port)this._ports.get(i);
            if (port._service != null && port._service.getId() == id) {
                String es = "service \"" + new String(port._service.getName()) + "\" on port \"" + new String(port._service.getCommPortName()) + "\" already has isiID " + id;
                throw new DuplicateIdException(es);
            }
            ++i;
        }
    }

    void copyClassesToCodeBase(File file) throws MissingPropertyException, Exception {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> zipEntries = jarFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry ze = zipEntries.nextElement();
            if (!ze.getName().endsWith(".class")) continue;
            StringTokenizer tok = new StringTokenizer(ze.getName(), File.separator);
            String classDir = this._codebaseLocation;
            while (tok.countTokens() - 1 > 0) {
                classDir = classDir + File.separator + tok.nextToken();
            }
            File classFile = new File(classDir);
            classFile.mkdirs();
            if (!classFile.exists()) {
                throw new Exception("failed to created the directory " + classDir);
            }
            classFile = new File(this._codebaseLocation + File.separator + ze.getName());
            classFile.createNewFile();
            if (!classFile.exists()) {
                throw new Exception("failed to created the file " + classFile);
            }
            FileOutputStream os = new FileOutputStream(classFile);
            InputStream is = jarFile.getInputStream(ze);
            long MAX_CLASS_COPY_TIME = 10000L;
            long classFileSize = ze.getSize();
            if (classFileSize < 0L) {
                throw new Exception(" could not determine size of " + ze.getName() + " in file " + jarFile.getName());
            }
            StopWatch sw = new StopWatch(true);
            while (classFileSize > 0L && sw.read() < MAX_CLASS_COPY_TIME) {
                if (is.available() <= 0) continue;
                os.write(is.read());
                --classFileSize;
            }
            os.close();
            is.close();
            sw.stop();
            _logger.debug((Object)("total copy time: " + sw.read() + " millisec"));
            if (classFileSize == 0L) {
                _logger.debug((Object)(ze.getName() + "successfully copied to codebase"));
                continue;
            }
            throw new Exception("failed to copy " + ze.getName() + " to code base");
        }
        if (jarFile != null) {
            jarFile.close();
        }
    }

    void scanDpas() {
        int i = 0;
        while (i < 4) {
            int channelIndex = 2 * i;
            if (DpaBoard.checkForDpaHardware(_spiSlaveIndex[i])) {
                _logger.debug((Object)("Found DPA at slot: " + i));
                DpaBoard dpa = new DpaBoard(_spiSlaveIndex[i]);
                PortManager._dpaChannels[channelIndex] = dpa.getLeftChannel();
                _dpaChannels[channelIndex].initializeChannel();
                PortManager._dpaChannels[++channelIndex] = dpa.getRightChannel();
                _dpaChannels[channelIndex].initializeChannel();
            } else {
                System.err.println("No DPA Found at slot: " + i);
                PortManager._dpaChannels[channelIndex] = null;
                PortManager._dpaChannels[++channelIndex] = null;
            }
            ++i;
        }
    }

    public void scanPorts() {
        int i = 0;
        while (i < this._ports.size()) {
            Port port = (Port)this._ports.elementAt(i);
            try {
                CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)port._serialPortName);
                portId.addPortOwnershipListener((CommPortOwnershipListener)this);
            }
            catch (NoSuchPortException e) {
                System.err.println("PortManager.scanPorts(): NoSuchPortException - " + port._serialPortName);
            }
            try {
                this.scanPort(port);
            }
            catch (PortOccupiedException e) {
                System.err.println("Service already running on port " + port._serialPortName);
            }
            catch (DuplicateIdException e) {
                System.err.println(e);
            }
            catch (PortNotFound e) {
                System.err.println("Port " + port + " not found " + e);
            }
            catch (IOException e) {
                System.err.println("scanPort failed on " + port._serialPortName + e);
            }
            ++i;
        }
    }

    public void ownershipChange(int type) {
        DebugMessage.print("**** Port ownership change: ");
        switch (type) {
            case 1: {
                _logger.debug((Object)"OWNED");
                break;
            }
            case 2: {
                _logger.debug((Object)"UNOWNED");
                break;
            }
            case 3: {
                _logger.debug((Object)"OWNERSHIP_REQUEST");
            }
        }
    }

    static SerialPort openSerialPort(String devicePortName, int baud) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, Exception {
        _logger.debug((Object)("Get port identifier for \"" + devicePortName + "\"..."));
        CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)devicePortName);
        _logger.debug((Object)"Got port identifier!");
        if (portId.getPortType() != 1) {
            throw new Exception("Port " + devicePortName + " is not a serial port.");
        }
        _logger.debug((Object)("open ze serial port..." + devicePortName));
        SerialPort serialPort = (SerialPort)portId.open(devicePortName, 1000);
        _logger.debug((Object)"set port params...");
        serialPort.setSerialPortParams(baud, 8, 1, 0);
        return serialPort;
    }

    void removeService(Port port) {
        try {
            if (port._service == null) {
                return;
            }
            ServiceEvent se = new ServiceEvent(this, 1, 2, (int)port._service.getId());
            EventManager.getInstance().postEvent(se);
            port._service.shutdown();
            long deviceID = port._service.getId();
            UnicastRemoteObject.unexportObject(port._service, true);
            port._service = null;
            NodeManager.getInstance().logNodeConfiguration("Removed service for device " + deviceID + " from port " + port._serialPortName);
            return;
        }
        catch (NoSuchObjectException e) {
            System.err.println("PortManager couldn't unexport object");
            return;
        }
    }

    Port getPortByName(String portName) throws PortNotFound {
        int i = 0;
        while (i < this._ports.size()) {
            String pName;
            Port port = (Port)this._ports.elementAt(i);
            if (port != null && (pName = port._serialPortName) != null && pName.equals(portName)) {
                return port;
            }
            ++i;
        }
        System.out.println("getPortByName() - no port matching " + portName);
        throw new PortNotFound();
    }

    protected void setServiceProperties(DeviceService service, JarFile jarFile) throws ZipException, IOException, SecurityException, Exception {
        String propertyFilename = "service.properties";
        ZipEntry zipEntry = jarFile.getEntry(propertyFilename);
        if (zipEntry == null) {
            throw new Exception("Service properties file \"" + propertyFilename + "\" not found in jar file " + jarFile.getName());
        }
        InputStream input = jarFile.getInputStream(zipEntry);
        service.loadProperties(input);
        input.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Port {
        String _serialPortName;
        String _jarName;
        DeviceService _service = null;
        boolean _hasPowerPort = false;
        PowerPort _powerPort = null;

        public Port(String serialPortName, boolean hasPowerPort, String jar, InstrumentService service) {
            this._serialPortName = new String(serialPortName);
            this._hasPowerPort = hasPowerPort;
            this._jarName = new String(jar);
            this._service = service;
        }

        public void setPowerPort(PowerPort powerPort) {
            this._powerPort = powerPort;
        }
    }
}

