/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import com.strangeberry.rendezvous.Rendezvous;
import com.strangeberry.rendezvous.ServiceInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import moos.deployed.CommsLeaseListener;
import moos.deployed.CommsSchedulerTask;
import moos.deployed.DeviceService;
import moos.deployed.InstrumentService;
import moos.deployed.NodeManager;
import moos.deployed.NodeProperties;
import moos.deployed.PortManager;
import moos.deployed.RangeException;
import moos.deployed.Scheduler;
import moos.deployed.SiamTimer;
import moos.deployed.SiamTimerTask;
import moos.interfaces.leasing.LeaseRefused;
import moos.interfaces.portal.PortalProxy;
import moos.interfaces.portal.Portals;
import moos.leasing.LeaseManager;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.DevicePacketSet;
import org.mbari.isi.interfaces.DuplicateIdException;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.Location;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.Port;
import org.mbari.isi.interfaces.PortConfiguration;
import org.mbari.isi.interfaces.PortNotFound;
import org.mbari.isi.interfaces.PortOccupiedException;
import org.mbari.isi.interfaces.PowerSwitch;
import org.mbari.isi.interfaces.RemoteSerialPort;
import org.mbari.isi.interfaces.UnknownLocationException;

public class NodeService
extends UnicastRemoteObject
implements Node {
    private static final long LEASE_INTERVAL = 120000L;
    private static final long LEASE_RENEWAL_INTERVAL = 900000L;
    protected PortManager _portManager = null;
    protected String _portalHost = null;
    protected NodeProperties _nodeProperties = null;
    protected long _leaseInterval = 120000L;
    protected long _leaseRenewalInterval = 900000L;
    private static int _instanceCount = 0;
    LeaseManager _leaseManager = null;
    SiamTimer _commsTimer = null;
    CommsSchedulerTask _commsSchedulerTask = null;
    PortalProxy _portalProxy = null;
    String _portalURL = null;
    Vector _ports = null;

    NodeService(PortManager portManager, String portalHost) throws RemoteException, MissingPropertyException, InvalidPropertyException, IOException {
        if (++_instanceCount > 1) {
            System.err.println("Only ONE instance of NodeService allowed!");
            System.exit(1);
        }
        this._portManager = portManager;
        this._ports = this._portManager.getPorts();
        this._portalHost = portalHost;
        this._nodeProperties = NodeManager.getInstance().getNodeProperties();
        String advertiseService = this._nodeProperties.getProperty("advertiseService", "false");
        this._leaseInterval = this._nodeProperties.getLongProperty("NodeService.leaseInterval", 120000L);
        this._leaseRenewalInterval = this._nodeProperties.getLongProperty("NodeService.leaseRenewalInterval", 900000L);
        this._leaseManager = new LeaseManager();
        if (this._leaseManager == null) {
            System.err.println("NodeService error: Can't find LeaseManager!");
        } else {
            this._leaseManager.addListener(new CommsLeaseListener(this));
            try {
                this._leaseManager.establish(this._leaseInterval);
            }
            catch (LeaseRefused e) {
                System.err.println("LeaseRefused exception in NodeService: " + e);
            }
        }
        if (portalHost != null) {
            try {
                InetAddress inetAddr = InetAddress.getByName(portalHost);
            }
            catch (UnknownHostException e) {
                System.err.println("Couldn't find portal host \"" + portalHost + "\": " + e.getMessage());
                return;
            }
            this._portalURL = Portals.portalURL(portalHost);
            this._portalProxy = this.getPortalProxy();
        }
        if (advertiseService.equalsIgnoreCase("true")) {
            InetAddress address = this.host();
            Rendezvous rendezvous = new Rendezvous(address);
            String type = "node.siam._rmi._tcp.local.";
            String name = address.getHostName() + "." + type;
            System.out.println("NodeService: registering service \"" + name + "\" with Rendezvous, using interface " + address.getHostAddress());
            int port = 7777;
            ServiceInfo serviceInfo = new ServiceInfo(type, name, rendezvous.getInterface(), port, 0, 0, "lat=0.0, lon=0.0, depth=0.0");
            rendezvous.registerService(serviceInfo);
            System.out.println("NodeService: service registered.");
        }
    }

    public void startComms() {
        this._commsTimer = new SiamTimer();
        this._commsSchedulerTask = new CommsSchedulerTask(this._leaseManager, this._leaseInterval, this._leaseRenewalInterval);
        this._commsTimer.schedule((SiamTimerTask)this._commsSchedulerTask, 0L, this._leaseRenewalInterval);
    }

    public InetAddress host() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public final byte[] getName() {
        return this.getClass().getName().getBytes();
    }

    public long getId() {
        return NodeManager.getInstance().getId();
    }

    public void initialize() throws InitializeException {
    }

    public Device getDevice(byte[] portName) throws PortNotFound, DeviceNotFound {
        PortManager.Port port = this._portManager.getPortByName(new String(portName));
        if (port._service == null) {
            throw new DeviceNotFound();
        }
        return port._service;
    }

    public void shutdownDeviceService(byte[] portName) throws PortNotFound, DeviceNotFound {
        PortManager.Port port = this._portManager.getPortByName(new String(portName));
        this._portManager.removeService(port);
    }

    public Port[] getPorts() {
        Port[] ports = new Port[this._ports.size()];
        int i = 0;
        while (i < this._ports.size()) {
            PortManager.Port port = (PortManager.Port)this._ports.elementAt(i);
            ports[i] = port._service != null ? new Port(port._serialPortName.getBytes(), port._service.getId(), port._service.getName()) : new Port(port._serialPortName.getBytes());
            ++i;
        }
        return ports;
    }

    public PowerSwitch[] getPowerSwitches() {
        int nSwitches = 0;
        int i = 0;
        while (i < this._ports.size()) {
            PortManager.Port port = (PortManager.Port)this._ports.elementAt(i);
            if (port._powerPort != null) {
                ++nSwitches;
            }
            ++i;
        }
        System.out.println("getPowerSwitches(): nSwitches=" + nSwitches);
        PowerSwitch[] switches = new PowerSwitch[nSwitches];
        nSwitches = 0;
        int i2 = 0;
        while (i2 < this._ports.size()) {
            PortManager.Port port = (PortManager.Port)this._ports.elementAt(i2);
            if (port._powerPort != null) {
                System.out.println("getPowerSwitches(): found a switch");
                byte[] switchName = port._powerPort.getName().getBytes();
                long deviceID = 0L;
                if (port._service != null) {
                    deviceID = port._service.getId();
                    System.out.println("getPowerSwitches(): assoc ID: " + deviceID);
                }
                switches[nSwitches++] = new PowerSwitch(port._powerPort.getName().getBytes(), deviceID);
            }
            ++i2;
        }
        System.out.println("getPowerSwitches(): returning " + switches.length + " switch objects");
        return switches;
    }

    public void scanPort(byte[] commPortName) throws DeviceNotFound, PortOccupiedException, PortNotFound, IOException, DuplicateIdException {
        System.out.println("NodeService.scanPort(" + new String(commPortName) + ")");
        PortManager.Port port = this._portManager.getPortByName(new String(commPortName));
        System.out.println("Got port...");
        this._portManager.scanPort(port);
    }

    public void scanPorts() {
        this._portManager.scanPorts();
    }

    public int powerOff() {
        return 0;
    }

    public int getStatus() {
        return 0;
    }

    public int test() {
        return 0;
    }

    public Location getLocation() throws UnknownLocationException {
        throw new UnknownLocationException("getLocation() not implemented");
    }

    public byte[] getMetadata() {
        return "Not implemented".getBytes();
    }

    public PortConfiguration[] getPortConfiguration() {
        int nPorts = 0;
        int i = 0;
        while (i < this._ports.size()) {
            PortManager.Port port = (PortManager.Port)this._ports.get(i);
            if (port._service != null) {
                ++nPorts;
            }
            ++i;
        }
        PortConfiguration[] configuration = new PortConfiguration[nPorts];
        int j = 0;
        int i2 = 0;
        while (i2 < this._ports.size()) {
            PortManager.Port port = (PortManager.Port)this._ports.get(i2);
            if (port._service != null) {
                configuration[j] = new PortConfiguration();
                configuration[j++].set(port._service.getId(), port._serialPortName.getBytes());
            }
            ++i2;
        }
        return configuration;
    }

    public Device getDevice(long deviceID) throws DeviceNotFound {
        int i = 0;
        while (i < this._ports.size()) {
            PortManager.Port port = (PortManager.Port)this._ports.get(i);
            if (port._service != null && deviceID == port._service.getId()) {
                return port._service;
            }
            ++i;
        }
        throw new DeviceNotFound(Long.toString(deviceID) + " not found");
    }

    public Device[] getDevices() {
        int nServices = 0;
        int i = 0;
        while (i < this._ports.size()) {
            PortManager.Port port = (PortManager.Port)this._ports.get(i);
            if (port._service != null) {
                ++nServices;
            }
            ++i;
        }
        Device[] devices = new Device[nServices];
        int j = 0;
        int i2 = 0;
        while (i2 < this._ports.size()) {
            PortManager.Port port = (PortManager.Port)this._ports.get(i2);
            if (port._service != null) {
                devices[j++] = port._service;
            }
            ++i2;
        }
        return devices;
    }

    public DevicePacketSet getDevicePackets(long deviceID, long startTime, long endTime) throws DeviceNotFound, NoDataException {
        DeviceService device = null;
        if (this.getId() == deviceID) {
            return NodeManager.getInstance()._log.getPacketKeyRange(startTime, endTime, 100);
        }
        int i = 0;
        while (i < this._ports.size()) {
            PortManager.Port port = (PortManager.Port)this._ports.get(i);
            if (port._service != null && deviceID == port._service.getId()) {
                device = port._service;
            }
            ++i;
        }
        if (device == null) {
            throw new DeviceNotFound(Long.toString(deviceID) + " not found");
        }
        if (!(device instanceof InstrumentService)) {
            throw new NoDataException("Device " + deviceID + " is not an InstrumentService");
        }
        InstrumentService instrument = (InstrumentService)device;
        return instrument.getPackets(startTime, endTime);
    }

    public void suspendService(byte[] portName) throws RemoteException, PortNotFound, DeviceNotFound {
        Device device = this.getDevice(portName);
        device.suspend();
    }

    public void resumeService(byte[] portName) throws RemoteException, PortNotFound, DeviceNotFound {
        Device device = this.getDevice(portName);
        device.resume();
    }

    public RemoteSerialPort getRemoteSerialPort(byte[] portName) throws RemoteException, UnknownHostException, PortNotFound, PortOccupiedException, IOException {
        DeviceService deviceService = this._portManager.getPortByName((String)new String((byte[])portName))._service;
        if (deviceService == null) {
            throw new IOException("could not get a RemoteSerialPort, the associated Device was null");
        }
        if (deviceService.getStatus() != 4) {
            throw new IOException("service on port " + new String(portName) + " not suspended");
        }
        return deviceService.getRemoteSerialPort();
    }

    public RemoteSerialPort getRemoteSerialPort(byte[] portName, int timeout) throws RemoteException, UnknownHostException, PortNotFound, PortOccupiedException, RangeException, IOException {
        DeviceService deviceService = this._portManager.getPortByName((String)new String((byte[])portName))._service;
        if (deviceService == null) {
            throw new IOException("could not get a RemoteSerialPort, the associated Device was null");
        }
        if (deviceService.getStatus() != 4) {
            throw new IOException("service on port " + new String(portName) + " not suspended");
        }
        return deviceService.getRemoteSerialPort(timeout);
    }

    public byte[] getSchedule() throws RemoteException {
        return this.getSchedule(30L);
    }

    public byte[] getSchedule(long lookAheadSeconds) throws RemoteException {
        Scheduler s = Scheduler.getInstance();
        String schedule = s.showSchedule(lookAheadSeconds);
        return schedule.getBytes();
    }

    public byte[] addSchedule(byte[] scheduleFile, boolean overwrite) throws RemoteException {
        Scheduler s = Scheduler.getInstance();
        int i = s.addSchedule(new String(scheduleFile), overwrite);
        return Scheduler.getStatusString(i).getBytes();
    }

    public byte[] removeSchedule(byte[] scheduleFile) throws RemoteException {
        Scheduler s = Scheduler.getInstance();
        int i = s.removeSchedule(new String(scheduleFile));
        return Scheduler.getStatusString(i).getBytes();
    }

    public byte[] addScheduleEntry(byte[] scheduleFile, long ownerID, byte[] entry) throws RemoteException {
        Scheduler s = Scheduler.getInstance();
        int i = s.addScheduleEntry(new String(scheduleFile), ownerID, new String(entry));
        return Scheduler.getStatusString(i).getBytes();
    }

    public byte[] removeScheduleEntry(byte[] scheduleFile, int entryIndex) throws RemoteException {
        Scheduler s = Scheduler.getInstance();
        int i = s.removeScheduleEntry(new String(scheduleFile), entryIndex);
        return Scheduler.getStatusString(i).getBytes();
    }

    public byte[] suspendScheduleEntry(byte[] scheduleFile, int entryIndex) throws RemoteException {
        Scheduler s = Scheduler.getInstance();
        int i = s.suspendScheduleEntry(new String(scheduleFile), entryIndex);
        return Scheduler.getStatusString(i).getBytes();
    }

    public byte[] resumeScheduleEntry(byte[] scheduleFile, int entryIndex) throws RemoteException {
        Scheduler s = Scheduler.getInstance();
        int i = s.resumeScheduleEntry(new String(scheduleFile), entryIndex);
        return Scheduler.getStatusString(i).getBytes();
    }

    public byte[] syncScheduleEntry(int index, long delayMillis) throws RemoteException {
        Scheduler s = Scheduler.getInstance();
        int i = s.sync(index, delayMillis);
        return Scheduler.getStatusString(i).getBytes();
    }

    void checkLeaseManager() throws LeaseRefused {
        if (this._leaseManager == null) {
            throw new LeaseRefused("Lease Manager not found");
        }
    }

    public int establishLease(long leaseMillisec) throws RemoteException, LeaseRefused {
        this.checkLeaseManager();
        return this._leaseManager.establish(leaseMillisec);
    }

    public void renewLease(int leaseID, long leaseMillisec) throws RemoteException, LeaseRefused {
        this.checkLeaseManager();
        this._leaseManager.renew(leaseID, leaseMillisec);
    }

    public void terminateLease(int leaseID, long nextConnectTime) throws RemoteException {
        if (this._leaseManager != null) {
            this._leaseManager.terminate(leaseID, nextConnectTime);
        }
    }

    public void terminateLease(int leaseID) throws RemoteException {
        this.terminateLease(leaseID, 0L);
    }

    public void notifyPortalLinkConnected() throws RemoteException {
        this._portalProxy = this.getPortalProxy();
        if (this._portalProxy != null) {
            this._portalProxy.nodeLinkConnected();
        }
    }

    public void notifyPortalLinkDisconnecting(long nextConnectTime) throws RemoteException {
        this._portalProxy = this.getPortalProxy();
        if (this._portalProxy != null) {
            this._portalProxy.nodeLinkDisconnecting(nextConnectTime);
        }
    }

    PortalProxy getPortalProxy() {
        if (this._portalURL == null) {
            return null;
        }
        System.out.println("Looking for Portal Server at " + this._portalURL);
        try {
            return (PortalProxy)Naming.lookup(this._portalURL);
        }
        catch (Exception e) {
            System.err.println("Couldn't find portal: " + e.getMessage());
            return null;
        }
    }
}

