/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import moos.deployed.PortManager;
import moos.deployed.SiamProperties;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;

public class NodeProperties
extends SiamProperties {
    protected static final String NODEID_KEY = "nodeID";
    protected static final String PORTNAMES_KEY = "platformSerialPorts";
    protected static final String SERVICEJAR_DIRECTORY_KEY = "jarLocation";
    protected static final String DEVICELOG_DIRECTORY_KEY = "logLocation";
    protected static final String CODEBASE_DIRECTORY_KEY = "codeBaseLocation";
    protected static final String ADVERTISE_SERVICE_KEY = "advertiseService";

    public String getPortNames() throws MissingPropertyException, InvalidPropertyException {
        return this.getRequiredProperty(PORTNAMES_KEY);
    }

    public String getServiceJarDirectory() throws MissingPropertyException, InvalidPropertyException {
        return this.getRequiredProperty(SERVICEJAR_DIRECTORY_KEY);
    }

    public String getDeviceLogDirectory() throws MissingPropertyException, InvalidPropertyException {
        return this.getRequiredProperty(DEVICELOG_DIRECTORY_KEY);
    }

    public String getCodebaseDirectory() throws MissingPropertyException, InvalidPropertyException {
        return this.getRequiredProperty(CODEBASE_DIRECTORY_KEY);
    }

    public PortManager.Port getPort(int index) throws MissingPropertyException {
        String jarName;
        boolean hasPowerPort = false;
        String serialName = this.getRequiredProperty("serialPort" + index);
        String powerName = this.getRequiredProperty("powerPort" + index);
        if (powerName.equals("DPA")) {
            hasPowerPort = true;
        }
        if ((jarName = this.getProperty("serviceJar" + index)) == null) {
            jarName = "";
        }
        return new PortManager.Port(serialName, hasPowerPort, jarName, null);
    }

    public long getNodeID() throws MissingPropertyException, InvalidPropertyException {
        long id;
        String idString = this.getRequiredProperty(NODEID_KEY);
        try {
            id = Long.parseLong(idString);
            if (id < 0L) {
                throw new InvalidPropertyException("getNodeID:Invalid Node ID; must be > 0");
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException("getNodeID:Invalid Node ID; must be long, > 0");
        }
        return id;
    }
}

