/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import java.util.Vector;
import moos.deployed.DebugMessage;
import moos.deployed.DeviceLog;
import moos.deployed.Location;
import moos.deployed.NodeProperties;
import moos.deployed.NodeService;
import moos.deployed.PortManager;
import moos.deployed.PowerManager;
import moos.deployed.Scheduler;
import moos.deployed.SleepManager;
import org.mbari.isi.interfaces.DeviceMessagePacket;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.Parent;

public class NodeManager
implements Parent {
    protected static String _releaseName = new String("$Name:  $");
    protected long _nodeID = -1L;
    protected PortManager _portManager = null;
    protected NodeService _nodeService = null;
    protected PowerManager _powerManager = null;
    protected SleepManager _sleepManager = null;
    protected static NodeManager _theNodeManager = null;
    protected NodeProperties _nodeProperties = null;
    protected String _siamHome = null;
    protected DeviceLog _log = null;
    private DeviceMessagePacket _messagePacket = null;

    public static synchronized NodeManager getInstance() {
        if (_theNodeManager == null) {
            try {
                _theNodeManager = new NodeManager();
            }
            catch (IOException e) {
                System.err.println("IOException: " + e.getMessage());
                System.exit(1);
            }
            catch (MissingPropertyException e) {
                System.err.println("MissingPropertyException: " + e.getMessage());
                System.exit(1);
            }
            catch (InvalidPropertyException e) {
                System.err.println("InvalidPropertyException: " + e.getMessage());
                System.exit(1);
            }
        }
        return _theNodeManager;
    }

    NodeManager() throws IOException, MissingPropertyException, InvalidPropertyException {
        System.out.println("Starting NodeManager: " + _releaseName);
        long level = DebugMessage.getLevel();
        DebugMessage.setLevel(0L);
        this._nodeProperties = new NodeProperties();
        FileInputStream in = new FileInputStream(this.getSiamHome() + "/properties/siamPort.cfg");
        this._nodeProperties.load(in);
        in.close();
        this._nodeID = this._nodeProperties.getNodeID();
        DebugMessage.println("Node ID has been set to " + this._nodeID);
        DebugMessage.println("create node log");
        this._log = new DeviceLog(this.getId(), this._nodeProperties.getDeviceLogDirectory());
        this._messagePacket = new DeviceMessagePacket(this.getId());
        DebugMessage.setLevel(level);
    }

    void start(String name, String portalHost) throws IOException, InvalidPropertyException, MissingPropertyException {
        try {
            try {
                System.out.print("Starting registry... ");
                LocateRegistry.createRegistry(1099);
                System.out.println("registry started.");
            }
            catch (RemoteException e) {
                System.err.println(e.getMessage());
            }
            String url = name;
            System.out.println("Binding NodeManager to " + url + "...");
            this._portManager = new PortManager(this.getSiamHome(), this._nodeProperties);
            this._nodeService = new NodeService(this._portManager, portalHost);
            this._powerManager = new PowerManager();
            this._sleepManager = SleepManager.getInstance();
            Naming.bind(url, this._nodeService);
            System.out.println("NodeManager is bound to " + url);
        }
        catch (RemoteException e) {
            System.err.println("NodeManager: Caught RemoteException:");
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            System.err.println("NodeManager: Caught Exception:");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        Scheduler s = Scheduler.getInstance();
        Scheduler.loadDefaults();
        this._portManager.scanPorts();
        this._sleepManager.start();
        this._nodeService.startComms();
        System.out.println("NodeService \"" + name + "\" is ready.");
    }

    protected long getId() {
        return this._nodeID;
    }

    protected NodeProperties getNodeProperties() {
        return this._nodeProperties;
    }

    protected String getSiamHome() throws MissingPropertyException {
        Properties sysProperties = System.getProperties();
        String home = sysProperties.getProperty("siam_home");
        if (home == null) {
            throw new MissingPropertyException("siam_home");
        }
        return home.trim();
    }

    protected void logMessage(String message) {
        this._messagePacket.setMessage(System.currentTimeMillis(), message.getBytes());
        this._log.appendPacket(this._messagePacket);
    }

    public PortManager getPortManager() {
        return this._portManager;
    }

    public NodeService getNodeService() {
        return this._nodeService;
    }

    protected void logNodeConfiguration(String prefix) {
        String message = prefix + ":\n";
        Vector ports = this._portManager.getPorts();
        int i = 0;
        while (i < ports.size()) {
            PortManager.Port port = (PortManager.Port)ports.elementAt(i);
            if (port._service != null) {
                message = message + "ch=" + port._serialPortName + ", isiID=" + port._service.getId() + "\n";
            }
            ++i;
        }
        this.logMessage(message);
    }

    public long getParentId() throws RemoteException {
        return this.getId();
    }

    public Location getLocation(long isiId) throws RemoteException {
        return new Location("I'm With Stupid");
    }
}

