/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import moos.deployed.DebugMessage;

public class LddMaster {
    public static final String LDD_DEVICE_NAME = "/dev/lddio";
    public static final String LDD_SET_BITS = "+";
    public static final String LDD_CLEAR_BITS = "-";
    public static final String LDD_WRITE_LEVELS = "=";
    public static final String LDD_SET_INPUT = "I";
    public static final String LDD_SET_OUTPUT = "O";
    public static final String LDD_WRITE_DIRECTION = ":";
    public static final String LDD_SET_READMODE_LEVELS = "L";
    public static final String LDD_SET_READMODE_STENCIL = "S";
    public static final String LDD_SET_READMODE_DIRECTION = "V";
    public static final String LDD_SET_READMODE_READMODE = "R";
    public static final int LDD_BITS = 4095;
    public static final int LDD_RED_LED = 1;
    public static final int LDD_YELLOW_LED = 2;
    public static final int LDD_GREEN_LED = 4;
    public static final int LDD_RS485_RCV = 8;
    public static final int LDD_RS485_DRV = 16;
    public static final int LDD_RF1_POWER = 32;
    public static final int LDD_RF2_POWER = 64;
    public static final int LDD_ATTN_MSP430 = 128;
    public static final int LDD_UNUSED = 3840;
    public static final int LDD_DIRECTION_INPUT = 0;
    public static final int LDD_DIRECTION_OUTPUT = 1;
    public static final int LDD_READMODE_LEVELS = 0;
    public static final int LDD_READMODE_STENCIL = 1;
    public static final int LDD_READMODE_DIRECTION = 2;
    public static final int LDD_READMODE_READMODE = 3;
    public static final int LDD_STENCIL = 248;
    private static int _readMode = 0;
    private static LddMaster cInstance = new LddMaster();
    private static RandomAccessFile lddDevice;

    public static synchronized LddMaster getInstance() {
        if (cInstance != null) {
            return cInstance;
        }
        DebugMessage.println("LddMaster.getInstance() no instance -- returning null");
        return null;
    }

    public void writeLdd(String data) {
        try {
            lddDevice.writeBytes(data);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open device:  /dev/lddio");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public int readLdd() {
        int result = -1;
        try {
            String inData = lddDevice.readLine();
            result = Integer.parseInt(inData, 16);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open device:  /dev/lddio");
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return result;
    }

    public int readStenciledLdd() {
        return this.readLdd() & 0xF8;
    }

    public int applyStencil(int mask) {
        return mask & 0xF8;
    }

    public void setDirection(int mask, int direction) {
        int PPDRo = this.getDirection();
        int maskedStencil = this.applyStencil(mask);
        switch (direction) {
            case 0: {
                this.writeLdd(Integer.toHexString(PPDRo & maskedStencil) + LDD_SET_INPUT);
                break;
            }
            case 1: {
                this.writeLdd(Integer.toHexString(PPDRo | maskedStencil) + LDD_SET_OUTPUT);
                break;
            }
            default: {
                System.err.println("LddMaster: Invalid direction specified: " + direction);
            }
        }
    }

    public int getDirection() {
        this.setReadMode(2);
        return this.readLdd();
    }

    public int getLevels() {
        this.setReadMode(0);
        return this.readLdd();
    }

    public void setReadMode(int readMode) {
        switch (readMode) {
            case 0: {
                this.writeLdd(LDD_SET_READMODE_LEVELS);
                break;
            }
            case 1: {
                this.writeLdd(LDD_SET_READMODE_STENCIL);
                break;
            }
            case 2: {
                this.writeLdd(LDD_SET_READMODE_DIRECTION);
                break;
            }
            case 3: {
                this.writeLdd(LDD_SET_READMODE_READMODE);
                break;
            }
            default: {
                System.err.println("Invalid readMode: (" + readMode + ")");
            }
        }
    }

    public synchronized int getReadMode() {
        this.setReadMode(3);
        return this.readLdd();
    }

    public void writeLevels(int mask) {
        int PPSRo = this.getLevels();
        int maskedStencil = this.applyStencil(mask);
        int writeVal = PPSRo & 0xFFFFFF07 | maskedStencil;
        this.setDirection(248, 1);
        this.writeLdd(Integer.toHexString(writeVal) + LDD_WRITE_LEVELS);
    }

    public void writeDirection(int mask) {
        int PPDRo = this.getDirection();
        int maskedStencil = this.applyStencil(mask);
        this.writeLdd(Integer.toHexString(PPDRo & 0xFFFFFF07 | maskedStencil) + LDD_WRITE_DIRECTION);
    }

    public void setBits(int mask) {
        int maskedStencil = this.applyStencil(mask);
        this.setDirection(maskedStencil, 1);
        this.writeLdd(Integer.toHexString(maskedStencil) + LDD_SET_BITS);
    }

    public void clearBits(int mask) {
        int maskedStencil = this.applyStencil(mask);
        this.setDirection(maskedStencil, 1);
        this.writeLdd(Integer.toHexString(maskedStencil) + LDD_CLEAR_BITS);
    }

    public int test() {
        int result = 0;
        int testCounter = 0;
        System.out.println("\nReading current state...");
        int PPDRo = this.getDirection();
        int PPSRo = this.getLevels();
        System.out.println("Initial State: PPSRo = " + Integer.toHexString(PPSRo) + " PPDRo = " + Integer.toHexString(PPDRo) + " stencil = " + Integer.toHexString(248) + "\n");
        int mask = ~this.getLevels();
        System.out.println("attempting PPSR writeLevels(" + Integer.toHexString(mask) + ")...");
        this.writeLevels(mask);
        int readback = this.getLevels();
        int test = mask & 0xF8;
        boolean passed = (readback & 0xF8) == test;
        System.out.println("read back = " + Integer.toHexString(readback));
        System.out.println(Integer.toHexString(readback & 0xF8) + "==" + Integer.toHexString(test) + "?");
        System.out.println((passed ? " PASS " : " FAIL ") + "\n");
        result |= (passed ? 0 : 1) << testCounter++;
        mask = this.getLevels();
        System.out.println("attempting PPSR clearBits(" + Integer.toHexString(mask) + ")...");
        this.clearBits(mask);
        readback = this.getLevels();
        test = mask & 0xF8 & ~mask;
        passed = (readback & 0xF8) == test;
        System.out.println("read back = " + Integer.toHexString(readback));
        System.out.println(Integer.toHexString(readback & 0xF8) + "==" + Integer.toHexString(test) + "?");
        System.out.println((passed ? " PASS " : " FAIL ") + "\n");
        result |= (passed ? 0 : 1) << testCounter++;
        mask = ~this.getLevels();
        System.out.println("attempting PPSR setBits(" + Integer.toHexString(mask) + ")...");
        this.setBits(mask);
        readback = this.getLevels();
        test = mask & 0xF8;
        passed = (readback & 0xF8) == test;
        System.out.println("read back = " + Integer.toHexString(readback));
        System.out.println(Integer.toHexString(readback & 0xF8) + "==" + Integer.toHexString(test) + "?");
        System.out.println((passed ? " PASS " : " FAIL ") + "\n");
        result |= (passed ? 0 : 1) << testCounter++;
        mask = ~this.getDirection();
        System.out.println("attempting PPDR writeDirection(" + Integer.toHexString(mask) + ")...");
        this.writeDirection(mask);
        readback = this.getDirection();
        test = mask & 0xF8;
        passed = (readback & 0xF8) == test;
        System.out.println("read back = " + Integer.toHexString(readback));
        System.out.println(Integer.toHexString(readback & 0xF8) + "==" + Integer.toHexString(test) + "?");
        System.out.println((passed ? " PASS " : " FAIL ") + "\n");
        result |= (passed ? 0 : 1) << testCounter++;
        mask = -1;
        System.out.println("attempting PPDR setDirection(" + Integer.toHexString(mask) + "," + 1 + ")...");
        this.setDirection(mask, 1);
        readback = this.getDirection();
        test = mask & 0xF8;
        passed = (readback & 0xF8) == test;
        System.out.println("read back = " + Integer.toHexString(readback));
        System.out.println(Integer.toHexString(readback & 0xF8) + "==" + Integer.toHexString(test) + "?");
        System.out.println((passed ? " PASS " : " FAIL ") + "\n");
        result |= (passed ? 0 : 1) << testCounter++;
        mask = -1;
        System.out.println("attempting PPDR setDirection(" + Integer.toHexString(mask) + "," + 0 + ")...");
        this.setDirection(mask, 0);
        readback = this.getDirection();
        test = mask & 0xF8 & ~mask;
        passed = (readback & 0xF8) == test;
        System.out.println("read back = " + Integer.toHexString(readback));
        System.out.println(Integer.toHexString(readback & 0xF8) + "==" + Integer.toHexString(test) + "?");
        System.out.println((passed ? " PASS " : " FAIL ") + "\n");
        result |= (passed ? 0 : 1) << testCounter++;
        mask = 0;
        System.out.println("attempting setReadmode(" + Integer.toHexString(mask) + ") Current readmode=" + this.getReadMode() + "...");
        this.setReadMode(mask);
        readback = this.getReadMode();
        test = mask;
        passed = readback == test;
        System.out.println("read back = " + Integer.toHexString(readback));
        System.out.println(Integer.toHexString(readback) + "==" + Integer.toHexString(test) + "?");
        System.out.println((passed ? " PASS " : " FAIL ") + "\n");
        result |= (passed ? 0 : 1) << testCounter++;
        System.out.println("Restoring state...");
        this.writeLevels(PPSRo);
        this.writeDirection(PPDRo);
        System.out.println("State restored: PPSR = " + Integer.toHexString(this.getLevels()) + " PPDR = " + Integer.toHexString(this.getDirection()));
        System.out.println("Done\n");
        return result;
    }

    public static void main(String[] args) {
        LddMaster ldd = LddMaster.getInstance();
        int result = ldd.test();
        System.out.println("LddMaster test exited with code " + Integer.toHexString(result));
        System.exit(result);
    }

    static {
        LddMaster ldd = LddMaster.getInstance();
        try {
            lddDevice = new RandomAccessFile(LDD_DEVICE_NAME, "rw");
            ldd.setReadMode(0);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open device:  /dev/lddio");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

