/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import moos.deployed.DebugMessage;
import moos.deployed.DeviceLog;
import moos.deployed.DeviceService;
import moos.deployed.InvalidPowerPolicy;
import moos.deployed.NodeProperties;
import moos.deployed.RangeException;
import moos.deployed.Schedule;
import moos.deployed.ScheduleEntry;
import moos.deployed.Scheduler;
import org.apache.log4j.Logger;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceMessagePacket;
import org.mbari.isi.interfaces.DevicePacketSet;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.InvalidDataException;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.Location;
import org.mbari.isi.interfaces.MetadataPacket;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.NoChildrenException;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.NoParentException;
import org.mbari.isi.interfaces.ScheduleParseException;
import org.mbari.isi.interfaces.ScheduleSpecifier;
import org.mbari.isi.interfaces.SensorDataPacket;
import org.mbari.isi.interfaces.TimeoutException;
import org.mbari.isi.interfaces.UnknownLocationException;

public abstract class InstrumentService
extends DeviceService
implements Instrument {
    static Logger _logger = Logger.getLogger((Class)(class$moos$deployed$InstrumentService == null ? (class$moos$deployed$InstrumentService = InstrumentService.class$("moos.deployed.InstrumentService")) : class$moos$deployed$InstrumentService));
    static final int DEFAULT_MAX_SAMPLE_TRIES = 3;
    static final long DEFAULT_SAMPLE_TIMEOUT = 1000L;
    static final byte[] DEFAULT_CONFIG_EOL = "\r".getBytes();
    static final int DEFAULT_MAX_CONFIG_BYTES = 512;
    static final int MAX_RETRIEVED_PACKETS = 10;
    protected boolean _initialized = false;
    private String _logDirectory = ".";
    DeviceMessagePacket _messagePacket = null;
    private long _sampleTimeout = 1000L;
    private int _maxSampleTries = 3;
    private int _maxSampleBytes = 0;
    private int _instrumentPowerPolicy = 0;
    private int _communicationPowerPolicy = 1;
    private int _currentLimit = 0;
    private int _maxSkipBytes = 256;
    private byte[] _promptString;
    private byte[] _sampleTerminator;
    private int _instrumentStartDelay;
    private byte[] _sampleBuf;
    protected SensorDataPacket _sensorDataPacket = null;
    protected SensorDataPacket _lastSample = null;
    protected DeviceLog _packetLog = null;
    protected ScheduleSpecifier _sampleSchedule = null;
    static /* synthetic */ Class class$moos$deployed$InstrumentService;

    protected abstract int initInstrumentPowerPolicy();

    protected abstract int initCommunicationPowerPolicy();

    protected abstract int initInstrumentStartDelay();

    protected abstract int initCurrentLimit();

    protected abstract byte[] initSampleTerminator();

    protected abstract byte[] initPromptString();

    protected abstract int initMaxSampleBytes();

    public InstrumentService() throws RemoteException {
        DebugMessage.setLevel(0L);
    }

    protected final byte[] getPromptString() {
        return this._promptString;
    }

    protected final void setPromptString(byte[] promptString) {
        this._promptString = new byte[promptString.length];
        System.arraycopy(promptString, 0, this._promptString, 0, promptString.length);
    }

    protected final byte[] getSampleTerminator() {
        return this._sampleTerminator;
    }

    protected final void setSampleTerminator(byte[] sampleTerminator) {
        this._sampleTerminator = new byte[sampleTerminator.length];
        System.arraycopy(sampleTerminator, 0, this._sampleTerminator, 0, sampleTerminator.length);
    }

    protected final long getSampleTimeout() {
        return this._sampleTimeout;
    }

    protected final void setSampleTimeout(long timeout) throws RangeException {
        if (timeout < 0L) {
            throw new RangeException("argument must be non-negative");
        }
        this._sampleTimeout = timeout;
    }

    protected final int getMaxSampleTries() {
        return this._maxSampleTries;
    }

    protected final int getMaxSkipBytes() {
        return this._maxSkipBytes;
    }

    protected final void setMaxSampleTries(int maxTries) throws RangeException {
        if (maxTries <= 0) {
            throw new RangeException("argument must be positive");
        }
        this._maxSampleTries = maxTries;
    }

    protected final int getMaxSampleBytes() {
        return this._maxSampleBytes;
    }

    protected final void setMaxSampleBytes(int maxBytes) throws RangeException {
        if (maxBytes <= 0) {
            throw new RangeException("argument must be positive");
        }
        this._maxSampleBytes = maxBytes;
        this._sampleBuf = null;
        this._sampleBuf = new byte[this._maxSampleBytes];
    }

    protected final byte[] getSampleBuf() {
        return this._sampleBuf;
    }

    public final SensorDataPacket getLastSample() throws NoDataException, RemoteException {
        if (this._lastSample == null) {
            throw new NoDataException("getLastSample: Last Sample is NULL");
        }
        return this._lastSample;
    }

    protected final int getCurrentLimit() {
        return this._currentLimit;
    }

    protected final void setCurrentLimit(int milliamps) throws RangeException {
        if (milliamps <= 0) {
            throw new RangeException("argument must be positive");
        }
        this._currentLimit = milliamps;
    }

    protected final int getInstrumentPowerPolicy() {
        return this._instrumentPowerPolicy;
    }

    protected final void setInstrumentPowerPolicy(int powerPolicy) throws InvalidPowerPolicy {
        this.checkPowerPolicy(powerPolicy);
        this._instrumentPowerPolicy = powerPolicy;
    }

    protected final int getCommunicationPowerPolicy() {
        return this._communicationPowerPolicy;
    }

    protected final void setCommunicationPowerPolicy(int powerPolicy) throws InvalidPowerPolicy {
        this.checkPowerPolicy(powerPolicy);
        this._communicationPowerPolicy = powerPolicy;
    }

    protected final int getInstrumentStartDelay() {
        return this._instrumentStartDelay;
    }

    protected final void setInstrumentStartDelay(int millisec) throws RangeException {
        if (millisec < 0) {
            throw new RangeException("argument must be non-negative");
        }
        this._instrumentStartDelay = millisec;
    }

    public void initializePropertyDefaults() throws InitializeException {
        try {
            this.setPromptString(this.initPromptString());
            this.setSampleTerminator(this.initSampleTerminator());
            this.setMaxSampleBytes(this.initMaxSampleBytes());
            this.setCurrentLimit(this.initCurrentLimit());
            this.setInstrumentPowerPolicy(this.initInstrumentPowerPolicy());
            this.setCommunicationPowerPolicy(this.initCommunicationPowerPolicy());
            this.setInstrumentStartDelay(this.initInstrumentStartDelay());
        }
        catch (InvalidPowerPolicy e) {
            throw new InitializeException("InvalidPowerPolicy: " + e.getMessage());
        }
        catch (RangeException e) {
            throw new InitializeException("RangeException: " + e.getMessage());
        }
    }

    public final void initialize() throws InitializeException {
        super.initialize();
        this.setStatusInitial();
        this._sensorDataPacket = new SensorDataPacket(this.getId(), this._maxSampleBytes);
        try {
            _logger.debug((Object)("Driver: " + new String(this.getName()) + " initializing port " + this._instrumentPort));
            this._instrumentPort.setCurrentLimit(this.getCurrentLimit());
        }
        catch (RangeException e) {
            throw new InitializeException("RangeException: " + e.getMessage());
        }
        _logger.debug((Object)"initialize(): Done with port initialization");
        try {
            this.initializeInstrument();
        }
        catch (Exception e) {
            throw new InitializeException("initializeInstrument() failed: " + e.getMessage());
        }
        try {
            if (this._sampleSchedule == null) {
                this._sampleSchedule = this.createDefaultSampleSchedule();
            }
        }
        catch (ScheduleParseException e) {
            throw new InitializeException("ScheduleParseException: " + e.getMessage());
        }
        _logger.debug((Object)"creating metadataPacket...");
        try {
            this.createMetadataPacket("Service Initialization", 31, true);
        }
        catch (Exception e) {
            _logger.warn((Object)("problem creating metadataPacket...that's OK " + e));
        }
        _logger.debug((Object)"done creating metadataPacket...");
        this.managePowerSleep();
        this.setStatusOk();
        this._initialized = true;
    }

    protected void prepareToSample() throws Exception {
    }

    protected void postSample() {
    }

    public synchronized SensorDataPacket getData() throws NoDataException {
        return this.acquireSample(true);
    }

    public synchronized SensorDataPacket acquireSample(boolean logSample) throws NoDataException {
        if (this.getStatus() == 4) {
            throw new NoDataException("service is suspended");
        }
        if (!this._initialized) {
            try {
                this.initialize();
            }
            catch (InitializeException e) {
                this.setStatusError();
                throw new NoDataException("initialize() failed: " + e.getMessage());
            }
        }
        this.setStatusSampling();
        this.managePowerWake();
        try {
            this.prepareToSample();
        }
        catch (Exception e) {
            this.setStatusError();
            throw new NoDataException(e.getMessage());
        }
        int tries = 0;
        while (tries < this._maxSampleTries) {
            block14: {
                try {
                    _logger.debug((Object)"Base: calling requestSample()\n");
                    this.requestSample();
                    _logger.debug((Object)"Base: calling readSample()\n");
                    int nBytes = this.readSample(this._sampleBuf);
                    if (nBytes <= 0) {
                        _logger.error((Object)"readSample() failed");
                        break block14;
                    }
                    this.validateSample(this._sampleBuf, nBytes);
                    _logger.debug((Object)"Base: calling processSample() \n");
                    SensorDataPacket dataPacket = this.processSample(this._sampleBuf, nBytes);
                    this.postSample();
                    this.managePowerSleep();
                    if (logSample) {
                        this._packetLog.appendPacket(dataPacket);
                        this._lastSample = dataPacket;
                    }
                    this.setStatusOk();
                    this.printData(dataPacket.dataBuffer());
                    return dataPacket;
                }
                catch (InvalidDataException e) {
                    _logger.error((Object)(new String(this.getName()) + "acquireSample(): " + e));
                }
                catch (TimeoutException e) {
                    _logger.error((Object)(new String(this.getName()) + ".getData(): TimeoutException"));
                }
                catch (IOException e) {
                    _logger.error((Object)(new String(this.getName()) + ".getData(): IOException"), (Throwable)e);
                }
                catch (Exception e) {
                    _logger.error((Object)(new String(this.getName()) + ".getData(): Exception"), (Throwable)e);
                }
                Thread.yield();
            }
            ++tries;
        }
        this.setStatusError();
        this.postSample();
        this.managePowerSleep();
        _logger.error((Object)(new String(this.getName()) + ": Retry limit exceeded (retries=" + tries + ")"));
        String retryMsg = new String(this.getName()) + ": Retry limit exceeded (retries=" + tries + ")";
        throw new NoDataException(retryMsg);
    }

    protected int skipUntil(InputStream istream, byte[] terminator, long timeout) throws TimeoutException, IOException, NullPointerException, Exception {
        if (terminator == null) {
            return 0;
        }
        byte[] buf = new byte[this._maxSkipBytes];
        return this.readUntil(istream, buf, terminator, timeout);
    }

    private void checkReadUntilArgs(InputStream input, byte[] output, byte[] terminator) throws NullPointerException {
        if (input == null) {
            throw new NullPointerException("readUntil called with null InputStream");
        }
        if (output == null) {
            throw new NullPointerException("readUntil called with null output buffer");
        }
        if (terminator == null) {
            throw new NullPointerException("readUntil called with null terminator");
        }
    }

    private void checkSkipUntilArgs(InputStream input, byte[] terminator) throws NullPointerException {
        if (input == null) {
            throw new NullPointerException("skipUntil called with null InputStream");
        }
        if (terminator == null) {
            throw new NullPointerException("skipUntil called with null terminator");
        }
    }

    protected boolean foundTerminator(byte[] buffer, int totalBytesRead, byte[] terminator) {
        int termSz = terminator.length;
        if (totalBytesRead < termSz) {
            return false;
        }
        int offset = totalBytesRead - termSz;
        boolean matches = false;
        int i = 0;
        while (i < termSz) {
            if (buffer[i + offset] != terminator[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int readUntil(InputStream instream, byte[] outbuf, byte[] terminator, long timeout) throws TimeoutException, NullPointerException, IOException, Exception {
        int n;
        int bytesRead = 0;
        long elapsed = 0L;
        try {
            block4: {
                this.checkReadUntilArgs(instream, outbuf, terminator);
                long t0 = System.currentTimeMillis();
                byte lastbyte = terminator[terminator.length - 1];
                do {
                    if (instream.available() <= 0) continue;
                    int c = instream.read();
                    outbuf[bytesRead++] = (byte)c;
                    if (c != lastbyte || !this.foundTerminator(outbuf, bytesRead, terminator)) {
                        if (bytesRead < outbuf.length) continue;
                        throw new Exception("Output buf in instrument driver exceeded (buffer max length is " + outbuf.length + ")");
                    }
                    break block4;
                } while ((elapsed = System.currentTimeMillis() - t0) <= timeout);
                throw new TimeoutException("Timed out");
            }
            n = bytesRead - terminator.length;
            Object var15_11 = null;
        }
        catch (Throwable throwable) {
            Object var15_12 = null;
            _logger.debug((Object)"leaving readUntil");
            _logger.debug((Object)("bytesRead = " + bytesRead));
            _logger.debug((Object)("outbuf len = " + outbuf.length));
            _logger.debug((Object)("elapsed = " + elapsed));
            throw throwable;
        }
        _logger.debug((Object)"leaving readUntil");
        _logger.debug((Object)("bytesRead = " + bytesRead));
        _logger.debug((Object)("outbuf len = " + outbuf.length));
        _logger.debug((Object)("elapsed = " + elapsed));
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int skipUntil(InputStream instream, byte[] terminator, long timeout, int maxBytes) throws TimeoutException, NullPointerException, IOException, Exception {
        int n;
        _logger.debug((Object)("entring skipUntil(terminator: " + new String(terminator) + " )"));
        int bytesSkipped = 0;
        long elapsed = 0L;
        try {
            block4: {
                this.checkSkipUntilArgs(instream, terminator);
                long t0 = System.currentTimeMillis();
                int i = 0;
                do {
                    if (instream.available() > 0) {
                        int c = instream.read();
                        i = c == terminator[i] ? ++i : 0;
                        ++bytesSkipped;
                        if (i == terminator.length) break block4;
                    }
                    if (maxBytes <= 0 || bytesSkipped < maxBytes) continue;
                    throw new Exception("Exceeded maxBytes");
                } while (timeout <= 0L || (elapsed = System.currentTimeMillis() - t0) <= timeout);
                throw new TimeoutException("Timed out");
            }
            _logger.debug((Object)("SkipUntil(): found terminator: " + new String(terminator)));
            n = bytesSkipped - terminator.length;
            Object var15_11 = null;
        }
        catch (Throwable throwable) {
            Object var15_12 = null;
            _logger.debug((Object)"leaving skipUntil");
            _logger.debug((Object)("bytesSkipped = " + bytesSkipped));
            _logger.debug((Object)("elapsed = " + elapsed));
            throw throwable;
        }
        _logger.debug((Object)"leaving skipUntil");
        _logger.debug((Object)("bytesSkipped = " + bytesSkipped));
        _logger.debug((Object)("elapsed = " + elapsed));
        return n;
    }

    protected long flushInput() throws IOException {
        return this._fromDevice.skip(this._fromDevice.available());
    }

    protected void managePowerWake() {
        switch (this._instrumentPowerPolicy) {
            case 0: {
                this._instrumentPort.disconnectPower();
                break;
            }
            case 1: 
            case 2: {
                this._instrumentPort.connectPower();
                break;
            }
        }
        switch (this._communicationPowerPolicy) {
            case 0: {
                this._instrumentPort.disableCommunications();
                break;
            }
            case 1: 
            case 2: {
                this._instrumentPort.enableCommunications();
                break;
            }
        }
    }

    protected void managePowerSleep() {
        switch (this._instrumentPowerPolicy) {
            case 0: 
            case 1: {
                this._instrumentPort.disconnectPower();
                break;
            }
            case 2: {
                this._instrumentPort.connectPower();
                break;
            }
        }
        switch (this._communicationPowerPolicy) {
            case 0: 
            case 1: {
                try {
                    this._toDevice.flush();
                }
                catch (Exception e) {
                    _logger.error((Object)"Error flushing output");
                }
                this._instrumentPort.disableCommunications();
                break;
            }
            case 2: {
                this._instrumentPort.enableCommunications();
                break;
            }
        }
    }

    protected abstract void requestSample() throws TimeoutException, Exception;

    protected int readSample(byte[] sample) throws TimeoutException, IOException, Exception {
        return this.readUntil(this._fromDevice, sample, this._sampleTerminator, this._sampleTimeout);
    }

    protected void validateSample(byte[] _sampleBuf, int nBytes) throws InvalidDataException {
    }

    protected SensorDataPacket processSample(byte[] sample, int nBytes) throws Exception {
        byte[] buf;
        this._sensorDataPacket.setSystemTime(System.currentTimeMillis());
        if (nBytes != sample.length) {
            buf = new byte[nBytes];
            System.arraycopy(sample, 0, buf, 0, nBytes);
        } else {
            buf = sample;
        }
        this._sensorDataPacket.setDataBuffer(buf);
        return this._sensorDataPacket;
    }

    protected final void checkPowerPolicy(int policy) throws InvalidPowerPolicy {
        if (policy != 0 && policy != 1 && policy != 2) {
            throw new InvalidPowerPolicy();
        }
    }

    public byte[] getParentMetadata() {
        String retval = null;
        try {
            retval = "parentId = " + this._parentNode.getParentId();
            retval = retval + "\n";
            retval = retval + "location = " + this._parentNode.getLocation(this.getId());
            retval = retval + "\n";
        }
        catch (RemoteException e) {
            retval = "getParentMetadata: Remote Exception: " + e;
        }
        return retval.getBytes();
    }

    public byte[] getServiceStateMetadata() {
        String mdString = new String(super.getServiceStateMetadata());
        mdString = mdString + "prompt=\"";
        try {
            mdString = mdString + new String(this.getPromptString());
        }
        catch (NullPointerException e) {
            mdString = mdString + "N/A";
        }
        mdString = mdString + "\"\n";
        mdString = mdString + "sampleTerminator=\"";
        try {
            mdString = mdString + new String(this.getSampleTerminator());
        }
        catch (NullPointerException e) {
            mdString = mdString + "N/A";
        }
        mdString = mdString + "\"\n";
        mdString = mdString + "sampleSchedule=\"";
        try {
            mdString = mdString + new String(this.getScheduleByteArray());
        }
        catch (NullPointerException e) {
            mdString = mdString + "N/A";
        }
        mdString = mdString + "\"\n";
        mdString = mdString + "timeout=\"" + this.getSampleTimeout() + "\"\n";
        mdString = mdString + "maxSampleTries=\"" + this.getMaxSampleTries() + "\"\n";
        mdString = mdString + "maxSampleBytes=\"" + this.getMaxSampleBytes() + "\"\n";
        mdString = mdString + "maxSkipBytes=\"" + this.getMaxSkipBytes() + "\"\n";
        mdString = mdString + "instrumentStartDelay=\"" + this.getInstrumentStartDelay() + "\"\n";
        mdString = mdString + "currentLimit=\"" + this.getCurrentLimit() + "\"\n";
        mdString = mdString + "instrumentPowerPolicy=\"" + this.getInstrumentPowerPolicy() + "\"\n";
        mdString = mdString + "commsPowerPolicy=\"" + this.getCommunicationPowerPolicy() + "\"\n";
        return mdString.getBytes();
    }

    public byte[] getFileBytes(String file) throws FileNotFoundException, IOException, NullPointerException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (fis.available() > 0) {
            bos.write(fis.read());
        }
        fis.close();
        bos.close();
        byte[] retval = bos.toByteArray();
        return retval;
    }

    public byte[] getServiceXMLBytes() {
        byte[] retval;
        try {
            retval = this.getFileBytes(new String(this._serviceXMLPath));
        }
        catch (FileNotFoundException e) {
            _logger.debug((Object)("getServiceXMLBytes: File not found: " + new String(this._serviceXMLPath) + "\n" + e));
            retval = ("getServiceXMLBytes: File not found: " + new String(this._serviceXMLPath) + "\n").getBytes();
        }
        catch (IOException e) {
            _logger.debug((Object)("getServiceXMLBytes: IOException reading " + new String(this._serviceXMLPath) + "\n" + e));
            retval = ("getServiceXMLBytes: IOException reading " + new String(this._serviceXMLPath) + "\n").getBytes();
        }
        catch (NullPointerException e) {
            _logger.debug((Object)("getServiceXMLBytes: Null Pointer Exception: serviceXMLPath\n" + e));
            retval = "getServiceXMLBytes: Null Pointer Exception:ServiceXMLPath\n".getBytes();
        }
        catch (Exception e) {
            _logger.debug((Object)("getServiceXMLBytes: Exception:\n" + e));
            retval = ("getServiceXMLBytes: Exception:\n" + e + "\n").getBytes();
        }
        return retval;
    }

    public byte[] getServicePropertiesBytes() {
        byte[] retval;
        try {
            retval = this.getFileBytes(new String(this._servicePropertiesPath));
        }
        catch (FileNotFoundException e) {
            _logger.debug((Object)("getServicePropertiesBytes: File not found: " + new String(this._servicePropertiesPath)));
            retval = ("getServicePropertiesBytes: File not found: " + new String(this._servicePropertiesPath) + "\n").getBytes();
        }
        catch (IOException e) {
            _logger.debug((Object)("getServicePropertiesBytes: IOException reading " + new String(this._servicePropertiesPath) + "\n" + e));
            retval = ("getServicePropertiesBytes: IOException reading " + new String(this._servicePropertiesPath) + "\n").getBytes();
        }
        catch (NullPointerException e) {
            _logger.debug((Object)"getServicePropertiesBytes: Null Pointer Exception: servicePropertiesPath");
            retval = "getServicePropertiesBytes: Null Pointer Exception:ServicePropertiesPath\n".getBytes();
        }
        catch (Exception e) {
            _logger.debug((Object)("getServicePropertiesBytes: Exception: " + e));
            retval = ("getServicePropertiesBytes: Exception:\n" + e).getBytes();
        }
        return retval;
    }

    public byte[] getServiceCacheBytes() {
        byte[] retval;
        try {
            retval = this.getFileBytes(new String(this._serviceCachePath));
        }
        catch (FileNotFoundException e) {
            _logger.debug((Object)("getServiceCacheBytes: File not found: " + new String(this._serviceCachePath)));
            retval = ("getServiceCacheBytes: File not found: " + new String(this._serviceCachePath) + "\n").getBytes();
        }
        catch (IOException e) {
            _logger.debug((Object)("getServiceCacheBytes: IOException reading " + new String(this._serviceCachePath) + "\n" + e));
            retval = ("getServiceCacheBytes: IOException reading " + new String(this._serviceCachePath) + "\n").getBytes();
        }
        catch (NullPointerException e) {
            _logger.debug((Object)"getServiceCacheBytes: Null Pointer Exception: serviceCachePath");
            retval = "getServiceCacheBytes: Null Pointer Exception:ServiceCachePath\n".getBytes();
        }
        return retval;
    }

    public byte[] getMetadata() throws RemoteException {
        return this.getMetadataBytes(31);
    }

    protected byte[] getMetadataBytes(int components) throws RemoteException {
        byte[] buf = "You've got a problem in getMetadataBytes".getBytes();
        byte[] sep = "\n".getBytes();
        try {
            ByteArrayOutputStream mos = new ByteArrayOutputStream();
            buf = this.getParentMetadata();
            byte[] header = "<ParentMetadata>\n".getBytes();
            byte[] footer = "</ParentMetadata>\n".getBytes();
            mos.write(header, 0, header.length);
            mos.write(buf, 0, buf.length);
            mos.write(footer, 0, footer.length);
            mos.write(sep, 0, sep.length);
            if ((components & 1) > 0) {
                buf = this.getInstrumentStateMetadata();
                header = "<InstrumentState>\n".getBytes();
                footer = "</InstrumentState>\n".getBytes();
                mos.write(header, 0, header.length);
                mos.write(buf, 0, buf.length);
                mos.write(footer, 0, footer.length);
                mos.write(sep, 0, sep.length);
            }
            if ((components & 4) > 0) {
                header = "<InstrumentServiceState>\n".getBytes();
                footer = "</InstrumentServiceState>\n".getBytes();
                buf = this.getServiceStateMetadata();
                mos.write(header, 0, header.length);
                mos.write(buf, 0, buf.length);
                mos.write(footer, 0, footer.length);
                mos.write(sep, 0, sep.length);
            }
            if ((components & 8) > 0) {
                header = "<ServiceProperties>\n".getBytes();
                footer = "</ServiceProperties>\n".getBytes();
                buf = this.getServicePropertiesBytes();
                mos.write(header, 0, header.length);
                mos.write(buf, 0, buf.length);
                mos.write(footer, 0, footer.length);
                mos.write(sep, 0, sep.length);
            }
            if ((components & 2) > 0) {
                header = "<ServiceXML>\n".getBytes();
                footer = "</ServiceXML>\n".getBytes();
                buf = this.getServiceXMLBytes();
                mos.write(header, 0, header.length);
                mos.write(buf, 0, buf.length);
                mos.write(footer, 0, footer.length);
                mos.write(sep, 0, sep.length);
            }
            if ((components & 0x10) > 0) {
                header = "<ServiceCache>\n".getBytes();
                footer = "</ServiceCache>\n".getBytes();
                buf = this.getServiceCacheBytes();
                mos.write(header, 0, header.length);
                mos.write(buf, 0, buf.length);
                mos.write(footer, 0, footer.length);
                mos.write(sep, 0, sep.length);
            }
            buf = mos.toByteArray();
            mos.close();
        }
        catch (IOException e) {
            _logger.debug((Object)"getMetadataBytes: IOException: could not create output stream");
            buf = "getMetadataBytes: IOException: could not create output stream".getBytes();
        }
        catch (Exception e) {
            _logger.error((Object)("getMetadataBytes: Exception: " + e));
        }
        return buf;
    }

    public MetadataPacket createMetadataPacket(String cause, int components, boolean logPacket) throws RemoteException {
        MetadataPacket mp = new MetadataPacket(this.getId(), cause.getBytes(), this.getMetadataBytes(components));
        mp.setSystemTime(System.currentTimeMillis());
        if (logPacket) {
            this._packetLog.appendPacket(mp);
        }
        return mp;
    }

    protected byte[] getInstrumentStateMetadata() {
        String mdString = new String(this.getName() + " does not provide instrument state information\n");
        return mdString.getBytes();
    }

    protected byte[] getInstrumentMetadata() {
        return this.getInstrumentStateMetadata();
    }

    protected void initializeInstrument() throws InitializeException, Exception {
    }

    protected byte[] processConfigLine(byte[] configLine, int lineLen) {
        return "?".getBytes();
    }

    public int powerOff() {
        this._instrumentPort.disconnectPower();
        return 0;
    }

    public int powerOn() {
        this._instrumentPort.connectPower();
        return 0;
    }

    public Location getLocation() throws UnknownLocationException {
        throw new UnknownLocationException("Not implemented");
    }

    public synchronized void annotate(byte[] annotation) {
        _logger.debug((Object)"Annotation: ");
        String s = new String("<ConsoleSession>\n" + new String(annotation) + "</ConsoleSession>\n");
        _logger.debug((Object)s);
        this._messagePacket.setMessage(System.currentTimeMillis(), s.getBytes());
        this._packetLog.appendPacket(this._messagePacket);
    }

    public final byte[] getScheduleByteArray() {
        if (this._sampleSchedule.getScheduleTime() != null) {
            return this._sampleSchedule.getScheduleTime().getBytes();
        }
        return "".getBytes();
    }

    public Device getParent() throws NoParentException {
        throw new NoParentException("Not implemented");
    }

    public Device[] getChildren() throws NoChildrenException {
        throw new NoChildrenException("Not implemented");
    }

    public void setNodeProperties(NodeProperties nodeProperties) throws MissingPropertyException, InvalidPropertyException {
        super.setNodeProperties(nodeProperties);
        Properties systemProperties = System.getProperties();
        String siamHome = systemProperties.getProperty("siam_home").trim();
        String logDirectory = this._nodeProperties.getDeviceLogDirectory();
        this._logDirectory = siamHome + File.separator + logDirectory;
        _logger.debug((Object)("InstrumentService._logDirectory=" + this._logDirectory));
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        _logger.debug((Object)"*********************** Loading Properties ****************");
        super.loadProperties(input);
        this._packetLog = new DeviceLog(this.getId(), this._logDirectory);
        this._messagePacket = new DeviceMessagePacket(this.getId());
        try {
            try {
                this._instrumentPowerPolicy = this._serviceProperties.getDevicePowerPolicy();
                _logger.debug((Object)("powerPolicy: " + this._instrumentPowerPolicy));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
            try {
                this._communicationPowerPolicy = this._serviceProperties.getCommsPowerPolicy();
                _logger.debug((Object)("commsPolicy: " + this._communicationPowerPolicy));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
            try {
                this._maxSampleTries = this._serviceProperties.getSampleRetries();
                _logger.debug((Object)("sampleTries: " + this._maxSampleTries));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
            try {
                this._currentLimit = this._serviceProperties.getCurrentLimit();
                _logger.debug((Object)("currentLimit: " + this._currentLimit));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
            try {
                this._maxSkipBytes = this._serviceProperties.getMaxSkipBytes();
                _logger.debug((Object)("skipBytes: " + this._maxSkipBytes));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
            try {
                this._promptString = this._serviceProperties.getPromptString();
                _logger.debug((Object)("promptString: \"" + new String(this._promptString) + "\""));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
            try {
                this._sampleTerminator = this._serviceProperties.getSampleTerminator();
                _logger.debug((Object)("sampleTerminator: \"" + new String(this._sampleTerminator) + "\""));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
            try {
                this._instrumentStartDelay = this._serviceProperties.getStartDelay();
                _logger.debug((Object)("startDelay: " + this._instrumentStartDelay));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
            try {
                this._maxSampleBytes = this._serviceProperties.getMaxSampleBytes();
                this.setMaxSampleBytes(this._maxSampleBytes);
                _logger.debug((Object)("sampleBytes: " + this._maxSampleBytes));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
            try {
                this._sampleSchedule = this._serviceProperties.getSampleSchedule();
                _logger.debug((Object)("sampleSchedule: " + this._sampleSchedule));
            }
            catch (MissingPropertyException e) {
                _logger.debug((Object)e);
            }
        }
        catch (RangeException e) {
            _logger.error((Object)("loadProperties: RangeException:" + e));
        }
        _logger.debug((Object)"*********************** Properties Loaded ****************");
    }

    public synchronized void suspend() {
        super.suspend();
        if (this.getInstrumentPowerPolicy() != 0) {
            this._instrumentPort.connectPower();
        }
    }

    public synchronized void resume() {
        super.resume();
    }

    public DevicePacketSet getPackets(long startTime, long stopTime) throws NoDataException {
        return this._packetLog.getPacketKeyRange(startTime, stopTime, 10);
    }

    public byte[] getProperty(byte[] key) throws MissingPropertyException {
        String value = this._serviceProperties.getProperty(new String(key));
        if (value == null) {
            throw new MissingPropertyException(new String(key));
        }
        return value.getBytes();
    }

    public void setProperty(byte[] key, byte[] value) throws InvalidPropertyException {
        this._serviceProperties.setProperty(new String(key), new String(value));
    }

    public Vector getProperties() {
        Vector<byte[]> propList = new Vector<byte[]>();
        Enumeration<?> keys = this._serviceProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String entry = key + "=" + this._serviceProperties.getProperty(key);
            propList.addElement(entry.getBytes());
        }
        return propList;
    }

    protected abstract ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException;

    protected synchronized void sync(long delayMillis) {
        Scheduler scheduler = Scheduler.getInstance();
        Schedule defaultSampleSchedule = scheduler.getSchedule(scheduler.getDefaultSampleScheduleName());
        ScheduleEntry[] entries = scheduler.lookupScheduleEntries(defaultSampleSchedule, this.getId());
        _logger.error((Object)("Scheduler: sync(" + this.getId() + "," + delayMillis + ")"));
        if (entries[0] != null) {
            entries[0].sync(delayMillis);
        } else {
            _logger.error((Object)("InstrumentService.sync: No entry returned for ID " + this.getId()));
        }
    }

    protected void printData(byte[] buf) {
    }

    public abstract void setClock(long var1) throws RemoteException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

